/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.blacklist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.IScheduler;
import org.apache.storm.scheduler.SupervisorDetails;
import org.apache.storm.scheduler.Topologies;
import org.apache.storm.scheduler.WorkerSlot;
import org.apache.storm.scheduler.blacklist.reporters.IReporter;
import org.apache.storm.scheduler.blacklist.reporters.LogReporter;
import org.apache.storm.scheduler.blacklist.strategies.DefaultBlacklistStrategy;
import org.apache.storm.scheduler.blacklist.strategies.IBlacklistStrategy;
import org.apache.storm.shade.com.google.common.collect.EvictingQueue;
import org.apache.storm.shade.com.google.common.collect.Sets;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlacklistScheduler
implements IScheduler {
    public static final int DEFAULT_BLACKLIST_SCHEDULER_RESUME_TIME = 1800;
    public static final int DEFAULT_BLACKLIST_SCHEDULER_TOLERANCE_COUNT = 3;
    public static final int DEFAULT_BLACKLIST_SCHEDULER_TOLERANCE_TIME = 300;
    private static final Logger LOG = LoggerFactory.getLogger(BlacklistScheduler.class);
    private final IScheduler underlyingScheduler;
    private StormMetricsRegistry metricsRegistry;
    protected int toleranceTime;
    protected int toleranceCount;
    protected int resumeTime;
    protected IReporter reporter;
    protected IBlacklistStrategy blacklistStrategy;
    protected int nimbusMonitorFreqSecs;
    protected Map<String, Set<Integer>> cachedSupervisors;
    protected EvictingQueue<Map<String, Set<Integer>>> badSupervisorsToleranceSlidingWindow;
    protected EvictingQueue<Map<String, Integer>> sendAssignmentFailureCount;
    private final Map<String, Integer> assignmentFailures = new HashMap<String, Integer>();
    protected int windowSize;
    protected volatile Set<String> blacklistedSupervisorIds;
    private boolean blacklistOnBadSlots;
    private Map<String, Object> conf;
    private boolean blacklistSendAssignentFailures;

    public BlacklistScheduler(IScheduler underlyingScheduler) {
        this.underlyingScheduler = underlyingScheduler;
    }

    @Override
    public void prepare(Map<String, Object> conf, StormMetricsRegistry metricsRegistry) {
        LOG.info("Preparing black list scheduler");
        this.underlyingScheduler.prepare(conf, metricsRegistry);
        this.conf = conf;
        this.metricsRegistry = metricsRegistry;
        this.toleranceTime = ObjectReader.getInt((Object)this.conf.get("blacklist.scheduler.tolerance.time.secs"), (Integer)300);
        this.toleranceCount = ObjectReader.getInt((Object)this.conf.get("blacklist.scheduler.tolerance.count"), (Integer)3);
        this.resumeTime = ObjectReader.getInt((Object)this.conf.get("blacklist.scheduler.resume.time.secs"), (Integer)1800);
        this.blacklistSendAssignentFailures = ObjectReader.getBoolean((Object)this.conf.get("blacklist.scheduler.enable.send.assignment.failures"), (boolean)false);
        String reporterClassName = ObjectReader.getString((Object)this.conf.get("blacklist.scheduler.reporter"), (String)LogReporter.class.getName());
        this.reporter = (IReporter)this.initializeInstance(reporterClassName, "blacklist reporter");
        String strategyClassName = ObjectReader.getString((Object)this.conf.get("blacklist.scheduler.strategy"), (String)DefaultBlacklistStrategy.class.getName());
        this.blacklistStrategy = (IBlacklistStrategy)this.initializeInstance(strategyClassName, "blacklist strategy");
        this.nimbusMonitorFreqSecs = ObjectReader.getInt((Object)this.conf.get("nimbus.monitor.freq.secs"));
        this.blacklistStrategy.prepare(this.conf);
        this.windowSize = this.toleranceTime / this.nimbusMonitorFreqSecs;
        this.badSupervisorsToleranceSlidingWindow = EvictingQueue.create((int)this.windowSize);
        this.sendAssignmentFailureCount = EvictingQueue.create((int)this.windowSize);
        this.cachedSupervisors = new HashMap<String, Set<Integer>>();
        this.blacklistedSupervisorIds = new HashSet<String>();
        this.blacklistOnBadSlots = ObjectReader.getBoolean((Object)this.conf.get("blacklist.scheduler.assume.supervisor.bad.based.on.bad.slot"), (boolean)true);
        metricsRegistry.registerGauge("nimbus:num-blacklisted-supervisor", () -> this.blacklistedSupervisorIds.size());
    }

    @Override
    public void cleanup() {
        LOG.info("Cleanup black list scheduler");
        this.underlyingScheduler.cleanup();
    }

    @Override
    public void schedule(Topologies topologies, Cluster cluster) {
        LOG.debug("running Black List scheduler");
        LOG.debug("AssignableSlots: {}", cluster.getAssignableSlots());
        LOG.debug("AvailableSlots: {}", cluster.getAvailableSlots());
        LOG.debug("UsedSlots: {}", cluster.getUsedSlots());
        Map<String, SupervisorDetails> supervisors = cluster.getSupervisors();
        this.blacklistStrategy.resumeFromBlacklist();
        this.trackMissedHeartbeats(supervisors);
        this.trackAssignmentFailures();
        this.blacklistedSupervisorIds = this.refreshBlacklistedSupervisorIds(cluster, topologies);
        Set<String> blacklistHosts = this.getBlacklistHosts(cluster, this.blacklistedSupervisorIds);
        cluster.setBlacklistedHosts(blacklistHosts);
        this.removeLongTimeDisappearFromCache();
        this.underlyingScheduler.schedule(topologies, cluster);
    }

    @Override
    public Map<String, Map<String, Double>> config() {
        return this.underlyingScheduler.config();
    }

    private void trackMissedHeartbeats(Map<String, SupervisorDetails> supervisors) {
        Set<String> cachedSupervisorsKeySet = this.cachedSupervisors.keySet();
        Set<String> supervisorsKeySet = supervisors.keySet();
        Sets.SetView badSupervisorKeys = Sets.difference(cachedSupervisorsKeySet, supervisorsKeySet);
        HashMap<String, Set<Integer>> badSupervisors = new HashMap<String, Set<Integer>>();
        for (String string : badSupervisorKeys) {
            badSupervisors.put(string, this.cachedSupervisors.get(string));
        }
        for (Map.Entry entry : supervisors.entrySet()) {
            String key = (String)entry.getKey();
            SupervisorDetails supervisorDetails = (SupervisorDetails)entry.getValue();
            if (this.cachedSupervisors.containsKey(key)) {
                Set<Integer> badSlots;
                if (!this.blacklistOnBadSlots || (badSlots = this.badSlots(supervisorDetails, key)).size() <= 0) continue;
                badSupervisors.put(key, badSlots);
                continue;
            }
            this.cachedSupervisors.put(key, supervisorDetails.getAllPorts());
        }
        this.badSupervisorsToleranceSlidingWindow.add(badSupervisors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackAssignmentFailures() {
        if (!this.blacklistSendAssignentFailures) {
            return;
        }
        HashMap<String, Integer> assignmentFailureWindow = new HashMap<String, Integer>();
        Map<String, Integer> map = this.assignmentFailures;
        synchronized (map) {
            assignmentFailureWindow.putAll(this.assignmentFailures);
            this.assignmentFailures.clear();
        }
        this.sendAssignmentFailureCount.add(assignmentFailureWindow);
    }

    private Set<Integer> badSlots(SupervisorDetails supervisor, String supervisorKey) {
        Set<Integer> cachedSupervisorPorts = this.cachedSupervisors.get(supervisorKey);
        Set<Integer> supervisorPorts = supervisor.getAllPorts();
        Sets.SetView newPorts = Sets.difference(supervisorPorts, cachedSupervisorPorts);
        if (newPorts.size() > 0) {
            HashSet<Integer> allPorts = new HashSet<Integer>((Collection<Integer>)newPorts);
            allPorts.addAll(cachedSupervisorPorts);
            this.cachedSupervisors.put(supervisorKey, allPorts);
        }
        Sets.SetView badSlots = Sets.difference(cachedSupervisorPorts, supervisorPorts);
        return badSlots;
    }

    private Set<String> refreshBlacklistedSupervisorIds(Cluster cluster, Topologies topologies) {
        Set<String> blacklistedSupervisors = this.blacklistStrategy.getBlacklist(new ArrayList<Map<String, Set<Integer>>>((Collection<Map<String, Set<Integer>>>)this.badSupervisorsToleranceSlidingWindow), new ArrayList<Map<String, Integer>>((Collection<Map<String, Integer>>)this.sendAssignmentFailureCount), cluster, topologies);
        if (blacklistedSupervisors.isEmpty()) {
            LOG.debug("No Supervisors are blacklisted.");
        } else {
            LOG.info("Supervisors {} are blacklisted.", blacklistedSupervisors);
        }
        return blacklistedSupervisors;
    }

    private Set<String> getBlacklistHosts(Cluster cluster, Set<String> blacklistIds) {
        HashSet<String> blacklistHostSet = new HashSet<String>();
        for (String supervisor : blacklistIds) {
            String host = cluster.getHost(supervisor);
            if (host != null) {
                blacklistHostSet.add(host);
                continue;
            }
            LOG.info("supervisor {} is not alive, do not need to add to blacklist.", (Object)supervisor);
        }
        return blacklistHostSet;
    }

    private void removeLongTimeDisappearFromCache() {
        Set<Integer> slots;
        HashMap<String, Integer> supervisorCountMap = new HashMap<String, Integer>();
        HashMap<WorkerSlot, Integer> slotCountMap = new HashMap<WorkerSlot, Integer>();
        for (Map item : this.badSupervisorsToleranceSlidingWindow) {
            Set supervisors = item.keySet();
            for (String supervisor : supervisors) {
                int supervisorCount = supervisorCountMap.getOrDefault(supervisor, 0);
                slots = (Set<Integer>)item.get(supervisor);
                if (slots.equals(this.cachedSupervisors.get(supervisor))) {
                    supervisorCountMap.put(supervisor, supervisorCount + 1);
                }
                for (Integer slot : slots) {
                    WorkerSlot workerSlot = new WorkerSlot(supervisor, (Number)slot);
                    int slotCount = slotCountMap.getOrDefault(workerSlot, 0);
                    slotCountMap.put(workerSlot, slotCount + 1);
                }
            }
        }
        for (Map.Entry entry : supervisorCountMap.entrySet()) {
            String key = (String)entry.getKey();
            int value = (Integer)entry.getValue();
            if (value != this.windowSize) continue;
            this.cachedSupervisors.remove(key);
            LOG.info("Supervisor {} was never back to normal during tolerance period, probably dead. Will remove from cache.", (Object)key);
        }
        for (Map.Entry entry : slotCountMap.entrySet()) {
            WorkerSlot workerSlot = (WorkerSlot)entry.getKey();
            String supervisorKey = workerSlot.getNodeId();
            Integer slot = workerSlot.getPort();
            int slotFailures = (Integer)entry.getValue();
            if (slotFailures != this.windowSize) continue;
            slots = this.cachedSupervisors.get(supervisorKey);
            if (slots != null) {
                slots.remove(slot);
                this.cachedSupervisors.put(supervisorKey, slots);
            }
            LOG.info("Worker slot {} was never back to normal during tolerance period, probably dead. Will be removed from cache.", (Object)workerSlot);
        }
    }

    private Object initializeInstance(String className, String representation) {
        try {
            return ReflectionUtils.newInstance((String)className);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ClassNotFoundException) {
                LOG.error("Can't find {} for name {}", (Object)representation, (Object)className);
            } else if (cause instanceof InstantiationException) {
                LOG.error("Throw InstantiationException {} for name {}", (Object)representation, (Object)className);
            } else if (cause instanceof IllegalAccessException) {
                LOG.error("Throw IllegalAccessException {} for name {}", (Object)representation, (Object)className);
            } else {
                LOG.error("Throw unexpected exception {} {} for name {}", new Object[]{cause, representation, className});
            }
            throw e;
        }
    }

    public Set<String> getBlacklistSupervisorIds() {
        return Collections.unmodifiableSet(this.blacklistedSupervisorIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeAssignmentSent(String node, boolean successful) {
        if (!this.blacklistSendAssignentFailures) {
            return;
        }
        if (!successful) {
            Map<String, Integer> map = this.assignmentFailures;
            synchronized (map) {
                int failCount = this.assignmentFailures.getOrDefault(node, 0) + 1;
                this.assignmentFailures.put(node, failCount);
            }
        }
    }
}

