/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.provider.FilterException;
import org.opensaml.saml2.metadata.provider.MetadataFilter;
import org.opensaml.xml.XMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequiredValidUntilFilter
implements MetadataFilter {
    private final Logger log = LoggerFactory.getLogger(RequiredValidUntilFilter.class);
    private long maxValidityInterval;

    public RequiredValidUntilFilter() {
        this.maxValidityInterval = 0L;
    }

    public RequiredValidUntilFilter(long maxValidity) {
        this.maxValidityInterval = maxValidity * 1000L;
    }

    public long getMaxValidityInterval() {
        return this.maxValidityInterval;
    }

    public void doFilter(XMLObject metadata) throws FilterException {
        long validityInterval;
        DateTime validUntil = this.getValidUntil(metadata);
        if (validUntil == null) {
            throw new FilterException("Metadata did not include a validUntil attribute");
        }
        DateTime now = new DateTime((Chronology)ISOChronology.getInstanceUTC());
        if (this.maxValidityInterval > 0L && validUntil.isAfter((ReadableInstant)now) && (validityInterval = validUntil.getMillis() - now.getMillis()) > this.maxValidityInterval) {
            throw new FilterException("Metadata's validity interval, " + validityInterval + "ms, is larger than is allowed, " + this.maxValidityInterval + "ms.");
        }
    }

    protected DateTime getValidUntil(XMLObject metadata) throws FilterException {
        if (metadata instanceof EntitiesDescriptor) {
            return ((EntitiesDescriptor)metadata).getValidUntil();
        }
        if (metadata instanceof EntityDescriptor) {
            return ((EntityDescriptor)metadata).getValidUntil();
        }
        this.log.error("Metadata root element was not an EntitiesDescriptor or EntityDescriptor it was a {}", (Object)metadata.getElementQName());
        throw new FilterException("Metadata root element was not an EntitiesDescriptor or EntityDescriptor");
    }
}

