/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.addressing.factory.impl;

import java.security.PrivilegedExceptionAction;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.addressing.SubmissionEndpointReference;
import org.apache.axis2.jaxws.addressing.factory.JAXWSEndpointReferenceFactory;
import org.apache.axis2.jaxws.i18n.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSEndpointReferenceFactoryImpl
implements JAXWSEndpointReferenceFactory {
    private JAXBContext jaxbContext;

    public JAXWSEndpointReferenceFactoryImpl() {
        try {
            this.jaxbContext = (JAXBContext)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws JAXBException {
                    return JAXBContext.newInstance((Class[])new Class[]{W3CEndpointReference.class, SubmissionEndpointReference.class});
                }
            });
        }
        catch (Exception e) {
            throw new WebServiceException(Messages.getMessage((String)"jaxbContextFailure", (String)e.toString()));
        }
    }

    @Override
    public EndpointReference createEndpointReference(Source eprInfoset) throws JAXBException {
        Unmarshaller um = this.jaxbContext.createUnmarshaller();
        return (EndpointReference)um.unmarshal(eprInfoset);
    }

    @Override
    public <T extends EndpointReference> String getAddressingNamespace(Class<T> clazz) {
        String addressingNamespace = null;
        if (W3CEndpointReference.class.isAssignableFrom(clazz)) {
            addressingNamespace = "http://www.w3.org/2005/08/addressing";
        } else if (SubmissionEndpointReference.class.isAssignableFrom(clazz)) {
            addressingNamespace = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
        } else {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"unknownClassType", (String)clazz.toString()));
        }
        return addressingNamespace;
    }
}

