/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.util.Collections;
import java.util.List;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.AlgorithmSuite;
import org.apache.ws.security.components.crypto.AlgorithmSuiteValidator;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.DerivedKeyToken;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.str.DerivedKeyTokenSTRParser;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerivedKeyTokenProcessor
implements Processor {
    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData data, WSDocInfo wsDocInfo) throws WSSecurityException {
        DerivedKeyToken dkt = new DerivedKeyToken(elem, data.getWssConfig().isWsiBSPCompliant());
        AlgorithmSuite algorithmSuite = data.getAlgorithmSuite();
        if (algorithmSuite != null) {
            AlgorithmSuiteValidator algorithmSuiteValidator = new AlgorithmSuiteValidator(algorithmSuite);
            algorithmSuiteValidator.checkDerivedKeyAlgorithm(dkt.getAlgorithm());
        }
        byte[] secret = null;
        Element secRefElement = dkt.getSecurityTokenReferenceElement();
        if (secRefElement == null) {
            throw new WSSecurityException(6, "noReference");
        }
        DerivedKeyTokenSTRParser strParser = new DerivedKeyTokenSTRParser();
        strParser.parseSecurityTokenReference(secRefElement, data, wsDocInfo, null);
        secret = strParser.getSecretKey();
        String tempNonce = dkt.getNonce();
        if (tempNonce == null) {
            throw new WSSecurityException("Missing wsc:Nonce value");
        }
        int length = dkt.getLength();
        byte[] keyBytes = dkt.deriveKey(length, secret);
        WSSecurityEngineResult result = new WSSecurityEngineResult(2048, null, keyBytes, null);
        wsDocInfo.addTokenElement(elem);
        result.put("id", dkt.getID());
        result.put("derived-key-token", dkt);
        result.put("secret", secret);
        result.put("token-element", dkt.getElement());
        wsDocInfo.addResult(result);
        return Collections.singletonList(result);
    }
}

