/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.passthru.TargetResponse;
import org.apache.synapse.transport.passthru.config.TargetConfiguration;

public class ClientWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(ClientWorker.class);
    private TargetConfiguration targetConfiguration = null;
    private MessageContext responseMsgCtx = null;
    private TargetResponse response = null;
    private boolean expectEntityBody = true;

    public ClientWorker(TargetConfiguration targetConfiguration, MessageContext outMsgCtx, TargetResponse response) {
        this.targetConfiguration = targetConfiguration;
        this.response = response;
        this.expectEntityBody = response.isExpectResponseBody();
        Map<String, String> headers = response.getHeaders();
        Map excessHeaders = response.getExcessHeaders();
        String oriURL = headers.get("Location");
        if (oriURL != null && response.getStatus() != 302 && !targetConfiguration.isPreserveHttpHeader("Location")) {
            URL url;
            try {
                url = new URL(oriURL);
            }
            catch (MalformedURLException e) {
                log.error((Object)"Invalid URL received", (Throwable)e);
                return;
            }
            headers.remove("Location");
            String prefix = (String)outMsgCtx.getProperty("SERVICE_PREFIX");
            if (prefix != null) {
                headers.put("Location", prefix + url.getFile());
            }
        }
        try {
            this.responseMsgCtx = outMsgCtx.getOperationContext().getMessageContext("In");
            if (this.responseMsgCtx != null) {
                this.responseMsgCtx.setSoapAction("");
            }
        }
        catch (AxisFault af) {
            log.error((Object)"Error getting IN message context from the operation context", (Throwable)af);
            return;
        }
        if (this.responseMsgCtx == null) {
            if (outMsgCtx.getOperationContext().isComplete()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Error getting IN message context from the operation context. Possibly an RM terminate sequence message");
                }
                return;
            }
            this.responseMsgCtx = new MessageContext();
            this.responseMsgCtx.setOperationContext(outMsgCtx.getOperationContext());
        }
        this.responseMsgCtx.setProperty("pass-through.Source-Connection", outMsgCtx.getProperty("pass-through.Source-Connection"));
        this.responseMsgCtx.setProperty("PASS_THROUGH_SOURCE_CONFIGURATION", outMsgCtx.getProperty("PASS_THROUGH_SOURCE_CONFIGURATION"));
        this.responseMsgCtx.setServerSide(true);
        this.responseMsgCtx.setDoingREST(outMsgCtx.isDoingREST());
        this.responseMsgCtx.setProperty("TRANSPORT_IN", outMsgCtx.getProperty("TRANSPORT_IN"));
        this.responseMsgCtx.setTransportIn(outMsgCtx.getTransportIn());
        this.responseMsgCtx.setTransportOut(outMsgCtx.getTransportOut());
        Set<Map.Entry<String, String>> headerEntries = response.getHeaders().entrySet();
        TreeMap<String, String> headerMap = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        for (Map.Entry<String, String> headerEntry : headerEntries) {
            headerMap.put(headerEntry.getKey(), headerEntry.getValue());
        }
        this.responseMsgCtx.setProperty("TRANSPORT_HEADERS", headerMap);
        this.responseMsgCtx.setProperty("EXCESS_TRANSPORT_HEADERS", (Object)excessHeaders);
        if (headerMap.get("Content-Length") != null) {
            this.responseMsgCtx.setProperty("ORIGINAL_CONTENT_LENGTH", headerMap.get("Content-Length"));
        }
        if (response.getStatus() == 202) {
            this.responseMsgCtx.setProperty("disableAddressingForOutMessages", (Object)Boolean.TRUE);
            this.responseMsgCtx.setProperty("message.builder.invoked", (Object)Boolean.TRUE);
            this.responseMsgCtx.setProperty("SC_ACCEPTED", (Object)Boolean.TRUE);
        }
        this.responseMsgCtx.setAxisMessage(outMsgCtx.getOperationContext().getAxisOperation().getMessage("In"));
        this.responseMsgCtx.setOperationContext(outMsgCtx.getOperationContext());
        this.responseMsgCtx.setConfigurationContext(outMsgCtx.getConfigurationContext());
        this.responseMsgCtx.setTo(null);
        this.responseMsgCtx.setProperty("pass-through.pipe", (Object)response.getPipe());
        this.responseMsgCtx.setProperty("pass-through.Target-Response", (Object)response);
        this.responseMsgCtx.setProperty("pass-through.Target-Connection", (Object)response.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.responseMsgCtx == null) {
            return;
        }
        try {
            if (this.expectEntityBody) {
                String cType = this.response.getHeader("Content-Type");
                String contentType = cType != null ? cType : this.inferContentType();
                this.responseMsgCtx.setProperty("ContentType", (Object)contentType);
                String charSetEnc = BuilderUtil.getCharSetEncoding((String)contentType);
                if (charSetEnc == null) {
                    charSetEnc = "UTF-8";
                }
                this.responseMsgCtx.setProperty("CHARACTER_SET_ENCODING", (Object)(contentType.indexOf("; charset=") > 0 ? charSetEnc : "UTF-8"));
                this.responseMsgCtx.setServerSide(false);
                SOAPFactory fac = OMAbstractFactory.getSOAP11Factory();
                SOAPEnvelope envelope = fac.getDefaultEnvelope();
                try {
                    this.responseMsgCtx.setEnvelope(envelope);
                }
                catch (AxisFault axisFault) {
                    log.error((Object)"Error setting the SOAP envelope", (Throwable)axisFault);
                }
                this.responseMsgCtx.setServerSide(true);
            } else {
                this.responseMsgCtx.setProperty("NO_ENTITY_BODY", (Object)Boolean.TRUE);
                this.responseMsgCtx.setEnvelope(OMAbstractFactory.getSOAP11Factory().getDefaultEnvelope());
            }
            int statusCode = this.response.getStatus();
            this.responseMsgCtx.setProperty("HTTP_SC", (Object)statusCode);
            if (statusCode >= 400) {
                this.responseMsgCtx.setProperty("FAULT_MESSAGE", (Object)"TRUE");
            }
            this.responseMsgCtx.setProperty("NonBlockingTransport", (Object)true);
            try {
                AxisEngine.receive((MessageContext)this.responseMsgCtx);
            }
            catch (AxisFault af) {
                log.error((Object)"Fault processing response message through Axis2", (Throwable)af);
            }
        }
        catch (AxisFault af) {
            log.error((Object)"Fault creating response SOAP envelope", (Throwable)af);
        }
        catch (IOException e) {
            log.error((Object)"Error closing input stream from which message was read", (Throwable)e);
        }
        finally {
            this.cleanup();
        }
    }

    private String inferContentType() {
        Object cTypeProperty = this.responseMsgCtx.getProperty("CONTENT_TYPE");
        if (cTypeProperty != null) {
            return cTypeProperty.toString();
        }
        Parameter cTypeParam = this.targetConfiguration.getConfigurationContext().getAxisConfiguration().getParameter("CONTENT_TYPE");
        if (cTypeParam != null) {
            return cTypeParam.getValue().toString();
        }
        return "application/octet-stream";
    }

    private void cleanup() {
        ClientWorker clientWorker = this;
        clientWorker.responseMsgCtx.destroyCurrentMessageContext();
    }
}

