/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.bsf;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.bsf.ScriptMediator;

public class ScriptMediatorFactory
extends AbstractMediatorFactory {
    private static final QName TAG_NAME = new QName("http://ws.apache.org/ns/synapse", "script");
    private static final QName INCLUDE_Q = new QName("http://ws.apache.org/ns/synapse", "include");

    public Mediator createSpecificMediator(OMElement elem, Properties properties) {
        ScriptMediator mediator;
        ClassLoader classLoader = (ClassLoader)properties.get("synapse.lib.classloader");
        OMAttribute keyAtt = elem.getAttribute(new QName("", "key"));
        OMAttribute langAtt = elem.getAttribute(new QName("", "language"));
        OMAttribute functionAtt = elem.getAttribute(new QName("", "function"));
        if (langAtt == null) {
            throw new SynapseException("The 'language' attribute is required for a script mediator");
        }
        if (keyAtt == null && functionAtt != null) {
            throw new SynapseException("Cannot use 'function' attribute without 'key' attribute for a script mediator");
        }
        Map<Value, Object> includeKeysMap = this.getIncludeKeysMap(elem);
        if (keyAtt != null) {
            ValueFactory keyFac = new ValueFactory();
            Value generatedKey = keyFac.createValue("key", elem);
            String functionName = functionAtt == null ? null : functionAtt.getAttributeValue();
            mediator = new ScriptMediator(langAtt.getAttributeValue(), includeKeysMap, generatedKey, functionName, classLoader);
        } else {
            mediator = new ScriptMediator(langAtt.getAttributeValue(), elem.getText(), classLoader);
        }
        this.processAuditStatus((Mediator)mediator, elem);
        return mediator;
    }

    private Map<Value, Object> getIncludeKeysMap(OMElement elem) {
        LinkedHashMap<Value, Object> includeKeysMap = new LinkedHashMap<Value, Object>();
        Iterator itr = elem.getChildrenWithName(INCLUDE_Q);
        while (itr.hasNext()) {
            OMElement includeElem = (OMElement)itr.next();
            OMAttribute key = includeElem.getAttribute(new QName("", "key"));
            ValueFactory keyFac = new ValueFactory();
            Value generatedKey = keyFac.createValue("key", includeElem);
            if (key == null) {
                throw new SynapseException("Cannot use 'include' element without 'key' attribute for a script mediator");
            }
            includeKeysMap.put(generatedKey, null);
        }
        return includeKeysMap;
    }

    public QName getTagQName() {
        return TAG_NAME;
    }
}

