/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.statistics;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.aspects.statistics.ErrorLog;
import org.apache.synapse.config.SynapsePropertiesLoader;

public class ErrorLogFactory {
    private static final Log log = LogFactory.getLog(ErrorLogFactory.class);
    private static boolean enabledErrorDetails = Boolean.parseBoolean(SynapsePropertiesLoader.getPropertyValue("synapse.detailederrorlogging.enable", "false"));

    public static ErrorLog createErrorLog(MessageContext synCtx) {
        String errorCode = String.valueOf(synCtx.getProperty("ERROR_CODE"));
        ErrorLog errorLog = new ErrorLog(errorCode);
        if (enabledErrorDetails) {
            errorLog.setErrorMessage((String)synCtx.getProperty("ERROR_MESSAGE"));
            errorLog.setErrorDetail((String)synCtx.getProperty("ERROR_DETAIL"));
            errorLog.setException((Exception)synCtx.getProperty("ERROR_EXCEPTION"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created a Error Log : " + errorLog));
        }
        return errorLog;
    }

    public static ErrorLog createErrorLog(org.apache.axis2.context.MessageContext axisCtx) {
        String errorCode = String.valueOf(axisCtx.getProperty("ERROR_CODE"));
        ErrorLog errorLog = new ErrorLog(errorCode);
        if (enabledErrorDetails) {
            errorLog.setErrorMessage((String)axisCtx.getProperty("ERROR_MESSAGE"));
            errorLog.setErrorDetail((String)axisCtx.getProperty("ERROR_DETAIL"));
            errorLog.setException((Exception)axisCtx.getProperty("ERROR_EXCEPTION"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created a Error Log : " + errorLog));
        }
        return errorLog;
    }
}

