/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import java.util.HashSet;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class SortKeys
extends Lop {
    public static final String OPCODE = "qsort";
    private OperationTypes operation;
    private boolean descending = false;

    public OperationTypes getOpType() {
        return this.operation;
    }

    public SortKeys(Lop input, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.SortKeys, dt, vt);
        this.init(input, null, op, et);
    }

    public SortKeys(Lop input, boolean desc, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.SortKeys, dt, vt);
        this.init(input, null, op, et);
        this.descending = desc;
    }

    public SortKeys(Lop input1, Lop input2, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.SortKeys, dt, vt);
        this.init(input1, input2, op, et);
    }

    private void init(Lop input1, Lop input2, OperationTypes op, LopProperties.ExecType et) {
        this.addInput(input1);
        input1.addOutput(this);
        this.operation = op;
        if (et == LopProperties.ExecType.MR) {
            boolean breaksAlignment = true;
            boolean aligner = false;
            boolean definesMRJob = true;
            this.lps.addCompatibility(JobType.SORT);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.MapAndReduce, breaksAlignment, aligner, definesMRJob);
            if (op != OperationTypes.Indexes) {
                this.lps.setProducesIntermediateOutput(true);
            }
        } else {
            if (input2 != null) {
                this.addInput(input2);
                input2.addOutput(this);
            }
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, false, false, false);
        }
    }

    @Override
    public String toString() {
        return "Operation: SortKeys (" + (Object)((Object)this.operation) + ")";
    }

    @Override
    public String getInstructions(int input_index, int output_index) {
        return this.getInstructions(String.valueOf(input_index), String.valueOf(output_index));
    }

    @Override
    public String getInstructions(String input, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        if (this.getExecType() == LopProperties.ExecType.MR) {
            sb.append("\u00b0");
            sb.append((Object)this.operation);
            sb.append("\u00b0");
            sb.append(this.descending);
        }
        return sb.toString();
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input2));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    public static SortKeys constructSortByValueLop(Lop input1, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        for (Lop lop : input1.getOutputs()) {
            if (lop.type != Lop.Type.SortKeys) continue;
            return (SortKeys)lop;
        }
        SortKeys retVal = new SortKeys(input1, op, dt, vt, et);
        retVal.setAllPositions(input1.getFilename(), input1.getBeginLine(), input1.getBeginColumn(), input1.getEndLine(), input1.getEndColumn());
        return retVal;
    }

    public static SortKeys constructSortByValueLop(Lop input1, Lop input2, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        HashSet<Lop> set1 = new HashSet<Lop>();
        set1.addAll(input1.getOutputs());
        set1.retainAll(input2.getOutputs());
        for (Lop lop : set1) {
            if (lop.type != Lop.Type.SortKeys) continue;
            return (SortKeys)lop;
        }
        SortKeys retVal = new SortKeys(input1, input2, op, dt, vt, et);
        retVal.setAllPositions(input1.getFilename(), input1.getBeginLine(), input1.getBeginColumn(), input1.getEndLine(), input1.getEndColumn());
        return retVal;
    }

    public static enum OperationTypes {
        WithWeights,
        WithoutWeights,
        Indexes;

    }
}

