/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.DMLScriptException;
import org.apache.sysml.runtime.controlprogram.ExternalFunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.ExternalFunctionProgramBlockCP;
import org.apache.sysml.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;

public class Program {
    public static final String KEY_DELIM = "::";
    public ArrayList<ProgramBlock> _programBlocks;
    private HashMap<String, HashMap<String, FunctionProgramBlock>> _namespaceFunctions = new HashMap();

    public Program() {
        this._programBlocks = new ArrayList();
    }

    public synchronized void addFunctionProgramBlock(String namespace, String fname, FunctionProgramBlock fpb) {
        if (namespace == null) {
            namespace = ".defaultNS";
        }
        HashMap<String, FunctionProgramBlock> namespaceBlocks = null;
        namespaceBlocks = this._namespaceFunctions.get(namespace);
        if (namespaceBlocks == null) {
            namespaceBlocks = new HashMap();
            this._namespaceFunctions.put(namespace, namespaceBlocks);
        }
        namespaceBlocks.put(fname, fpb);
    }

    public synchronized void removeFunctionProgramBlock(String namespace, String fname) {
        if (namespace == null) {
            namespace = ".defaultNS";
        }
        HashMap<String, FunctionProgramBlock> namespaceBlocks = null;
        if (this._namespaceFunctions.containsKey(namespace) && (namespaceBlocks = this._namespaceFunctions.get(namespace)).containsKey(fname)) {
            namespaceBlocks.remove(fname);
        }
    }

    public synchronized HashMap<String, FunctionProgramBlock> getFunctionProgramBlocks() {
        HashMap<String, FunctionProgramBlock> retVal = new HashMap<String, FunctionProgramBlock>();
        for (String namespace : this._namespaceFunctions.keySet()) {
            HashMap<String, FunctionProgramBlock> namespaceFSB = this._namespaceFunctions.get(namespace);
            for (Map.Entry<String, FunctionProgramBlock> e : namespaceFSB.entrySet()) {
                String fname = e.getKey();
                FunctionProgramBlock fpb = e.getValue();
                String fKey = DMLProgram.constructFunctionKey(namespace, fname);
                retVal.put(fKey, fpb);
            }
        }
        return retVal;
    }

    public synchronized FunctionProgramBlock getFunctionProgramBlock(String namespace, String fname) {
        HashMap<String, FunctionProgramBlock> namespaceFunctBlocks;
        if (namespace == null) {
            namespace = ".defaultNS";
        }
        if ((namespaceFunctBlocks = this._namespaceFunctions.get(namespace)) == null) {
            throw new DMLRuntimeException("namespace " + namespace + " is undefined");
        }
        FunctionProgramBlock retVal = namespaceFunctBlocks.get(fname);
        if (retVal == null) {
            throw new DMLRuntimeException("function " + fname + " is undefined in namespace " + namespace);
        }
        return retVal;
    }

    public void addProgramBlock(ProgramBlock pb) {
        this._programBlocks.add(pb);
    }

    public ArrayList<ProgramBlock> getProgramBlocks() {
        return this._programBlocks;
    }

    public void execute(ExecutionContext ec) {
        ec.initDebugProgramCounters();
        try {
            for (int i = 0; i < this._programBlocks.size(); ++i) {
                ec.updateDebugState(i);
                this._programBlocks.get(i).execute(ec);
            }
        }
        catch (DMLScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DMLRuntimeException(e);
        }
        ec.clearDebugProgramCounters();
    }

    public Program clone(boolean deep) {
        if (deep) {
            throw new NotImplementedException();
        }
        Program ret = new Program();
        ret._programBlocks.addAll(this._programBlocks);
        for (Map.Entry<String, HashMap<String, FunctionProgramBlock>> e1 : this._namespaceFunctions.entrySet()) {
            for (Map.Entry<String, FunctionProgramBlock> e2 : e1.getValue().entrySet()) {
                FunctionProgramBlock fpb = e2.getValue();
                if (fpb instanceof ExternalFunctionProgramBlock) {
                    fpb = Program.createPartialDeepCopy(ret, (ExternalFunctionProgramBlock)fpb);
                }
                ret.addFunctionProgramBlock(e1.getKey(), e2.getKey(), fpb);
            }
        }
        return ret;
    }

    public Object clone() {
        return this.clone(true);
    }

    private static ExternalFunctionProgramBlock createPartialDeepCopy(Program prog, ExternalFunctionProgramBlock efpb) {
        try {
            return efpb instanceof ExternalFunctionProgramBlockCP ? new ExternalFunctionProgramBlockCP(prog, efpb._inputParams, efpb._outputParams, efpb._otherParams, efpb._baseDir) : new ExternalFunctionProgramBlock(prog, efpb._inputParams, efpb._outputParams, efpb._otherParams, efpb._baseDir);
        }
        catch (DMLRuntimeException ex) {
            throw new RuntimeException(ex);
        }
    }
}

