/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.IndexingCPInstruction;
import org.apache.sysml.runtime.instructions.cp.ListObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;

public final class ListIndexingCPInstruction
extends IndexingCPInstruction {
    protected ListIndexingCPInstruction(CPOperand in, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(in, rl, ru, cl, cu, out, opcode, istr);
    }

    protected ListIndexingCPInstruction(CPOperand lhsInput, CPOperand rhsInput, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(lhsInput, rhsInput, rl, ru, cl, cu, out, opcode, istr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processInstruction(ExecutionContext ec) {
        String opcode = this.getOpcode();
        ScalarObject rl = ec.getScalarInput(this.rowLower.getName(), this.rowLower.getValueType(), this.rowLower.isLiteral());
        ScalarObject ru = ec.getScalarInput(this.rowUpper.getName(), this.rowUpper.getValueType(), this.rowUpper.isLiteral());
        if (opcode.equalsIgnoreCase("rightIndex")) {
            ListObject list = (ListObject)ec.getVariable(this.input1.getName());
            if (rl.getValueType() == Expression.ValueType.STRING || ru.getValueType() == Expression.ValueType.STRING) {
                ec.setVariable(this.output.getName(), list.slice(rl.getStringValue(), ru.getStringValue()));
                return;
            } else {
                ec.setVariable(this.output.getName(), list.slice((int)rl.getLongValue() - 1, (int)ru.getLongValue() - 1));
            }
            return;
        } else {
            if (!opcode.equalsIgnoreCase("leftIndex")) throw new DMLRuntimeException("Invalid opcode (" + opcode + ") encountered in ListIndexingCPInstruction.");
            ListObject lin = (ListObject)ec.getVariable(this.input1.getName());
            if (this.input2.getDataType().isList()) {
                ListObject rin = (ListObject)ec.getVariable(this.input2.getName());
                if (rl.getValueType() == Expression.ValueType.STRING || ru.getValueType() == Expression.ValueType.STRING) {
                    ec.setVariable(this.output.getName(), lin.copy().set(rl.getStringValue(), ru.getStringValue(), rin));
                    return;
                } else {
                    ec.setVariable(this.output.getName(), lin.copy().set((int)rl.getLongValue() - 1, (int)ru.getLongValue() - 1, rin));
                }
                return;
            } else if (this.input2.getDataType().isScalar()) {
                ScalarObject scalar = ec.getScalarInput(this.input2);
                if (rl.getValueType() == Expression.ValueType.STRING) {
                    ec.setVariable(this.output.getName(), lin.copy().set(rl.getStringValue(), (Data)scalar));
                    return;
                } else {
                    ec.setVariable(this.output.getName(), lin.copy().set((int)rl.getLongValue() - 1, (Data)scalar));
                }
                return;
            } else {
                if (!this.input2.getDataType().isMatrix()) throw new DMLRuntimeException("Unsupported list left indexing rhs type: " + this.input2.getDataType().name());
                CacheableData<?> dat = ec.getCacheableData(this.input2);
                dat.enableCleanup(false);
                if (rl.getValueType() == Expression.ValueType.STRING) {
                    ec.setVariable(this.output.getName(), lin.copy().set(rl.getStringValue(), dat));
                    return;
                } else {
                    ec.setVariable(this.output.getName(), lin.copy().set((int)rl.getLongValue() - 1, dat));
                }
            }
        }
    }
}

