/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import org.apache.sysml.lops.Ctable;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.CtableInstruction;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;

public class CombineTernaryInstruction
extends CtableInstruction {
    private CombineTernaryInstruction(Ctable.OperationTypes op, byte in1, byte in2, byte in3, byte out, String istr) {
        super(MRInstruction.MRType.CombineTernary, op, in1, in2, in3, out, -1L, -1L, istr);
    }

    public static CombineTernaryInstruction parseInstruction(String str) {
        InstructionUtils.checkNumFields(str, 4);
        String[] parts = InstructionUtils.getInstructionParts(str);
        String opcode = parts[0];
        byte in1 = Byte.parseByte(parts[1]);
        byte in2 = Byte.parseByte(parts[2]);
        byte in3 = Byte.parseByte(parts[3]);
        byte out = Byte.parseByte(parts[4]);
        if (opcode.equalsIgnoreCase("combineternary")) {
            return new CombineTernaryInstruction(null, in1, in2, in3, out, str);
        }
        return null;
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) {
        throw new DMLRuntimeException("CombineTernaryInstruction.processInstruction should never be called!");
    }
}

