/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.util;

import org.apache.commons.math3.distribution.PoissonDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.SynchronizedRandomGenerator;
import org.apache.commons.math3.random.Well1024a;
import org.apache.sysml.runtime.util.PRNGenerator;

public class PoissonPRNGenerator
extends PRNGenerator {
    private PoissonDistribution _pdist = null;
    private double _mean = Double.NaN;
    private long seed;

    public PoissonPRNGenerator() {
        this._mean = 1.0;
        this.setup(this._mean, this.seed);
    }

    public PoissonPRNGenerator(double mean) {
        this._mean = mean;
        this.setup(this._mean, this.seed);
    }

    public void setup(double mean, long sd) {
        this.seed = sd;
        SynchronizedRandomGenerator srg = new SynchronizedRandomGenerator((RandomGenerator)new Well1024a());
        srg.setSeed(this.seed);
        this._pdist = new PoissonDistribution((RandomGenerator)srg, this._mean, 1.0E-12, 10000000);
    }

    @Override
    public void setSeed(long sd) {
        this.setup(this._mean, sd);
    }

    public void setMean(double mean) {
        this.setup(mean, this.seed);
    }

    @Override
    public double nextDouble() {
        return this._pdist.sample();
    }
}

