/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.layers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;

public class Relu
extends Script {
    public Relu() {
        String string = "scripts/nn/layers/relu.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Matrix forward(Object object) {
        String string = "source('scripts/nn/layers/relu.dml') as mlcontextns;out = mlcontextns::forward(X);";
        Script script = new Script(string);
        script.in("X", object).out("out");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("out");
        return matrix;
    }

    public String forward__docs() {
        String string = "forward = function(matrix[double] X)\n    return (matrix[double] out) {\n  /*\n   * Computes the forward pass for a ReLU nonlinearity layer.\n   *\n   * Performs an element-wise evaluation of `f(input) = max(0, input)`.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (any, any).\n   *\n   * Outputs:\n   *  - out: Outputs, of same shape as `X`.\n   */\n";
        return string;
    }

    public String forward__source() {
        String string = "forward = function(matrix[double] X)\n    return (matrix[double] out) {\n  /*\n   * Computes the forward pass for a ReLU nonlinearity layer.\n   *\n   * Performs an element-wise evaluation of `f(input) = max(0, input)`.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (any, any).\n   *\n   * Outputs:\n   *  - out: Outputs, of same shape as `X`.\n   */\n  out = max(0, X)\n}\n";
        return string;
    }

    public Matrix backward(Object object, Object object2) {
        String string = "source('scripts/nn/layers/relu.dml') as mlcontextns;dX = mlcontextns::backward(dout, X);";
        Script script = new Script(string);
        script.in("dout", object).in("X", object2).out("dX");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("dX");
        return matrix;
    }

    public String backward__docs() {
        String string = "backward = function(matrix[double] dout, matrix[double] X)\n    return (matrix[double] dX) {\n  /*\n   * Computes the backward pass for a ReLU nonlinearity layer.\n   *\n   * Essentially performs a pass-through of the upstream gradient\n   * for cells > 0.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of same shape as `X`.\n   *  - X: Previous input data matrix, of shape (any, any).\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of same shape as `X`.\n   */\n";
        return string;
    }

    public String backward__source() {
        String string = "backward = function(matrix[double] dout, matrix[double] X)\n    return (matrix[double] dX) {\n  /*\n   * Computes the backward pass for a ReLU nonlinearity layer.\n   *\n   * Essentially performs a pass-through of the upstream gradient\n   * for cells > 0.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of same shape as `X`.\n   *  - X: Previous input data matrix, of shape (any, any).\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of same shape as `X`.\n   */\n   dX = (X > 0) * dout\n}\n";
        return string;
    }
}

