/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.debug;

import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang.math.IntRange;
import org.apache.sysml.debug.DMLBreakpointManager;
import org.apache.sysml.debug.DMLDebuggerException;
import org.apache.sysml.debug.DMLDebuggerFunctions;
import org.apache.sysml.debug.DMLDebuggerInterface;
import org.apache.sysml.debug.DMLDebuggerProgramInfo;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContextFactory;
import org.apache.sysml.runtime.instructions.cp.BreakPointInstruction;

public class DMLDebugger {
    private DMLDebuggerProgramInfo dbprog;
    private DMLDebuggerInterface debuggerUI;
    private DMLDebuggerFunctions dbFunctions;
    private CommandLine cmd;
    private PrintStream originalOut = null;
    private PrintStream originalErr = null;
    private ExecutionContext preEC = null;
    private ExecutionContext currEC = null;
    private String[] lines;
    private volatile boolean quit = false;
    Runnable DMLRuntime = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ((DMLDebugger)DMLDebugger.this).dbprog.rtprog.execute(DMLDebugger.this.currEC);
                Class<DMLDebugger> clazz = DMLDebugger.class;
                synchronized (DMLDebugger.class) {
                    DMLDebugger.this.quit = true;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                System.err.println("Exception raised by DML runtime:" + e);
            }
            {
                return;
            }
        }
    };

    public DMLDebugger(DMLDebuggerProgramInfo p, String dmlScript) {
        this.dbprog = p;
        this.lines = dmlScript.split("\n");
        this.debuggerUI = new DMLDebuggerInterface();
        this.dbFunctions = new DMLDebuggerFunctions();
        this.preEC = ExecutionContextFactory.createContext(this.dbprog.rtprog);
        this.setupDMLRuntime();
    }

    private void setupDMLRuntime() {
        this.dbprog.setDMLInstMap();
        this.preEC.getDebugState().setDMLScript(this.lines);
    }

    private void setStdOut() {
        this.originalOut = System.out;
        System.setOut(this.originalOut);
    }

    private PrintStream getStdOut() {
        System.out.flush();
        return this.originalOut;
    }

    private void setStdErr() {
        this.originalErr = System.err;
        System.setOut(this.originalErr);
    }

    private PrintStream getStdErr() {
        System.err.flush();
        return this.originalErr;
    }

    private void getCommand() throws DMLDebuggerException {
        this.cmd = this.debuggerUI.getDebuggerCommand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized void runSystemMLDebugger() {
        this.debuggerUI.setOptions();
        this.debuggerUI.getDebuggerCLI();
        Thread runtime = new Thread(this.DMLRuntime);
        boolean isRuntimeInstruction = false;
        while (!this.quit) {
            try {
                block93: {
                    block92: {
                        block110: {
                            IntRange range;
                            String[] argsForRange;
                            String[] pOptions;
                            block109: {
                                block108: {
                                    block107: {
                                        String varName;
                                        block105: {
                                            block106: {
                                                block102: {
                                                    String[] infoOptions;
                                                    block104: {
                                                        block103: {
                                                            block101: {
                                                                block100: {
                                                                    block99: {
                                                                        block98: {
                                                                            block97: {
                                                                                block96: {
                                                                                    block95: {
                                                                                        block94: {
                                                                                            this.getCommand();
                                                                                            if (this.cmd == null) break block93;
                                                                                            isRuntimeInstruction = false;
                                                                                            if (!this.cmd.hasOption("h")) break block94;
                                                                                            this.debuggerUI.getDebuggerCLI();
                                                                                            break block92;
                                                                                        }
                                                                                        if (!this.cmd.hasOption("q")) break block95;
                                                                                        Class<DMLDebugger> clazz = DMLDebugger.class;
                                                                                        // MONITORENTER : org.apache.sysml.debug.DMLDebugger.class
                                                                                        this.quit = true;
                                                                                        // MONITOREXIT : clazz
                                                                                        runtime.stop();
                                                                                        break block92;
                                                                                    }
                                                                                    if (!this.cmd.hasOption("r")) break block96;
                                                                                    if (this.currEC != null) {
                                                                                        System.out.println("Runtime has already started. Try \"s\" to go to next line, or \"c\" to continue running your DML script.");
                                                                                        break block92;
                                                                                    } else {
                                                                                        this.currEC = this.preEC;
                                                                                        runtime.start();
                                                                                        isRuntimeInstruction = true;
                                                                                    }
                                                                                    break block92;
                                                                                }
                                                                                if (!this.cmd.hasOption("c")) break block97;
                                                                                if (this.currEC == null) {
                                                                                    System.out.println("Runtime has not been started. Try \"r\" to start DML runtime execution.");
                                                                                    break block92;
                                                                                } else if (!runtime.isAlive()) {
                                                                                    System.err.println("Invalid debug state.");
                                                                                    break block92;
                                                                                } else {
                                                                                    System.out.println("Resuming DML script execution ...");
                                                                                    this.preEC.getDebugState().setCommand(null);
                                                                                    runtime.resume();
                                                                                    isRuntimeInstruction = true;
                                                                                }
                                                                                break block92;
                                                                            }
                                                                            if (!this.cmd.hasOption("si")) break block98;
                                                                            if (!runtime.isAlive()) {
                                                                                this.currEC = this.preEC;
                                                                                runtime.start();
                                                                                isRuntimeInstruction = true;
                                                                            }
                                                                            this.preEC.getDebugState().setCommand("step_instruction");
                                                                            runtime.resume();
                                                                            isRuntimeInstruction = true;
                                                                            break block92;
                                                                        }
                                                                        if (!this.cmd.hasOption("s")) break block99;
                                                                        if (!runtime.isAlive()) {
                                                                            this.currEC = this.preEC;
                                                                            runtime.start();
                                                                            isRuntimeInstruction = true;
                                                                        }
                                                                        this.preEC.getDebugState().setCommand("step_line");
                                                                        runtime.resume();
                                                                        isRuntimeInstruction = true;
                                                                        break block92;
                                                                    }
                                                                    if (!this.cmd.hasOption("b")) break block100;
                                                                    int lineNumber = this.dbFunctions.getValue(this.cmd.getOptionValues("b"), this.lines.length);
                                                                    if (lineNumber > 0) {
                                                                        if (DMLBreakpointManager.getBreakpoint(lineNumber) == null) {
                                                                            System.out.println("Sorry, a breakpoint cannot be inserted at line " + lineNumber + ". Please try a different line number.");
                                                                            break block92;
                                                                        } else if (DMLBreakpointManager.getBreakpoint(lineNumber).getBPInstructionStatus() != BreakPointInstruction.BPINSTRUCTION_STATUS.INVISIBLE) {
                                                                            System.out.format("Breakpoint at line %d already exists.\n", lineNumber);
                                                                            break block92;
                                                                        } else {
                                                                            this.dbprog.accessBreakpoint(lineNumber, 0, BreakPointInstruction.BPINSTRUCTION_STATUS.ENABLED);
                                                                        }
                                                                    }
                                                                    break block92;
                                                                }
                                                                if (!this.cmd.hasOption("d")) break block101;
                                                                int lineNumber = this.dbFunctions.getValue(this.cmd.getOptionValues("d"), this.lines.length);
                                                                if (lineNumber > 0 && DMLBreakpointManager.getBreakpoint(lineNumber) != null && DMLBreakpointManager.getBreakpoint(lineNumber).getBPInstructionStatus() != BreakPointInstruction.BPINSTRUCTION_STATUS.INVISIBLE) {
                                                                    this.dbprog.accessBreakpoint(lineNumber, 1, BreakPointInstruction.BPINSTRUCTION_STATUS.INVISIBLE);
                                                                    break block92;
                                                                } else {
                                                                    System.out.println("Sorry, a breakpoint cannot be deleted at line " + lineNumber + ". Please try a different line number.");
                                                                }
                                                                break block92;
                                                            }
                                                            if (!this.cmd.hasOption("i")) break block102;
                                                            infoOptions = this.cmd.getOptionValues("i");
                                                            if (infoOptions != null && infoOptions.length != 0) break block103;
                                                            System.err.println("The command \"info\" requires option. Try \"info break\" or \"info frame\".");
                                                            break block92;
                                                        }
                                                        if (!infoOptions[0].trim().equals("break")) break block104;
                                                        this.dbFunctions.listBreakpoints(DMLBreakpointManager.getBreakpoints());
                                                        break block92;
                                                    }
                                                    if (infoOptions[0].trim().equals("frame")) {
                                                        if (!runtime.isAlive()) {
                                                            System.err.println("Runtime has not been started. Try \"r\" or \"s\" to start DML runtime execution.");
                                                            break block92;
                                                        } else {
                                                            this.dbFunctions.printCallStack(this.currEC.getDebugState().getCurrentFrame(), this.currEC.getDebugState().getCallStack());
                                                        }
                                                        break block92;
                                                    } else {
                                                        System.err.println("Invalid option for command \"info\".  Try \"info break\" or \"info frame\".");
                                                    }
                                                    break block92;
                                                }
                                                if (!this.cmd.hasOption("p")) break block105;
                                                pOptions = this.cmd.getOptionValues("p");
                                                if (pOptions != null && pOptions.length == 1) break block106;
                                                System.err.println("Incorrect options for command \"print\"");
                                                break block92;
                                            }
                                            varName = pOptions[0].trim();
                                            if (runtime.isAlive()) {
                                                if (varName.contains("[")) {
                                                    try {
                                                        String variableNameWithoutIndices = varName.split("\\[")[0].trim();
                                                        String indexString = varName.split("\\[")[1].trim().split("\\]")[0].trim();
                                                        String rowIndexStr = "";
                                                        String colIndexStr = "";
                                                        if (indexString.startsWith(",")) {
                                                            colIndexStr = indexString.split(",")[1].trim();
                                                        } else if (indexString.endsWith(",")) {
                                                            rowIndexStr = indexString.split(",")[0].trim();
                                                        } else {
                                                            rowIndexStr = indexString.split(",")[0].trim();
                                                            colIndexStr = indexString.split(",")[1].trim();
                                                        }
                                                        int rowIndex = -1;
                                                        int colIndex = -1;
                                                        if (!rowIndexStr.isEmpty()) {
                                                            rowIndex = Integer.parseInt(rowIndexStr);
                                                        }
                                                        if (!colIndexStr.isEmpty()) {
                                                            colIndex = Integer.parseInt(colIndexStr);
                                                        }
                                                        this.dbFunctions.print(this.currEC.getDebugState().getVariables(), variableNameWithoutIndices, "value", rowIndex, colIndex);
                                                    }
                                                    catch (Exception indicesException) {
                                                        System.err.println("Incorrect format for \"p\". If you are trying to print matrix variable M, you can use M[1,] or M[,1] or M[1,1] (without spaces).");
                                                    }
                                                    break block92;
                                                } else {
                                                    this.dbFunctions.print(this.currEC.getDebugState().getVariables(), varName, "value", -1, -1);
                                                }
                                                break block92;
                                            } else {
                                                System.err.println("Runtime has not been started. Try \"r\" or \"s\" to start DML runtime execution.");
                                            }
                                            break block92;
                                        }
                                        if (!this.cmd.hasOption("whatis")) break block107;
                                        pOptions = this.cmd.getOptionValues("whatis");
                                        if (pOptions == null || pOptions.length != 1) {
                                            System.err.println("Incorrect options for command \"whatis\"");
                                            break block92;
                                        } else {
                                            varName = pOptions[0].trim();
                                            this.dbFunctions.print(this.currEC.getDebugState().getVariables(), varName, "metadata", -1, -1);
                                        }
                                        break block92;
                                    }
                                    if (!this.cmd.hasOption("set")) break block108;
                                    pOptions = this.cmd.getOptionValues("set");
                                    if (pOptions == null || pOptions.length != 2) {
                                        System.err.println("Incorrect options for command \"set\"");
                                        break block92;
                                    } else {
                                        try {
                                            if (pOptions[0].contains("[")) {
                                                String[] paramsToSetMatrix = new String[4];
                                                paramsToSetMatrix[0] = pOptions[0].split("\\[")[0].trim();
                                                String indexString = pOptions[0].split("\\[")[1].trim().split("\\]")[0].trim();
                                                paramsToSetMatrix[1] = indexString.split(",")[0].trim();
                                                paramsToSetMatrix[2] = indexString.split(",")[1].trim();
                                                paramsToSetMatrix[3] = pOptions[1].trim();
                                                this.dbFunctions.setMatrixCell(this.currEC.getDebugState().getVariables(), paramsToSetMatrix);
                                                break block92;
                                            }
                                            this.dbFunctions.setScalarValue(this.currEC.getDebugState().getVariables(), pOptions);
                                        }
                                        catch (Exception exception1) {
                                            System.out.println("Only scalar variable or a matrix cell available in current frame can be set in current version.");
                                        }
                                    }
                                    break block92;
                                }
                                if (!this.cmd.hasOption("l")) break block109;
                                pOptions = this.cmd.getOptionValues("l");
                                argsForRange = new String[2];
                                int currentPC = 1;
                                if (runtime.isAlive()) {
                                    currentPC = this.currEC.getDebugState().getPC().getLineNumber();
                                }
                                range = null;
                                if (pOptions == null) {
                                    range = new IntRange(currentPC, Math.min(this.lines.length, currentPC + 10));
                                } else if (pOptions.length == 1 && pOptions[0].trim().toLowerCase().equals("all")) {
                                    range = new IntRange(1, this.lines.length);
                                } else if (pOptions.length == 2 && pOptions[0].trim().toLowerCase().equals("next")) {
                                    int numLines = 10;
                                    try {
                                        numLines = Integer.parseInt(pOptions[1]);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    argsForRange[0] = "" + currentPC;
                                    argsForRange[1] = "" + Math.min(this.lines.length, numLines + currentPC);
                                    range = this.dbFunctions.getRange(argsForRange, this.lines.length);
                                } else if (pOptions.length == 2 && pOptions[0].trim().toLowerCase().equals("prev")) {
                                    int numLines = 10;
                                    try {
                                        numLines = Integer.parseInt(pOptions[1]);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    argsForRange[0] = "" + Math.max(1, currentPC - numLines);
                                    argsForRange[1] = "" + currentPC;
                                    range = this.dbFunctions.getRange(argsForRange, this.lines.length);
                                }
                                if (range == null) {
                                    System.err.println("Incorrect usage of command \"l\". Try \"l\" or \"l all\" or \"l next 5\" or \"l prev 5\".");
                                    break block92;
                                } else if (range.getMinimumInteger() > 0) {
                                    this.dbFunctions.printLines(this.lines, range);
                                    break block92;
                                } else {
                                    System.err.println("Sorry no lines that can be printed. Try \"l\" or \"l all\" or \"l next 5\" or \"l prev 5\".");
                                }
                                break block92;
                            }
                            if (!this.cmd.hasOption("li")) break block110;
                            pOptions = this.cmd.getOptionValues("li");
                            argsForRange = new String[2];
                            int currentPC = 1;
                            if (runtime.isAlive()) {
                                currentPC = this.currEC.getDebugState().getPC().getLineNumber();
                            }
                            range = null;
                            if (pOptions == null) {
                                range = new IntRange(currentPC, Math.min(this.lines.length, currentPC + 10));
                            } else if (pOptions.length == 1 && pOptions[0].trim().toLowerCase().equals("all")) {
                                range = new IntRange(1, this.lines.length);
                            } else if (pOptions.length == 2 && pOptions[0].trim().toLowerCase().equals("next")) {
                                int numLines = 10;
                                try {
                                    numLines = Integer.parseInt(pOptions[1]);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                argsForRange[0] = "" + currentPC;
                                argsForRange[1] = "" + Math.min(this.lines.length, numLines + currentPC);
                                range = this.dbFunctions.getRange(argsForRange, this.lines.length);
                            } else if (pOptions.length == 2 && pOptions[0].trim().toLowerCase().equals("prev")) {
                                int numLines = 10;
                                try {
                                    numLines = Integer.parseInt(pOptions[1]);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                argsForRange[0] = "" + Math.max(1, currentPC - numLines);
                                argsForRange[1] = "" + currentPC;
                                range = this.dbFunctions.getRange(argsForRange, this.lines.length);
                            }
                            if (range == null) {
                                System.err.println("Incorrect usage of command \"li\". Try \"li\" or \"li all\" or \"li next 5\" or \"li prev 5\".");
                                break block92;
                            } else if (range.getMinimumInteger() > 0) {
                                this.dbFunctions.printInstructions(this.lines, this.dbprog.getDMLInstMap(), range, false);
                                break block92;
                            } else {
                                System.err.println("Sorry no lines that can be printed. Try \"li\" or \"li all\" or \"li next 5\" or \"li prev 5\".");
                            }
                            break block92;
                        }
                        if (this.cmd.hasOption("set_scalar")) {
                            if (!runtime.isAlive()) {
                                System.err.println("Runtime has not been started. Try \"r\" to start DML runtime execution.");
                            } else {
                                this.dbFunctions.setScalarValue(this.currEC.getDebugState().getVariables(), this.cmd.getOptionValues("set_scalar"));
                            }
                        } else if (this.cmd.hasOption("m")) {
                            String varname = this.dbFunctions.getValue(this.cmd.getOptionValues("m"));
                            if (runtime.isAlive()) {
                                this.dbFunctions.printMatrixVariable(this.currEC.getDebugState().getVariables(), varname);
                            } else {
                                System.err.println("Runtime has not been started. Try \"r\" to start DML runtime execution.");
                            }
                        } else if (this.cmd.hasOption("x")) {
                            if (!runtime.isAlive()) {
                                System.err.println("Runtime has not been started. Try \"r\" to start DML runtime execution.");
                            } else {
                                this.dbFunctions.printMatrixCell(this.currEC.getDebugState().getVariables(), this.cmd.getOptionValues("x"));
                            }
                        } else if (this.cmd.hasOption("set_cell")) {
                            if (!runtime.isAlive()) {
                                System.err.println("Runtime has not been started. Try \"r\" to start DML runtime execution.");
                            } else {
                                this.dbFunctions.setMatrixCell(this.currEC.getDebugState().getVariables(), this.cmd.getOptionValues("set_cell"));
                            }
                        } else {
                            System.err.println("Undefined command. Try \"help\".");
                        }
                    }
                    this.wait(300L);
                    while (isRuntimeInstruction && !this.currEC.getDebugState().canAcceptNextCommand() && !this.quit) {
                        this.wait(300L);
                    }
                }
                this.wait(300L);
            }
            catch (Exception e) {
                System.err.println("Error processing debugger command. Try \"help\".");
            }
        }
    }
}

