/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import java.util.ArrayList;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryMRInstructionBase;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.UnaryOperator;

public class UnaryInstruction
extends UnaryMRInstructionBase {
    public UnaryInstruction(MRInstruction.MRType type, Operator op, byte in, byte out, String istr) {
        super(type, op, in, out);
        this.instString = istr;
    }

    public static UnaryInstruction parseInstruction(String str) {
        String opcode = InstructionUtils.getOpCode(str);
        InstructionUtils.checkNumFields(str, 2);
        String[] parts = InstructionUtils.getInstructionParts(str);
        byte in = Byte.parseByte(parts[1]);
        byte out = Byte.parseByte(parts[2]);
        return new UnaryInstruction(MRInstruction.MRType.Unary, InstructionUtils.parseUnaryOperator(opcode), in, out, str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) {
        ArrayList<IndexedMatrixValue> blkList = cachedValues.get(this.input);
        if (blkList != null) {
            for (IndexedMatrixValue in : blkList) {
                if (in == null) continue;
                IndexedMatrixValue out = this.input == this.output ? tempValue : cachedValues.holdPlace(this.output, valueClass);
                out.getIndexes().setIndexes(in.getIndexes());
                in.getValue().unaryOperations((UnaryOperator)this.optr, out.getValue());
                if (out != tempValue) continue;
                cachedValues.add(this.output, out);
            }
        }
    }
}

