/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.mr.AggregateBinaryInstruction;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.TaggedFirstSecondIndexes;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.matrix.mapred.MapperBase;

public class MMCJMRMapper
extends MapperBase
implements Mapper<Writable, Writable, Writable, Writable> {
    private AggregateBinaryInstruction aggBinInstruction;
    private TaggedFirstSecondIndexes taggedIndexes = new TaggedFirstSecondIndexes();
    private byte tagForLeft = 0;
    private byte tagForRight = 1;

    public void map(Writable rawKey, Writable rawValue, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
        this.commonMap(rawKey, rawValue, out, reporter);
    }

    @Override
    public void configure(JobConf job) {
        AggregateBinaryInstruction[] ins;
        super.configure(job);
        try {
            ins = MRJobConfiguration.getAggregateBinaryInstructions(job);
        }
        catch (DMLRuntimeException e) {
            throw new RuntimeException(e);
        }
        if (ins.length != 1) {
            throw new RuntimeException("MMCJ only perform one aggregate binary instruction");
        }
        this.aggBinInstruction = ins[0];
        MatrixCharacteristics dim1 = MRJobConfiguration.getMatrixCharactristicsForBinAgg(job, this.aggBinInstruction.input1);
        MatrixCharacteristics dim2 = MRJobConfiguration.getMatrixCharactristicsForBinAgg(job, this.aggBinInstruction.input2);
        if (dim1.getRows() > dim2.getCols()) {
            this.tagForLeft = 1;
            this.tagForRight = 0;
        }
    }

    @Override
    protected void specialOperationsForActualMap(int index, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
        this.processMapperInstructionsForMatrix(index);
        this.processMMCJInMapperAndOutput(this.aggBinInstruction, this.tagForLeft, this.tagForRight, this.taggedIndexes, out);
    }

    protected void processMMCJInMapperAndOutput(AggregateBinaryInstruction aggBinInstruction, byte tagForLeft, byte tagForRight, TaggedFirstSecondIndexes taggedIndexes, OutputCollector<Writable, Writable> out) throws IOException {
        ArrayList<IndexedMatrixValue> blkList2;
        ArrayList<IndexedMatrixValue> blkList1 = this.cachedValues.get(aggBinInstruction.input1);
        if (blkList1 != null) {
            for (IndexedMatrixValue result : blkList1) {
                if (result == null) continue;
                taggedIndexes.setTag(tagForLeft);
                taggedIndexes.setIndexes(result.getIndexes().getColumnIndex(), result.getIndexes().getRowIndex());
                if (((MatrixBlock)result.getValue()).isEmptyBlock()) continue;
                out.collect((Object)taggedIndexes, (Object)result.getValue());
            }
        }
        if ((blkList2 = this.cachedValues.get(aggBinInstruction.input2)) != null) {
            for (IndexedMatrixValue result : blkList2) {
                if (result == null) continue;
                taggedIndexes.setTag(tagForRight);
                taggedIndexes.setIndexes(result.getIndexes().getRowIndex(), result.getIndexes().getColumnIndex());
                if (((MatrixBlock)result.getValue()).isEmptyBlock()) continue;
                out.collect((Object)taggedIndexes, (Object)result.getValue());
            }
        }
    }
}

