/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.layers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.nn.layers.max_pool2d_builtin.Forward_output;

public class Max_pool2d_builtin
extends Script {
    public Max_pool2d_builtin() {
        String string = "scripts/nn/layers/max_pool2d_builtin.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Forward_output forward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        String string = "source('scripts/nn/layers/max_pool2d_builtin.dml') as mlcontextns;[out, Hout, Wout] = mlcontextns::forward(X, C, Hin, Win, Hf, Wf, strideh, stridew, padh, padw);";
        Script script = new Script(string);
        script.in("X", object).in("C", object2).in("Hin", object3).in("Win", object4).in("Hf", object5).in("Wf", object6).in("strideh", object7).in("stridew", object8).in("padh", object9).in("padw", object10).out("out").out("Hout").out("Wout");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("out");
        long l = mLResults.getLong("Hout");
        long l2 = mLResults.getLong("Wout");
        Forward_output forward_output = new Forward_output(matrix, l, l2);
        return forward_output;
    }

    public String forward__docs() {
        String string = "forward = function(matrix[double] X, int C, int Hin, int Win, int Hf, int Wf,\n                   int strideh, int stridew, int padh, int padw)\n    return (matrix[double] out, int Hout, int Wout) {\n  /*\n   * Computes the forward pass for a 2D spatial max pooling layer.\n   * The input data has N examples, each represented as a 3D volume\n   * unrolled into a single vector.\n   *\n   * This implementation uses a built-in operator for higher\n   * performance.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *      A typical value is 0.\n   *  - padw: Padding for left and right sides.\n   *      A typical value is 0.\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, C*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   */\n";
        return string;
    }

    public String forward__source() {
        String string = "forward = function(matrix[double] X, int C, int Hin, int Win, int Hf, int Wf,\n                   int strideh, int stridew, int padh, int padw)\n    return (matrix[double] out, int Hout, int Wout) {\n  /*\n   * Computes the forward pass for a 2D spatial max pooling layer.\n   * The input data has N examples, each represented as a 3D volume\n   * unrolled into a single vector.\n   *\n   * This implementation uses a built-in operator for higher\n   * performance.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *      A typical value is 0.\n   *  - padw: Padding for left and right sides.\n   *      A typical value is 0.\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, C*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   */\n  N = nrow(X)\n  Hout = as.integer(floor((Hin + 2*padh - Hf)/strideh + 1))\n  Wout = as.integer(floor((Win + 2*padw - Wf)/stridew + 1))\n\n  # Max pooling - built-in implementation\n  out = max_pool(X, input_shape=[N,C,Hin,Win], pool_size=[Hf,Wf],\n                 stride=[strideh,stridew], padding=[padh,padw])\n}\n";
        return string;
    }

    public Matrix backward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13) {
        String string = "source('scripts/nn/layers/max_pool2d_builtin.dml') as mlcontextns;dX = mlcontextns::backward(dout, Hout, Wout, X, C, Hin, Win, Hf, Wf, strideh, stridew, padh, padw);";
        Script script = new Script(string);
        script.in("dout", object).in("Hout", object2).in("Wout", object3).in("X", object4).in("C", object5).in("Hin", object6).in("Win", object7).in("Hf", object8).in("Wf", object9).in("strideh", object10).in("stridew", object11).in("padh", object12).in("padw", object13).out("dX");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("dX");
        return matrix;
    }

    public String backward__docs() {
        String string = "backward = function(matrix[double] dout, int Hout, int Wout, matrix[double] X,\n                    int C, int Hin, int Win, int Hf, int Wf,\n                    int strideh, int stridew, int padh, int padw)\n    return (matrix[double] dX) {\n  /*\n   * Computes the backward pass for a 2D spatial max pooling layer.\n   * The input data has N examples, each represented as a 3D volume\n   * unrolled into a single vector.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of\n   *      shape (N, C*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *      A typical value is 0.\n   *  - padw: Padding for left and right sides.\n   *      A typical value is 0.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, C*Hin*Win).\n   */\n";
        return string;
    }

    public String backward__source() {
        String string = "backward = function(matrix[double] dout, int Hout, int Wout, matrix[double] X,\n                    int C, int Hin, int Win, int Hf, int Wf,\n                    int strideh, int stridew, int padh, int padw)\n    return (matrix[double] dX) {\n  /*\n   * Computes the backward pass for a 2D spatial max pooling layer.\n   * The input data has N examples, each represented as a 3D volume\n   * unrolled into a single vector.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of\n   *      shape (N, C*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *      A typical value is 0.\n   *  - padw: Padding for left and right sides.\n   *      A typical value is 0.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, C*Hin*Win).\n   */\n  N = nrow(X)\n\n  # Gradient of max pooling\n  dX = max_pool_backward(X, dout, input_shape=[N,C,Hin,Win], pool_size=[Hf,Wf],\n                         stride=[strideh,stridew], padding=[padh,padw])\n}\n";
        return string;
    }
}

