/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.context;

import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.controlprogram.LocalVariableMap;
import org.apache.sysds.runtime.controlprogram.Program;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;

public class ExecutionContextFactory {
    public static ExecutionContext createContext() {
        return ExecutionContextFactory.createContext(null);
    }

    public static ExecutionContext createContext(Program prog) {
        return ExecutionContextFactory.createContext(true, prog);
    }

    public static ExecutionContext createContext(LocalVariableMap vars, Program prog) {
        ExecutionContext ec = ExecutionContextFactory.createContext(false, prog);
        ec.setVariables(vars);
        return ec;
    }

    public static ExecutionContext createContext(boolean allocateVars, Program prog) {
        return ExecutionContextFactory.createContext(allocateVars, DMLScript.LINEAGE, prog);
    }

    public static ExecutionContext createContext(boolean allocateVars, boolean allocateLineage, Program prog) {
        ExecutionContext ec = null;
        switch (DMLScript.getGlobalExecMode()) {
            case SINGLE_NODE: {
                if (OptimizerUtils.getDefaultExecutionMode() == Types.ExecMode.HYBRID) {
                    ec = new ExecutionContext(allocateVars, allocateLineage, prog);
                    break;
                }
                ec = new SparkExecutionContext(allocateVars, allocateLineage, prog);
                break;
            }
            case SPARK: 
            case HYBRID: {
                ec = new SparkExecutionContext(allocateVars, allocateLineage, prog);
            }
        }
        return ec;
    }
}

