/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.readers;

import org.apache.sysds.runtime.DMLCompressionException;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ReaderColumnSelectionDenseSingleBlock
extends ReaderColumnSelection {
    private double[] _data;
    private int indexOff;
    private int _numCols;

    public ReaderColumnSelectionDenseSingleBlock(MatrixBlock data, int[] colIndices) {
        super(colIndices, data.getNumRows());
        this._data = data.getDenseBlockValues();
        this.indexOff = 0;
        if (data.getDenseBlock().numBlocks() > 1) {
            throw new DMLCompressionException("Not handling multi block data reading in dense reader");
        }
        this._numCols = data.getNumColumns();
    }

    @Override
    protected DblArray getNextRow() {
        if (this._lastRow == this._numRows - 1) {
            return null;
        }
        ++this._lastRow;
        boolean empty = true;
        for (int i = 0; i < this._colIndexes.length; ++i) {
            double v = this._data[this.indexOff + this._colIndexes[i]];
            if (v != 0.0) {
                empty = false;
            }
            this.reusableArr[i] = v;
        }
        this.indexOff += this._numCols;
        return empty ? this.emptyReturn : this.reusableReturn;
    }
}

