/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp;

import com.google.inject.Inject;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.server.api.ApplicationContext;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class AppBlock
extends HtmlBlock {
    protected ApplicationContext appContext;

    @Inject
    AppBlock(ApplicationContext appContext, View.ViewContext ctx) {
        super(ctx);
        this.appContext = appContext;
    }

    protected void render(HtmlBlock.Block html) {
        Collection attempts;
        ApplicationReport appReport;
        String aid = this.$("app.id");
        if (aid.isEmpty()) {
            this.puts(new Object[]{"Bad request: requires Application ID"});
            return;
        }
        ApplicationId appID = null;
        try {
            appID = Apps.toAppID((String)aid);
        }
        catch (Exception e) {
            this.puts(new Object[]{"Invalid Application ID: " + aid});
            return;
        }
        final ApplicationId appIDFinal = appID;
        UserGroupInformation callerUGI = this.getCallerUGI();
        try {
            appReport = callerUGI == null ? this.appContext.getApplication(appID) : (ApplicationReport)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ApplicationReport>(){

                @Override
                public ApplicationReport run() throws Exception {
                    return AppBlock.this.appContext.getApplication(appIDFinal);
                }
            });
        }
        catch (Exception e) {
            String message = "Failed to read the application " + appID + ".";
            LOG.error(message, (Throwable)e);
            html.p()._(new Object[]{message})._();
            return;
        }
        if (appReport == null) {
            this.puts(new Object[]{"Application not found: " + aid});
            return;
        }
        AppInfo app = new AppInfo(appReport);
        this.setTitle(StringHelper.join((Object[])new Object[]{"Application ", aid}));
        this.info("Application Overview")._("User:", (Object)app.getUser())._("Name:", (Object)app.getName())._("Application Type:", (Object)app.getType())._("State:", (Object)app.getAppState())._("FinalStatus:", (Object)app.getFinalAppStatus())._("Started:", (Object)Times.format((long)app.getStartedTime()))._("Elapsed:", (Object)StringUtils.formatTime((long)Times.elapsed((long)app.getStartedTime(), (long)app.getFinishedTime())))._("Tracking URL:", app.getTrackingUrl() == null ? "#" : this.root_url(new String[]{app.getTrackingUrl()}), (Object)"History")._("Diagnostics:", (Object)app.getDiagnosticsInfo());
        html._(InfoBlock.class);
        try {
            attempts = callerUGI == null ? this.appContext.getApplicationAttempts(appID).values() : (Collection)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Collection<ApplicationAttemptReport>>(){

                @Override
                public Collection<ApplicationAttemptReport> run() throws Exception {
                    return AppBlock.this.appContext.getApplicationAttempts(appIDFinal).values();
                }
            });
        }
        catch (Exception e) {
            String message = "Failed to read the attempts of the application " + appID + ".";
            LOG.error(message, (Throwable)e);
            html.p()._(new Object[]{message})._();
            return;
        }
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#attempts").thead().tr().th(".id", "Attempt ID").th(".started", "Started").th(".node", "Node").th(".logs", "Logs")._())._()).tbody();
        StringBuilder attemptsTableData = new StringBuilder("[\n");
        for (final ApplicationAttemptReport appAttemptReport : attempts) {
            ContainerReport containerReport;
            AppAttemptInfo appAttempt = new AppAttemptInfo(appAttemptReport);
            try {
                containerReport = callerUGI == null ? this.appContext.getAMContainer(appAttemptReport.getApplicationAttemptId()) : (ContainerReport)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ContainerReport>(){

                    @Override
                    public ContainerReport run() throws Exception {
                        return AppBlock.this.appContext.getAMContainer(appAttemptReport.getApplicationAttemptId());
                    }
                });
            }
            catch (Exception e) {
                String message = "Failed to read the AM container of the application attempt " + appAttemptReport.getApplicationAttemptId() + ".";
                LOG.error(message, (Throwable)e);
                html.p()._(new Object[]{message})._();
                return;
            }
            long startTime = Long.MAX_VALUE;
            String logsLink = null;
            if (containerReport != null) {
                ContainerInfo container = new ContainerInfo(containerReport);
                startTime = container.getStartedTime();
                logsLink = containerReport.getLogUrl();
            }
            String nodeLink = null;
            if (appAttempt.getHost() != null && appAttempt.getRpcPort() >= 0 && appAttempt.getRpcPort() < 65536) {
                nodeLink = appAttempt.getHost() + ":" + appAttempt.getRpcPort();
            }
            attemptsTableData.append("[\"<a href='").append(this.url(new String[]{"appattempt", appAttempt.getAppAttemptId()})).append("'>").append(appAttempt.getAppAttemptId()).append("</a>\",\"").append(startTime).append("\",\"<a href='").append(nodeLink == null ? "#" : this.url(new String[]{"//", nodeLink})).append("'>").append(nodeLink == null ? "N/A" : StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)nodeLink))).append("</a>\",\"<a href='").append(logsLink == null ? "#" : logsLink).append("'>").append(logsLink == null ? "N/A" : "Logs").append("</a>\"],\n");
        }
        if (attemptsTableData.charAt(attemptsTableData.length() - 2) == ',') {
            attemptsTableData.delete(attemptsTableData.length() - 2, attemptsTableData.length() - 1);
        }
        attemptsTableData.append("]");
        html.script().$type("text/javascript")._(new Object[]{"var attemptsTableData=" + attemptsTableData})._();
        ((Hamlet.TABLE)tbody._())._();
    }
}

