/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.functionobjects;

import java.util.HashMap;
import org.apache.commons.math3.util.FastMath;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.DMLScriptException;
import org.apache.sysds.runtime.functionobjects.ValueFunction;

public class Builtin
extends ValueFunction {
    private static final long serialVersionUID = 3836744687789840574L;
    public BuiltinCode bFunc;
    private static final boolean FASTMATH = true;
    public static HashMap<String, BuiltinCode> String2BuiltinCode = new HashMap();

    private Builtin(BuiltinCode bf) {
        this.bFunc = bf;
    }

    public BuiltinCode getBuiltinCode() {
        return this.bFunc;
    }

    public static boolean isBuiltinCode(ValueFunction fn, BuiltinCode ... codes) {
        for (BuiltinCode code : codes) {
            if (!(fn instanceof Builtin) || ((Builtin)fn).getBuiltinCode() != code) continue;
            return true;
        }
        return false;
    }

    public static boolean isBuiltinFnObject(String str) {
        return String2BuiltinCode.containsKey(str);
    }

    public static Builtin getBuiltinFnObject(String str) {
        BuiltinCode code = String2BuiltinCode.get(str);
        return Builtin.getBuiltinFnObject(code);
    }

    public static Builtin getBuiltinFnObject(BuiltinCode code) {
        if (code == null) {
            return null;
        }
        return new Builtin(code);
    }

    @Override
    public double execute(double in) {
        switch (this.bFunc) {
            case SIN: {
                return FastMath.sin((double)in);
            }
            case COS: {
                return FastMath.cos((double)in);
            }
            case TAN: {
                return FastMath.tan((double)in);
            }
            case ASIN: {
                return FastMath.asin((double)in);
            }
            case ACOS: {
                return FastMath.acos((double)in);
            }
            case ATAN: {
                return Math.atan(in);
            }
            case SINH: {
                return FastMath.sinh((double)in);
            }
            case COSH: {
                return FastMath.cosh((double)in);
            }
            case TANH: {
                return FastMath.tanh((double)in);
            }
            case CEIL: {
                return FastMath.ceil((double)in);
            }
            case FLOOR: {
                return FastMath.floor((double)in);
            }
            case LOG: {
                return Math.log(in);
            }
            case LOG_NZ: {
                return in == 0.0 ? 0.0 : Math.log(in);
            }
            case ABS: {
                return Math.abs(in);
            }
            case SIGN: {
                return FastMath.signum((double)in);
            }
            case SQRT: {
                return Math.sqrt(in);
            }
            case EXP: {
                return FastMath.exp((double)in);
            }
            case ROUND: {
                return Math.round(in);
            }
            case PLOGP: {
                if (in == 0.0) {
                    return 0.0;
                }
                if (in < 0.0) {
                    return Double.NaN;
                }
                return in * Math.log(in);
            }
            case SPROP: {
                return in * (1.0 - in);
            }
            case SIGMOID: {
                return 1.0 / (1.0 + FastMath.exp((double)(-in)));
            }
            case ISNA: {
                return Double.isNaN(in) ? 1.0 : 0.0;
            }
            case ISNAN: {
                return Double.isNaN(in) ? 1.0 : 0.0;
            }
            case ISINF: {
                return Double.isInfinite(in) ? 1.0 : 0.0;
            }
        }
        throw new DMLRuntimeException("Builtin.execute(): Unknown operation: " + (Object)((Object)this.bFunc));
    }

    @Override
    public double execute(long in) {
        return this.execute((double)in);
    }

    @Override
    public double execute(double in1, double in2) {
        switch (this.bFunc) {
            case MAX: 
            case CUMMAX: {
                return Math.max(in1, in2);
            }
            case MIN: 
            case CUMMIN: {
                return Math.min(in1, in2);
            }
            case MAXINDEX: {
                if (in1 == in2) {
                    return 2.0;
                }
                if (in1 > in2) {
                    return 1.0;
                }
                return 0.0;
            }
            case MININDEX: {
                if (in1 == in2) {
                    return 2.0;
                }
                if (in1 < in2) {
                    return 1.0;
                }
                return 0.0;
            }
            case LOG: {
                return Math.log(in1) / Math.log(in2);
            }
            case LOG_NZ: {
                return in1 == 0.0 ? 0.0 : Math.log(in1) / Math.log(in2);
            }
        }
        throw new DMLRuntimeException("Builtin.execute(): Unknown operation: " + (Object)((Object)this.bFunc));
    }

    @Override
    public double execute(long in1, long in2) {
        switch (this.bFunc) {
            case MAX: 
            case CUMMAX: {
                return Math.max(in1, in2);
            }
            case MIN: 
            case CUMMIN: {
                return Math.min(in1, in2);
            }
            case MAXINDEX: {
                return in1 >= in2 ? 1.0 : 0.0;
            }
            case MININDEX: {
                return in1 <= in2 ? 1.0 : 0.0;
            }
            case LOG: {
                return Math.log(in1) / Math.log(in2);
            }
            case LOG_NZ: {
                return in1 == 0L ? 0.0 : Math.log(in1) / Math.log(in2);
            }
        }
        throw new DMLRuntimeException("Builtin.execute(): Unknown operation: " + (Object)((Object)this.bFunc));
    }

    @Override
    public String execute(String in1) {
        switch (this.bFunc) {
            case PRINT: {
                if (!DMLScript.suppressPrint2Stdout()) {
                    System.out.println(in1);
                }
                return null;
            }
            case PRINTF: {
                if (!DMLScript.suppressPrint2Stdout()) {
                    System.out.println(in1);
                }
                return null;
            }
            case STOP: {
                throw new DMLScriptException(in1);
            }
        }
        throw new DMLRuntimeException("Builtin.execute(): Unknown operation: " + (Object)((Object)this.bFunc));
    }

    public String toString() {
        return "Builtin:" + (Object)((Object)this.bFunc);
    }

    static {
        String2BuiltinCode.put("autoDiff", BuiltinCode.AUTODIFF);
        String2BuiltinCode.put("sin", BuiltinCode.SIN);
        String2BuiltinCode.put("cos", BuiltinCode.COS);
        String2BuiltinCode.put("tan", BuiltinCode.TAN);
        String2BuiltinCode.put("sinh", BuiltinCode.SINH);
        String2BuiltinCode.put("cosh", BuiltinCode.COSH);
        String2BuiltinCode.put("tanh", BuiltinCode.TANH);
        String2BuiltinCode.put("asin", BuiltinCode.ASIN);
        String2BuiltinCode.put("acos", BuiltinCode.ACOS);
        String2BuiltinCode.put("atan", BuiltinCode.ATAN);
        String2BuiltinCode.put("log", BuiltinCode.LOG);
        String2BuiltinCode.put("log_nz", BuiltinCode.LOG_NZ);
        String2BuiltinCode.put("min", BuiltinCode.MIN);
        String2BuiltinCode.put("max", BuiltinCode.MAX);
        String2BuiltinCode.put("maxindex", BuiltinCode.MAXINDEX);
        String2BuiltinCode.put("minindex", BuiltinCode.MININDEX);
        String2BuiltinCode.put("abs", BuiltinCode.ABS);
        String2BuiltinCode.put("sign", BuiltinCode.SIGN);
        String2BuiltinCode.put("sqrt", BuiltinCode.SQRT);
        String2BuiltinCode.put("exp", BuiltinCode.EXP);
        String2BuiltinCode.put("plogp", BuiltinCode.PLOGP);
        String2BuiltinCode.put("print", BuiltinCode.PRINT);
        String2BuiltinCode.put("printf", BuiltinCode.PRINTF);
        String2BuiltinCode.put("eval", BuiltinCode.EVAL);
        String2BuiltinCode.put("list", BuiltinCode.LIST);
        String2BuiltinCode.put("nrow", BuiltinCode.NROW);
        String2BuiltinCode.put("ncol", BuiltinCode.NCOL);
        String2BuiltinCode.put("length", BuiltinCode.LENGTH);
        String2BuiltinCode.put("round", BuiltinCode.ROUND);
        String2BuiltinCode.put("stop", BuiltinCode.STOP);
        String2BuiltinCode.put("ceil", BuiltinCode.CEIL);
        String2BuiltinCode.put("floor", BuiltinCode.FLOOR);
        String2BuiltinCode.put("ucumk+", BuiltinCode.CUMSUM);
        String2BuiltinCode.put("ucum*", BuiltinCode.CUMPROD);
        String2BuiltinCode.put("ucumk+*", BuiltinCode.CUMSUMPROD);
        String2BuiltinCode.put("ucummin", BuiltinCode.CUMMIN);
        String2BuiltinCode.put("ucummax", BuiltinCode.CUMMAX);
        String2BuiltinCode.put("inverse", BuiltinCode.INVERSE);
        String2BuiltinCode.put("sprop", BuiltinCode.SPROP);
        String2BuiltinCode.put("sigmoid", BuiltinCode.SIGMOID);
        String2BuiltinCode.put("typeOf", BuiltinCode.TYPEOF);
        String2BuiltinCode.put("detectSchema", BuiltinCode.DETECTSCHEMA);
        String2BuiltinCode.put("isna", BuiltinCode.ISNA);
        String2BuiltinCode.put("isnan", BuiltinCode.ISNAN);
        String2BuiltinCode.put("isinf", BuiltinCode.ISINF);
        String2BuiltinCode.put("dropInvalidType", BuiltinCode.DROP_INVALID_TYPE);
        String2BuiltinCode.put("dropInvalidLength", BuiltinCode.DROP_INVALID_LENGTH);
        String2BuiltinCode.put("_map", BuiltinCode.MAP);
    }

    public static enum BuiltinCode {
        AUTODIFF,
        SIN,
        COS,
        TAN,
        SINH,
        COSH,
        TANH,
        ASIN,
        ACOS,
        ATAN,
        LOG,
        LOG_NZ,
        MIN,
        MAX,
        ABS,
        SIGN,
        SQRT,
        EXP,
        PLOGP,
        PRINT,
        PRINTF,
        NROW,
        NCOL,
        LENGTH,
        LINEAGE,
        ROUND,
        MAXINDEX,
        MININDEX,
        STOP,
        CEIL,
        FLOOR,
        CUMSUM,
        CUMPROD,
        CUMMIN,
        CUMMAX,
        CUMSUMPROD,
        INVERSE,
        SPROP,
        SIGMOID,
        EVAL,
        LIST,
        TYPEOF,
        DETECTSCHEMA,
        ISNA,
        ISNAN,
        ISINF,
        DROP_INVALID_TYPE,
        DROP_INVALID_LENGTH,
        MAP,
        COUNT_DISTINCT,
        COUNT_DISTINCT_APPROX;

    }
}

