/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data;

import java.util.Iterator;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.LongLongDoubleHashMap;

public class CTableMap {
    private final LongLongDoubleHashMap _map;
    private long _maxRow = -1L;
    private long _maxCol = -1L;

    public CTableMap() {
        this(LongLongDoubleHashMap.EntryType.LONG);
    }

    public CTableMap(LongLongDoubleHashMap.EntryType type) {
        this._map = new LongLongDoubleHashMap(type);
        this._maxRow = -1L;
        this._maxCol = -1L;
    }

    public int size() {
        return this._map.size();
    }

    public Iterator<LongLongDoubleHashMap.ADoubleEntry> getIterator() {
        return this._map.getIterator();
    }

    public long getMaxRow() {
        return this._maxRow;
    }

    public long getMaxColumn() {
        return this._maxCol;
    }

    public void aggregate(long row, long col, double w) {
        this._map.addValue(row, col, w);
        this._maxRow = Math.max(this._maxRow, row);
        this._maxCol = Math.max(this._maxCol, col);
    }

    public MatrixBlock toMatrixBlock(int rlen, int clen) {
        int nnz = this._map.size();
        boolean sparse = MatrixBlock.evalSparseFormatInMemory(rlen, clen, nnz);
        MatrixBlock mb = new MatrixBlock(rlen, clen, sparse, nnz).allocateBlock();
        if (sparse) {
            SparseBlock sblock = mb.getSparseBlock();
            Iterator<LongLongDoubleHashMap.ADoubleEntry> iter2 = this._map.getIterator();
            while (iter2.hasNext()) {
                LongLongDoubleHashMap.ADoubleEntry e = iter2.next();
                double value = e.value;
                int rix = (int)e.getKey1();
                int cix = (int)e.getKey2();
                if (value == 0.0 || rix > rlen || cix > clen) continue;
                sblock.allocate(rix - 1, Math.max(nnz / rlen, 1));
                sblock.append(rix - 1, cix - 1, value);
            }
            mb.sortSparseRows();
            mb.recomputeNonZeros();
        } else {
            Iterator<LongLongDoubleHashMap.ADoubleEntry> iter = this._map.getIterator();
            while (iter.hasNext()) {
                LongLongDoubleHashMap.ADoubleEntry e = iter.next();
                double value = e.value;
                int rix = (int)e.getKey1();
                int cix = (int)e.getKey2();
                if (value == 0.0 || rix > rlen || cix > clen) continue;
                mb.quickSetValue(rix - 1, cix - 1, value);
            }
        }
        return mb;
    }
}

