# -------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# -------------------------------------------------------------

# Autogenerated By   : src/main/python/generator/generator.py
# Autogenerated From : scripts/builtin/outlier.dml

from typing import Dict, Iterable

from systemds.operator import OperationNode, Matrix, Frame, List, MultiReturn, Scalar
from systemds.script_building.dag import OutputType
from systemds.utils.consts import VALID_INPUT_TYPES


def outlier(X: Matrix,
            opposite: bool):
    """
     This outlier-function takes a matrix data set as input from where it determines
     which point(s) have the largest difference from mean.
    
    
    
    :param X: Matrix of Recoded dataset for outlier evaluation
    :param opposite: (1)TRUE for evaluating outlier from upper quartile range,
        (0)FALSE for evaluating outlier from lower quartile range
    :return: matrix indicating outlier values
    """

    params_dict = {'X': X, 'opposite': opposite}
    return Matrix(X.sds_context,
        'outlier',
        named_input_nodes=params_dict)
