/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import java.util.Arrays;
import java.util.Random;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.estim.AComEst;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.compress.estim.encoding.EncodingFactory;
import org.apache.sysds.runtime.compress.estim.encoding.IEncode;
import org.apache.sysds.runtime.compress.estim.sample.SampleEstimatorFactory;
import org.apache.sysds.runtime.controlprogram.parfor.stat.Timing;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseBlockMCSR;
import org.apache.sysds.runtime.data.SparseRow;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ComEstSample
extends AComEst {
    private final MatrixBlock _sample;
    private final int _k;
    private final int _sampleSize;
    private boolean _transposed;

    public ComEstSample(MatrixBlock data, CompressionSettings cs, int sampleSize, int k) {
        super(data, cs);
        this._k = k;
        this._sampleSize = sampleSize;
        this._transposed = this._cs.transposed;
        if (LOG.isDebugEnabled()) {
            Timing time = new Timing(true);
            this._sample = this.sampleData(sampleSize);
            LOG.debug((Object)("Sampling time: " + time.stop()));
        } else {
            this._sample = this.sampleData(sampleSize);
        }
    }

    @Override
    public CompressedSizeInfoColGroup getColGroupInfo(IColIndex colIndexes, int estimate, int maxDistinct) {
        if (this._data.isEmpty() || this.nnzCols != null && colIndexes.size() == 1 && this.nnzCols[colIndexes.get(0)] == 0 || this._cs.transposed && colIndexes.size() == 1 && this._data.isInSparseFormat() && this._data.getSparseBlock().isEmpty(colIndexes.get(0))) {
            return new CompressedSizeInfoColGroup(colIndexes, this.getNumRows(), AColGroup.CompressionType.EMPTY);
        }
        IEncode map = EncodingFactory.createFromMatrixBlock(this._sample, this._transposed, colIndexes);
        return this.extractInfo(map, colIndexes, maxDistinct);
    }

    @Override
    public CompressedSizeInfoColGroup getDeltaColGroupInfo(IColIndex colIndexes, int estimate, int maxDistinct) {
        IEncode map = EncodingFactory.createFromMatrixBlockDelta(this._data, this._transposed, colIndexes, this._sampleSize);
        return this.extractInfo(map, colIndexes, maxDistinct);
    }

    @Override
    protected int worstCaseUpperBound(IColIndex columns) {
        if (this.getNumColumns() == columns.size()) {
            return Math.min(this.getNumRows(), (int)this._data.getNonZeros());
        }
        return this.getNumRows();
    }

    @Override
    protected CompressedSizeInfoColGroup combine(IColIndex combinedColumns, CompressedSizeInfoColGroup g1, CompressedSizeInfoColGroup g2, int maxDistinct) {
        IEncode map = g1.getMap().combine(g2.getMap());
        return this.extractInfo(map, combinedColumns, maxDistinct);
    }

    private CompressedSizeInfoColGroup extractInfo(IEncode map, IColIndex colIndexes, int maxDistinct) {
        double spar = this._data.getSparsity();
        EstimationFactors sampleFacts = map.extractFacts(this._sampleSize, spar, spar, this._cs);
        EstimationFactors em = this.scaleFactors(sampleFacts, colIndexes, maxDistinct, map.isDense());
        return new CompressedSizeInfoColGroup(colIndexes, em, this._cs.validCompressions, map);
    }

    private EstimationFactors scaleFactors(EstimationFactors sampleFacts, IColIndex colIndexes, int maxDistinct, boolean dense) {
        try {
            int numRows = this.getNumRows();
            int nCol = colIndexes.size();
            double scalingFactor = (double)numRows / (double)this._sampleSize;
            long nnz = this.calculateNNZ(colIndexes, scalingFactor);
            int numOffs = this.calculateOffs(sampleFacts, numRows, scalingFactor, colIndexes, (int)nnz);
            int estDistinct = this.distinctCountScale(sampleFacts, numOffs, numRows, maxDistinct, dense, nCol);
            int maxLargestInstanceCount = numRows - estDistinct + 1;
            int scaledLargestInstanceCount = sampleFacts.largestOff < 0 ? numOffs / estDistinct : (int)Math.floor((double)sampleFacts.largestOff * scalingFactor);
            int mostFrequentOffsetCount = Math.max(Math.min(maxLargestInstanceCount, scaledLargestInstanceCount), numRows - numOffs);
            double overallSparsity = this.calculateSparsity(colIndexes, nnz, scalingFactor, sampleFacts.overAllSparsity);
            double tupleSparsity = Math.min(overallSparsity * 1.3, 1.0);
            if (this._cs.isRLEAllowed()) {
                int scaledRuns = Math.max(estDistinct, this.calculateRuns(sampleFacts, scalingFactor, numOffs, estDistinct));
                return new EstimationFactors(estDistinct, numOffs, mostFrequentOffsetCount, sampleFacts.frequencies, sampleFacts.numSingle, numRows, scaledRuns, sampleFacts.lossy, sampleFacts.zeroIsMostFrequent, overallSparsity, tupleSparsity);
            }
            return new EstimationFactors(estDistinct, numOffs, mostFrequentOffsetCount, sampleFacts.frequencies, sampleFacts.numSingle, numRows, sampleFacts.lossy, sampleFacts.zeroIsMostFrequent, overallSparsity, tupleSparsity);
        }
        catch (Exception e) {
            throw new RuntimeException(colIndexes.toString(), e);
        }
    }

    private int distinctCountScale(EstimationFactors sampleFacts, int numOffs, int numRows, int maxDistinct, boolean dense, int nCol) {
        int sampledSize;
        int[] freq = sampleFacts.frequencies;
        if (freq == null || freq.length == 0) {
            return numOffs;
        }
        int est = SampleEstimatorFactory.distinctCount(freq, dense ? numRows : numOffs, sampledSize = sampleFacts.numOffs, this._cs.estimationType);
        if (est > 10000) {
            est = (int)((double)est + (double)est * 0.5);
        }
        if (nCol > 4) {
            est = (int)((double)est + (double)est * (double)nCol / 10.0);
        }
        return Math.max(Math.min(est, Math.min(maxDistinct, numOffs)), 1);
    }

    private int calculateOffs(EstimationFactors sampleFacts, int numRows, double scalingFactor, IColIndex colIndexes, int nnz) {
        if (this.getNumColumns() == 1) {
            return nnz;
        }
        if (this.nnzCols != null) {
            if (colIndexes.size() == 1) {
                return this.nnzCols[colIndexes.get(0)];
            }
            int emptyTuples = sampleFacts.numRows - sampleFacts.numOffs;
            int estOffs = numRows - (int)Math.floor((double)emptyTuples * scalingFactor);
            return Math.min(nnz, estOffs);
        }
        int emptyTuples = sampleFacts.numRows - sampleFacts.numOffs;
        return numRows - (int)Math.floor((double)emptyTuples * scalingFactor);
    }

    private int calculateRuns(EstimationFactors sampleFacts, double scalingFactor, int estOffs, int estDistinct) {
        double nRunsInSample = sampleFacts.numRuns;
        double numRuns = 0.0;
        double sampleToRunRatio = nRunsInSample / (double)sampleFacts.numVals;
        double sampleSizeToRunRatio = nRunsInSample / (double)this._sampleSize;
        numRuns = sampleToRunRatio <= 1.1 && sampleSizeToRunRatio < 0.5 ? sampleToRunRatio * (double)estDistinct : nRunsInSample * scalingFactor;
        numRuns = Math.min(numRuns, (double)estOffs);
        numRuns = Math.max(numRuns, (double)estDistinct);
        numRuns = Math.min(2.147483647E9, Math.ceil(numRuns));
        return (int)numRuns;
    }

    private double calculateSparsity(IColIndex colIndexes, long nnz, double scalingFactor, double sampleValue) {
        if (colIndexes.size() == this.getNumColumns()) {
            return this._data.getSparsity();
        }
        if (this.nnzCols != null || this._cs.transposed && this._data.isInSparseFormat() || this._transposed && this._sample.isInSparseFormat()) {
            return (double)nnz / (double)(this.getNumRows() * colIndexes.size());
        }
        if (this._sample.isEmpty()) {
            return this._data.getSparsity();
        }
        return sampleValue;
    }

    private long calculateNNZ(IColIndex colIndexes, double scalingFactor) {
        if (colIndexes.size() == this.getNumColumns()) {
            return this._data.getNonZeros();
        }
        if (this._cs.transposed && this._data.isInSparseFormat()) {
            long nnzCount = 0L;
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < colIndexes.size(); ++i) {
                nnzCount += (long)sb.get(i).size();
            }
            return nnzCount;
        }
        if (this.nnzCols != null) {
            long nnz = 0L;
            for (int i = 0; i < colIndexes.size(); ++i) {
                nnz += (long)this.nnzCols[colIndexes.get(i)];
            }
            return nnz;
        }
        if (this._sample.isEmpty()) {
            return 0L;
        }
        if (this._transposed && this._sample.isInSparseFormat()) {
            long nnzCount = 0L;
            SparseBlock sb = this._sample.getSparseBlock();
            for (int i = 0; i < colIndexes.size(); ++i) {
                if (sb.isEmpty(i)) continue;
                nnzCount = (long)((double)nnzCount + (double)sb.get(i).size() * scalingFactor);
            }
            if (nnzCount == 0L) {
                nnzCount += (long)colIndexes.size();
            }
            return nnzCount;
        }
        return this._sample.getNonZeros();
    }

    public static int[] getSortedSample(int range, int sampleSize, long seed, int k) {
        int i;
        int[] a = new int[sampleSize];
        Random r = new Random(seed);
        for (i = 0; i < sampleSize; ++i) {
            a[i] = i;
        }
        for (i = sampleSize; i < range; ++i) {
            if (r.nextInt(i) >= sampleSize) continue;
            a[r.nextInt((int)sampleSize)] = i;
        }
        if (range / 100 < sampleSize) {
            for (i = 0; i < sampleSize - 1; ++i) {
                int j = r.nextInt(sampleSize - i) + i;
                int tmp = a[i];
                a[i] = a[j];
                a[j] = tmp;
            }
        }
        if (k > 1) {
            Arrays.parallelSort(a);
        } else {
            Arrays.sort(a);
        }
        return a;
    }

    private MatrixBlock sampleData(int sampleSize) {
        int[] sampleRows = ComEstSample.getSortedSample(this.getNumRows(), sampleSize, this._cs.seed, this._k);
        MatrixBlock sampledMatrixBlock = !this._cs.transposed ? (this._data.isInSparseFormat() ? this.sparseNotTransposedSamplePath(sampleRows) : this.denseSamplePath(sampleRows)) : this.defaultSlowSamplingPath(sampleRows);
        return sampledMatrixBlock;
    }

    private MatrixBlock sparseNotTransposedSamplePath(int[] sampleRows) {
        MatrixBlock res = new MatrixBlock(sampleRows.length, this._data.getNumColumns(), true);
        SparseRow[] rows = new SparseRow[sampleRows.length];
        SparseBlock in = this._data.getSparseBlock();
        for (int i = 0; i < sampleRows.length; ++i) {
            rows[i] = in.get(sampleRows[i]);
        }
        res.setSparseBlock(new SparseBlockMCSR(rows, false));
        res.recomputeNonZeros();
        this._transposed = true;
        res = LibMatrixReorg.transposeInPlace(res, this._k);
        return res;
    }

    private MatrixBlock defaultSlowSamplingPath(int[] sampleRows) {
        MatrixBlock select = this._cs.transposed ? new MatrixBlock(this._data.getNumColumns(), 1, false) : new MatrixBlock(this._data.getNumRows(), 1, false);
        for (int i = 0; i < sampleRows.length; ++i) {
            select.appendValue(sampleRows[i], 0, 1.0);
        }
        MatrixBlock ret = this._data.removeEmptyOperations(new MatrixBlock(), !this._cs.transposed, true, select);
        return ret;
    }

    private MatrixBlock denseSamplePath(int[] sampleRows) {
        int sampleSize = sampleRows.length;
        double sampleRatio = this._cs.transposed ? (double)this._data.getNumColumns() / (double)sampleSize : (double)this._data.getNumRows() / (double)sampleSize;
        long inputNonZeros = this._data.getNonZeros();
        long estimatedNonZerosInSample = (long)Math.ceil((double)inputNonZeros / sampleRatio);
        int resRows = this._cs.transposed ? this._data.getNumRows() : this._data.getNumColumns();
        long nCellsInSample = (long)sampleSize * (long)resRows;
        boolean shouldBeSparseSample = 0.4 > (double)estimatedNonZerosInSample / (double)nCellsInSample;
        MatrixBlock res = new MatrixBlock(resRows, sampleSize, shouldBeSparseSample);
        res.allocateBlock();
        DenseBlock inb = this._data.getDenseBlock();
        if (res.isInSparseFormat()) {
            SparseBlock resb = res.getSparseBlock();
            SparseBlockMCSR resbmcsr = (SparseBlockMCSR)resb;
            int estimatedNrDoublesEachRow = (int)Math.max(4.0, Math.ceil(estimatedNonZerosInSample / (long)sampleSize));
            for (int col = 0; col < resRows; ++col) {
                resbmcsr.allocate(col, estimatedNrDoublesEachRow);
            }
            for (int row = 0; row < sampleSize; ++row) {
                int inRow = sampleRows[row];
                double[] inBlockV = inb.values(inRow);
                int offIn = inb.pos(inRow);
                for (int col = 0; col < resRows; ++col) {
                    SparseRow srow = resbmcsr.get(col);
                    srow.append(row, inBlockV[offIn + col]);
                }
            }
        } else {
            DenseBlock resb = res.getDenseBlock();
            for (int row = 0; row < sampleSize; ++row) {
                int inRow = sampleRows[row];
                double[] inBlockV = inb.values(inRow);
                int offIn = inb.pos(inRow);
                for (int col = 0; col < resRows; ++col) {
                    double[] blockV = resb.values(col);
                    blockV[col * sampleSize + row] = inBlockV[offIn + col];
                }
            }
        }
        res.setNonZeros(estimatedNonZerosInSample);
        this._transposed = true;
        return res;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" sampleSize: ");
        sb.append(this._sampleSize);
        sb.append(" transposed: ");
        sb.append(this._transposed);
        return sb.toString();
    }
}

