/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.iogen;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.iogen.MappingProperties;
import org.apache.sysds.runtime.iogen.RawIndex;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.UtilFunctions;

public class ReaderMapping {
    private int[][] mapRow;
    private int[][] mapCol;
    private int[][] mapLen;
    private MappingProperties mappingProperties;
    private final int nrows;
    private final int ncols;
    private int nlines;
    private int actualValueCount;
    private RawIndex[] sampleRawIndexes;
    private MatrixBlock sampleMatrix;
    private FrameBlock sampleFrame;
    private Types.ValueType[] schema;
    private final boolean isMatrix;

    public ReaderMapping(int nlines, int nrows, int ncols, RawIndex[] sampleRawIndexes, MatrixBlock matrix) throws Exception {
        this.nlines = nlines;
        this.nrows = nrows;
        this.ncols = ncols;
        this.sampleRawIndexes = sampleRawIndexes;
        this.sampleMatrix = matrix;
        this.isMatrix = true;
        this.runMapping(true);
    }

    public ReaderMapping(String raw, MatrixBlock matrix) throws Exception {
        this.ReadRaw(raw);
        this.isMatrix = true;
        this.sampleMatrix = matrix;
        this.nrows = this.sampleMatrix.getNumRows();
        this.ncols = this.sampleMatrix.getNumColumns();
        this.runMapping(false);
    }

    public ReaderMapping(String raw, FrameBlock frame) throws Exception {
        this.ReadRaw(raw);
        this.isMatrix = false;
        this.sampleFrame = frame;
        this.nrows = this.sampleFrame.getNumRows();
        this.ncols = this.sampleFrame.getNumColumns();
        this.schema = this.sampleFrame.getSchema();
        this.runMapping(false);
    }

    private void ReadRaw(String raw) throws Exception {
        String value;
        InputStream is = IOUtilFunctions.toInputStream(raw);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        ArrayList<String> rawList = new ArrayList<String>();
        while ((value = br.readLine()) != null) {
            rawList.add(value);
        }
        this.nlines = rawList.size();
        this.sampleRawIndexes = new RawIndex[this.nlines];
        int numThreads = OptimizerUtils.getParallelTextWriteParallelism();
        try {
            ExecutorService pool = CommonThreadPool.get(numThreads);
            ArrayList<BuildRawIndexTask> tasks = new ArrayList<BuildRawIndexTask>();
            int blklen = (int)Math.ceil((double)this.nlines / (double)numThreads);
            for (int i = 0; i < numThreads; ++i) {
                int beginIndex = i * blklen;
                int endIndex = Math.min((i + 1) * blklen, this.nlines);
                tasks.add(new BuildRawIndexTask(rawList, this.sampleRawIndexes, beginIndex, endIndex));
            }
            List rt = pool.invokeAll(tasks);
            pool.shutdown();
            for (Future task : rt) {
                task.get();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed parallel ReadRaw.", e);
        }
    }

    private void runMapping(boolean isIndexMapping) {
        int c;
        int r;
        this.mapRow = new int[this.nrows][this.ncols];
        this.mapCol = new int[this.nrows][this.ncols];
        this.mapLen = new int[this.nrows][this.ncols];
        this.mappingProperties = new MappingProperties();
        for (int r2 = 0; r2 < this.nrows; ++r2) {
            for (int c2 = 0; c2 < this.ncols; ++c2) {
                this.mapLen[r2][c2] = -1;
                this.mapCol[r2][c2] = -1;
                this.mapRow[r2][c2] = -1;
            }
        }
        int itRow = 0;
        for (int r3 = 0; r3 < this.nrows; ++r3) {
            block3: for (int c3 = 0; c3 < this.ncols; ++c3) {
                if (!isIndexMapping && !this.checkValueIsNotNullZero(r3, c3)) continue;
                HashSet<Integer> checkedLines = new HashSet<Integer>();
                while (checkedLines.size() < this.nlines) {
                    Pair<Integer, Integer> pair;
                    RawIndex ri = this.sampleRawIndexes[itRow];
                    Pair<Integer, Integer> pair2 = pair = this.isMatrix ? ri.findValue(this.sampleMatrix.getValue(r3, c3)) : ri.findValue(this.sampleFrame.get(r3, c3), this.schema[c3]);
                    if (pair != null) {
                        this.mapRow[r3][c3] = itRow;
                        this.mapCol[r3][c3] = pair.getKey();
                        this.mapLen[r3][c3] = pair.getValue();
                        continue block3;
                    }
                    checkedLines.add(itRow);
                    if (++itRow != this.nlines) continue;
                    itRow = 0;
                }
            }
        }
        this.actualValueCount = 0;
        int mappedValueCount = 0;
        for (int r4 = 0; r4 < this.nrows; ++r4) {
            for (int c4 = 0; c4 < this.ncols; ++c4) {
                if (!this.checkValueIsNotNullZero(r4, c4)) continue;
                ++this.actualValueCount;
                if (this.mapRow[r4][c4] == -1) continue;
                ++mappedValueCount;
            }
        }
        if (this.actualValueCount == mappedValueCount) {
            this.mappingProperties.setTypicalRepresentation();
            this.mappingProperties.setDataFullExist();
        } else if (this.actualValueCount > 0 && mappedValueCount == 0) {
            this.mappingProperties.setDataNotExist();
        } else if (mappedValueCount > 0 && mappedValueCount < this.actualValueCount) {
            this.mappingProperties.setDataPartiallyExist();
        }
        boolean singleLine = true;
        int[] firstLineNumbers = new int[this.nrows];
        for (r = 0; r < this.nrows; ++r) {
            int c5;
            firstLineNumbers[r] = -1;
            for (c5 = 0; c5 < this.ncols && firstLineNumbers[r] == -1; ++c5) {
                firstLineNumbers[r] = this.mapRow[r][c5];
            }
            while (c5 < this.ncols && singleLine) {
                if (this.mapRow[r][c5] != -1) {
                    singleLine = firstLineNumbers[r] == this.mapRow[r][c5];
                }
                ++c5;
            }
        }
        for (r = 0; r < this.nrows - 1 && singleLine; ++r) {
            singleLine = firstLineNumbers[r + 1] - firstLineNumbers[r] == 1;
        }
        if (singleLine) {
            this.mappingProperties.setRecordSingleLine();
            boolean allValuesInALine = true;
            block11: for (int r5 = 0; r5 < this.nrows && allValuesInALine; ++r5) {
                for (c = 0; c < this.ncols; ++c) {
                    if (this.mapRow[r5][c] == -1 || this.mapRow[r5][c] == firstLineNumbers[0]) continue;
                    allValuesInALine = false;
                    continue block11;
                }
            }
            if (allValuesInALine) {
                int t = 0;
                for (c = 0; c < this.ncols; ++c) {
                    for (int r6 = 0; r6 < this.nrows - 1; ++r6) {
                        if (this.mapCol[r6][c] != -1 || this.mapCol[r6][c] <= this.mapCol[r6 + 1][c]) continue;
                        ++t;
                    }
                }
                if ((double)((float)t / (float)this.actualValueCount) < 0.03) {
                    this.mappingProperties.setArrayRowWiseRepresentation();
                } else {
                    this.mappingProperties.setArrayColWiseRepresentation();
                }
            }
        } else {
            this.mappingProperties.setRecordMultiLine();
        }
        if (this.nrows == this.ncols && !this.mappingProperties.isRepresentation()) {
            boolean symmetricMap = true;
            for (int r7 = 0; r7 < this.nrows && symmetricMap; ++r7) {
                for (c = 0; c <= r7 && symmetricMap; ++c) {
                    symmetricMap = this.checkSymmetricValue(r7, c, 1);
                }
            }
            if (symmetricMap) {
                this.mappingProperties.setSymmetricRepresentation();
            }
            if (!this.mappingProperties.isRepresentation()) {
                boolean skewSymmetricMap = true;
                for (int r8 = 0; r8 < this.nrows && skewSymmetricMap; ++r8) {
                    for (int c6 = 0; c6 <= r8 && skewSymmetricMap; ++c6) {
                        skewSymmetricMap = this.checkSymmetricValue(r8, c6, -1);
                    }
                }
                if (skewSymmetricMap) {
                    this.mappingProperties.setSkewSymmetricRepresentation();
                }
            }
            if (!this.mappingProperties.isRepresentation()) {
                boolean patternMap = false;
                Object patternValueMap = null;
                boolean homoSchema = true;
                Types.ValueType vtc0 = null;
                if (!this.isMatrix) {
                    vtc0 = this.sampleFrame.getSchema()[0];
                    for (int c7 = 1; c7 < this.ncols && homoSchema; ++c7) {
                        homoSchema = this.sampleFrame.getSchema()[c7] == vtc0;
                    }
                }
                for (int r9 = 0; r9 < this.nrows; ++r9) {
                    int c8;
                    HashSet<Object> patternValueSet;
                    if (this.isMatrix) {
                        patternValueSet = new HashSet<Object>();
                        for (c8 = 0; c8 < this.ncols; ++c8) {
                            patternValueSet.add(this.sampleMatrix.getValue(r9, c8));
                        }
                        if (patternValueSet.size() != 1) continue;
                        vtc0 = Types.ValueType.FP64;
                        patternMap = true;
                        patternValueMap = patternValueSet.iterator().next();
                        continue;
                    }
                    if (!homoSchema) continue;
                    patternValueSet = new HashSet();
                    for (c8 = 0; c8 < this.ncols; ++c8) {
                        patternValueSet.add(this.sampleFrame.get(r9, c8));
                    }
                    if (patternValueSet.size() != 1) continue;
                    patternMap = true;
                    patternValueMap = patternValueSet.iterator().next();
                }
                if (patternMap) {
                    this.mappingProperties.setPatternRepresentation(vtc0, patternValueMap);
                }
            }
        }
    }

    private boolean checkValueIsNotNullZero(int r, int c) {
        boolean result = this.isMatrix ? this.sampleMatrix.getValue(r, c) != 0.0 : (this.sampleFrame.getSchema()[c].isNumeric() ? this.sampleFrame.getDouble(r, c) != 0.0 : this.sampleFrame.get(r, c) != null);
        return result;
    }

    private boolean checkSymmetricValue(int r, int c, int a) {
        boolean result = this.isMatrix ? this.sampleMatrix.getValue(r, c) == this.sampleMatrix.getValue(c, r) * (double)a : (this.sampleFrame.getSchema()[c].isNumeric() ? this.sampleFrame.getDouble(r, c) == this.sampleFrame.getDouble(c, r) * (double)a : this.sampleFrame.get(r, c).equals(this.sampleFrame.get(c, r)));
        return result;
    }

    public int[][] getMapRow() {
        return this.mapRow;
    }

    public int[][] getMapCol() {
        return this.mapCol;
    }

    public int[][] getMapLen() {
        return this.mapLen;
    }

    public RawIndex[] getSampleRawIndexes() {
        return this.sampleRawIndexes;
    }

    public int getNrows() {
        return this.nrows;
    }

    public int getNcols() {
        return this.ncols;
    }

    public int getNlines() {
        return this.nlines;
    }

    public MappingProperties getMappingProperties() {
        return this.mappingProperties;
    }

    public int getActualValueCount() {
        return this.actualValueCount;
    }

    public boolean compareCellValue(int r, int c, String value) {
        if (this.isMatrix) {
            try {
                return this.sampleMatrix.getValue(r, c) == UtilFunctions.objectToDouble(Types.ValueType.FP64, value);
            }
            catch (Exception exception) {
                return false;
            }
        }
        try {
            return this.sampleFrame.get(r, c).equals(UtilFunctions.stringToObject(this.sampleFrame.getColumnType(c), value));
        }
        catch (Exception exception) {
            return false;
        }
    }

    private class BuildRawIndexTask
    implements Callable<Object> {
        private final ArrayList<String> rawList;
        private RawIndex[] sampleRawIndex;
        private final int beginIndex;
        private final int endIndex;

        public BuildRawIndexTask(ArrayList<String> rawList, RawIndex[] sampleRawIndex, int beginIndex, int endIndex) {
            this.rawList = rawList;
            this.sampleRawIndex = sampleRawIndex;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        @Override
        public Object call() throws Exception {
            for (int i = this.beginIndex; i < this.endIndex; ++i) {
                this.sampleRawIndex[i] = new RawIndex(this.rawList.get(i));
            }
            return null;
        }
    }
}

