/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PorterStemmer {
    private static int calcM(String word) {
        int l = word.length();
        int count = 0;
        boolean currentConst = false;
        for (int c = 0; c < l; ++c) {
            if (PorterStemmer.cons(word, c)) {
                if (!currentConst && c != 0) {
                    ++count;
                }
                currentConst = true;
                continue;
            }
            currentConst = false;
        }
        return count;
    }

    private static boolean doublec(String word) {
        int len = word.length() - 1;
        if (len < 1) {
            return false;
        }
        if (word.charAt(len) != word.charAt(len - 1)) {
            return false;
        }
        return PorterStemmer.cons(word, len);
    }

    private static boolean cvc(String word) {
        int len = word.length();
        int l = len - 1;
        if (len < 3) {
            return false;
        }
        if (!PorterStemmer.cons(word, l) | PorterStemmer.cons(word, l - 1) | !PorterStemmer.cons(word, l - 2)) {
            return false;
        }
        String exceptions = "wxy";
        String ch = String.valueOf(word.charAt(l));
        return !exceptions.contains(ch);
    }

    private static boolean vowelinStem(String word, String suffix) {
        int length = word.length() - suffix.length();
        for (int i = 0; i < length; ++i) {
            if (PorterStemmer.cons(word, i)) continue;
            return true;
        }
        return false;
    }

    private static boolean cons(String stem, int i) {
        String vowels = "aeiou";
        char ch = stem.charAt(i);
        if (vowels.contains(String.valueOf(stem.charAt(i)))) {
            return false;
        }
        if (ch == 'y') {
            if (i == 0) {
                return true;
            }
            return !PorterStemmer.cons(stem, i - 1);
        }
        return true;
    }

    private static String processMatched(String word, HashMap<String, String> suffixAndfix, int mCount) {
        String stemmed = null;
        Iterator<Map.Entry<String, String>> it = suffixAndfix.entrySet().iterator();
        while (it.hasNext() && stemmed == null) {
            Map.Entry<String, String> pair = it.next();
            stemmed = PorterStemmer.replacer(word, pair.getKey().toString(), pair.getValue(), mCount);
            it.remove();
        }
        return stemmed;
    }

    private static String replacer(String word, String orig, String replace, int mCount) {
        int l = word.length();
        int suffixLength = orig.length();
        if (word.endsWith(orig)) {
            String stem = word.substring(0, l - suffixLength);
            int m = PorterStemmer.calcM(stem);
            if (m > mCount) {
                return stem.concat(replace);
            }
            return word;
        }
        return null;
    }

    private static String step1(String word) {
        boolean flag = false;
        if (word.endsWith("s")) {
            if (word.endsWith("sses")) {
                word = StringUtils.removeEnd((String)word, (String)"es");
            } else if (word.endsWith("ies")) {
                word = StringUtils.removeEnd((String)word, (String)"ies").concat("i");
            } else if (!word.endsWith("ss") && word.endsWith("s")) {
                word = StringUtils.removeEnd((String)word, (String)"s");
            }
        }
        if (word.endsWith("eed")) {
            if (PorterStemmer.calcM(word) > 1) {
                word = StringUtils.removeEnd((String)word, (String)"d");
            }
        } else if (word.endsWith("ed") && PorterStemmer.vowelinStem(word, "ed")) {
            word = StringUtils.removeEnd((String)word, (String)"ed");
            flag = true;
        } else if (word.endsWith("ing") && PorterStemmer.vowelinStem(word, "ing")) {
            word = StringUtils.removeEnd((String)word, (String)"ing");
            flag = true;
        }
        if (flag) {
            if (word.endsWith("at") || word.endsWith("bl") || word.endsWith("iz")) {
                word = word.concat("e");
            }
            int m = PorterStemmer.calcM(word);
            String last = String.valueOf(word.charAt(word.length() - 1));
            if (PorterStemmer.doublec(word) && !"lsz".contains(last)) {
                word = word.substring(0, word.length() - 1);
            } else if (m == 1 && PorterStemmer.cvc(word)) {
                word = word.concat("e");
            }
        }
        if (word.endsWith("y") && PorterStemmer.vowelinStem(word, "y")) {
            word = StringUtils.removeEnd((String)word, (String)"y").concat("i");
        }
        return word;
    }

    private static String step2(String word) {
        int len = word.length();
        if (len == 0) {
            return word;
        }
        HashMap<String, String> suffixAndfix = new HashMap<String, String>();
        suffixAndfix.put("ational", "ate");
        suffixAndfix.put("tional", "tion");
        suffixAndfix.put("enci", "ence");
        suffixAndfix.put("anci", "ance");
        suffixAndfix.put("izer", "ize");
        suffixAndfix.put("bli", "ble");
        suffixAndfix.put("alli", "al");
        suffixAndfix.put("entli", "ent");
        suffixAndfix.put("eli", "e");
        suffixAndfix.put("ousli", "ous");
        suffixAndfix.put("ization", "ize");
        suffixAndfix.put("ation", "ate");
        suffixAndfix.put("ator", "ate");
        suffixAndfix.put("alism", "al");
        suffixAndfix.put("iveness", "ive");
        suffixAndfix.put("fulness", "ful");
        suffixAndfix.put("ousness", "ous");
        suffixAndfix.put("aliti", "al");
        suffixAndfix.put("iviti", "ive");
        suffixAndfix.put("biliti", "ble");
        suffixAndfix.put("log", "logi");
        suffixAndfix.put("icate", "ic");
        suffixAndfix.put("ative", "");
        suffixAndfix.put("alize", "al");
        suffixAndfix.put("iciti", "ic");
        suffixAndfix.put("ical", "ic");
        String stemmed = PorterStemmer.processMatched(word, suffixAndfix, 0);
        return stemmed != null ? stemmed : word;
    }

    private static String step3(String word) {
        int len = word.length();
        if (len == 0) {
            return word;
        }
        HashMap<String, String> suffixAndfix = new HashMap<String, String>();
        suffixAndfix.put("icate", "ic");
        suffixAndfix.put("ative", "");
        suffixAndfix.put("alize", "al");
        suffixAndfix.put("iciti", "ic");
        suffixAndfix.put("ical", "ic");
        suffixAndfix.put("ful", "");
        suffixAndfix.put("ness", "");
        String stemmed = PorterStemmer.processMatched(word, suffixAndfix, 0);
        return stemmed != null ? stemmed : word;
    }

    private static String step4(String word) {
        char ch;
        int i;
        String[] suffix = new String[]{"al", "ance", "ence", "er", "ic", "able", "ible", "ant", "ement", "ment", "ent"};
        String stemmed = null;
        for (i = 0; stemmed == null && i < suffix.length; ++i) {
            stemmed = PorterStemmer.replacer(word, suffix[i], "", 1);
        }
        if (stemmed == null && word.length() > 4 && ((ch = word.charAt(word.length() - 4)) == 's' || ch == 't')) {
            stemmed = PorterStemmer.replacer(word, "ion", "", 1);
        }
        if (stemmed == null) {
            suffix = new String[]{"ou", "ism", "ate", "iti", "ous", "ive", "ize"};
            for (i = 0; stemmed == null && i < suffix.length; ++i) {
                stemmed = PorterStemmer.replacer(word, suffix[i], "", 1);
            }
        }
        return stemmed != null ? stemmed : word;
    }

    private static String step5(String word) {
        String stem = StringUtils.removeEnd((String)word, (String)"e");
        if (word.endsWith("e") && PorterStemmer.calcM(word) > 1) {
            word = stem;
        }
        if (word.endsWith("e") && PorterStemmer.calcM(word) == 1 && !PorterStemmer.cvc(stem)) {
            word = stem;
        }
        if (word.endsWith("l") && PorterStemmer.doublec(word) && PorterStemmer.calcM(word) > 1) {
            word = word.substring(0, word.length() - 1);
        }
        return word;
    }

    public static String stem(String word) {
        if (word.length() >= 3) {
            word = PorterStemmer.step1(word);
            word = PorterStemmer.step2(word);
            word = PorterStemmer.step3(word);
            if ((word = PorterStemmer.step4(word)).length() > 0) {
                word = PorterStemmer.step5(word);
            }
        }
        return word;
    }
}

