/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;

public class GPUStatistics {
    private static int iNoOfExecutedGPUInst = 0;
    public static long cudaInitTime = 0L;
    public static LongAdder cudaLibrariesInitTime = new LongAdder();
    public static LongAdder cudaSparseToDenseTime = new LongAdder();
    public static LongAdder cudaDenseToSparseTime = new LongAdder();
    public static LongAdder cudaSparseConversionTime = new LongAdder();
    public static LongAdder cudaSparseToDenseCount = new LongAdder();
    public static LongAdder cudaDenseToSparseCount = new LongAdder();
    public static LongAdder cudaSparseConversionCount = new LongAdder();
    public static LongAdder cudaAllocTime = new LongAdder();
    public static LongAdder cudaAllocSuccessTime = new LongAdder();
    public static LongAdder cudaAllocFailedTime = new LongAdder();
    public static LongAdder cudaDeAllocTime = new LongAdder();
    public static LongAdder cudaMemSet0Time = new LongAdder();
    public static LongAdder cudaToDevTime = new LongAdder();
    public static LongAdder cudaFromDevTime = new LongAdder();
    public static LongAdder cudaFromShadowToHostTime = new LongAdder();
    public static LongAdder cudaFromShadowToDevTime = new LongAdder();
    public static LongAdder cudaFromDevToShadowTime = new LongAdder();
    public static LongAdder cudaEvictTime = new LongAdder();
    public static LongAdder cudaEvictSizeTime = new LongAdder();
    public static LongAdder cudaFloat2DoubleTime = new LongAdder();
    public static LongAdder cudaDouble2FloatTime = new LongAdder();
    public static LongAdder cudaEvictMemcpyTime = new LongAdder();
    public static LongAdder cudaForcedClearLazyFreedEvictTime = new LongAdder();
    public static LongAdder cudaForcedClearUnpinnedEvictTime = new LongAdder();
    public static LongAdder cudaAllocCount = new LongAdder();
    public static LongAdder cudaDeAllocCount = new LongAdder();
    public static LongAdder cudaMemSet0Count = new LongAdder();
    public static LongAdder cudaToDevCount = new LongAdder();
    public static LongAdder cudaFromDevCount = new LongAdder();
    public static LongAdder cudaFromShadowToHostCount = new LongAdder();
    public static LongAdder cudaFromShadowToDevCount = new LongAdder();
    public static LongAdder cudaFromDevToShadowCount = new LongAdder();
    public static LongAdder cudaEvictCount = new LongAdder();
    public static LongAdder cudaEvictSizeCount = new LongAdder();
    public static LongAdder cudaFloat2DoubleCount = new LongAdder();
    public static LongAdder cudaDouble2FloatCount = new LongAdder();
    public static LongAdder cudaAllocSuccessCount = new LongAdder();
    public static LongAdder cudaAllocFailedCount = new LongAdder();
    public static LongAdder cudaAllocReuseCount = new LongAdder();
    private static HashMap<String, HashMap<String, Long>> _cpInstMiscTime = new HashMap();
    private static HashMap<String, HashMap<String, Long>> _cpInstMiscCount = new HashMap();

    public static void resetMiscTimers() {
        _cpInstMiscTime.clear();
        _cpInstMiscCount.clear();
    }

    public static void reset() {
        cudaInitTime = 0L;
        cudaLibrariesInitTime.reset();
        cudaAllocTime.reset();
        cudaDeAllocTime.reset();
        cudaMemSet0Time.reset();
        cudaMemSet0Count.reset();
        cudaToDevTime.reset();
        cudaFromDevTime.reset();
        cudaFromShadowToHostTime.reset();
        cudaFromShadowToDevTime.reset();
        cudaFromDevToShadowTime.reset();
        cudaEvictTime.reset();
        cudaEvictSizeTime.reset();
        cudaFloat2DoubleTime.reset();
        cudaDouble2FloatTime.reset();
        cudaFloat2DoubleCount.reset();
        cudaDouble2FloatCount.reset();
        cudaForcedClearLazyFreedEvictTime.reset();
        cudaForcedClearUnpinnedEvictTime.reset();
        cudaAllocCount.reset();
        cudaDeAllocCount.reset();
        cudaToDevCount.reset();
        cudaFromDevCount.reset();
        cudaFromShadowToHostCount.reset();
        cudaFromShadowToDevCount.reset();
        cudaFromDevToShadowCount.reset();
        cudaEvictCount.reset();
        cudaEvictSizeCount.reset();
        cudaAllocSuccessTime.reset();
        cudaAllocFailedTime.reset();
        cudaAllocSuccessCount.reset();
        cudaAllocFailedCount.reset();
        cudaAllocReuseCount.reset();
        GPUStatistics.resetMiscTimers();
    }

    public static synchronized void setNoOfExecutedGPUInst(int numJobs) {
        iNoOfExecutedGPUInst = numJobs;
    }

    public static synchronized void incrementNoOfExecutedGPUInst() {
        ++iNoOfExecutedGPUInst;
    }

    public static synchronized int getNoOfExecutedGPUInst() {
        return iNoOfExecutedGPUInst;
    }

    public static String getStringForCPMiscTimesPerInstruction(String instructionName) {
        StringBuffer sb = new StringBuffer();
        HashMap<String, Long> miscTimerMap = _cpInstMiscTime.get(instructionName);
        if (miscTimerMap != null) {
            ArrayList<Map.Entry<String, Long>> sortedList = new ArrayList<Map.Entry<String, Long>>(miscTimerMap.entrySet());
            Collections.sort(sortedList, new Comparator<Map.Entry<String, Long>>(){

                @Override
                public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                    return (int)(o1.getValue() - o2.getValue());
                }
            });
            Iterator miscTimeIter = sortedList.iterator();
            HashMap<String, Long> miscCountMap = _cpInstMiscCount.get(instructionName);
            while (miscTimeIter.hasNext()) {
                Map.Entry e = (Map.Entry)miscTimeIter.next();
                String miscTimerName = (String)e.getKey();
                Long miscTimerTime = (Long)e.getValue();
                Long miscCount = miscCountMap.get(miscTimerName);
                sb.append(miscTimerName + "[" + String.format("%.3f", (double)miscTimerTime.longValue() / 1.0E9) + "s," + miscCount + "]");
                if (!miscTimeIter.hasNext()) continue;
                sb.append(", ");
            }
        }
        return sb.toString();
    }

    public static String getStringForCudaTimers() {
        StringBuffer sb = new StringBuffer();
        sb.append("CUDA/CuLibraries init time:\t" + String.format("%.3f", (double)cudaInitTime * 1.0E-9) + "/" + String.format("%.3f", (double)cudaLibrariesInitTime.longValue() * 1.0E-9) + " sec.\n");
        sb.append("Number of executed GPU inst:\t" + GPUStatistics.getNoOfExecutedGPUInst() + ".\n");
        sb.append("GPU mem alloc time  (alloc(success/fail) / dealloc / set0):\t" + String.format("%.3f", (double)cudaAllocTime.longValue() * 1.0E-9) + "(" + String.format("%.3f", (double)cudaAllocSuccessTime.longValue() * 1.0E-9) + "/" + String.format("%.3f", (double)cudaAllocFailedTime.longValue() * 1.0E-9) + ") / " + String.format("%.3f", (double)cudaDeAllocTime.longValue() * 1.0E-9) + " / " + String.format("%.3f", (double)cudaMemSet0Time.longValue() * 1.0E-9) + " sec.\n");
        sb.append("GPU mem alloc count (alloc(success/fail/reuse) / dealloc / set0):\t" + cudaAllocCount.longValue() + "(" + cudaAllocSuccessCount.longValue() + "/" + cudaAllocFailedCount.longValue() + "/" + cudaAllocReuseCount.longValue() + ") / " + cudaDeAllocCount.longValue() + " / " + cudaMemSet0Count.longValue() + ".\n");
        sb.append("GPU mem tx time  (toDev(d2f/s2d) / fromDev(f2d/s2h) / evict(d2s/size)):\t" + String.format("%.3f", (double)cudaToDevTime.longValue() * 1.0E-9) + "(" + String.format("%.3f", (double)cudaDouble2FloatTime.longValue() * 1.0E-9) + "/" + String.format("%.3f", (double)cudaFromShadowToDevTime.longValue() * 1.0E-9) + ") / " + String.format("%.3f", (double)cudaFromDevTime.longValue() * 1.0E-9) + "(" + String.format("%.3f", (double)cudaFloat2DoubleTime.longValue() * 1.0E-9) + "/" + String.format("%.3f", (double)cudaFromShadowToHostTime.longValue() * 1.0E-9) + ") / " + String.format("%.3f", (double)cudaEvictTime.longValue() * 1.0E-9) + "(" + String.format("%.3f", (double)cudaFromDevToShadowTime.longValue() * 1.0E-9) + "/" + String.format("%.3f", (double)cudaEvictSizeTime.longValue() * 1.0E-9) + ") sec.\n");
        sb.append("GPU mem tx count (toDev(d2f/s2d) / fromDev(f2d/s2h) / evict(d2s/size)):\t" + cudaToDevCount.longValue() + "(" + cudaDouble2FloatCount.longValue() + "/" + cudaFromShadowToDevCount.longValue() + ") / " + cudaFromDevCount.longValue() + "(" + cudaFloat2DoubleCount.longValue() + "/" + cudaFromShadowToHostCount.longValue() + ") / " + cudaEvictCount.longValue() + "(" + cudaFromDevToShadowCount.longValue() + "/" + cudaEvictSizeCount.longValue() + ").\n");
        sb.append("GPU conversion time  (sparseConv / sp2dense / dense2sp):\t" + String.format("%.3f", (double)cudaSparseConversionTime.longValue() * 1.0E-9) + " / " + String.format("%.3f", (double)cudaSparseToDenseTime.longValue() * 1.0E-9) + " / " + String.format("%.3f", (double)cudaDenseToSparseTime.longValue() * 1.0E-9) + " sec.\n");
        sb.append("GPU conversion count (sparseConv / sp2dense / dense2sp):\t" + cudaSparseConversionCount.longValue() + " / " + cudaSparseToDenseCount.longValue() + " / " + cudaDenseToSparseCount.longValue() + ".\n");
        return sb.toString();
    }
}

