/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.conf.DMLConfig;
import org.apache.sysds.lops.Compression;
import org.apache.sysds.parser.DataExpression;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlockFactory;
import org.apache.sysds.runtime.controlprogram.BasicProgramBlock;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.ExecutionContextMap;
import org.apache.sysds.runtime.controlprogram.federated.FederatedLookupTable;
import org.apache.sysds.runtime.controlprogram.federated.FederatedReadCache;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederatedStatistics;
import org.apache.sysds.runtime.controlprogram.federated.FederatedUDF;
import org.apache.sysds.runtime.controlprogram.federated.FederatedWorkerHandlerException;
import org.apache.sysds.runtime.controlprogram.federated.FederatedWorkloadAnalyzer;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.DataObjectModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.EventModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.EventStageModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.RequestModel;
import org.apache.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysds.runtime.controlprogram.parfor.stat.Timing;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.InstructionParser;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.ListObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.io.FileFormatPropertiesCSV;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.lineage.Lineage;
import org.apache.sysds.runtime.lineage.LineageCache;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.matrix.operators.MultiThreadedOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.meta.MetaDataAll;
import org.apache.sysds.runtime.meta.MetaDataFormat;
import org.apache.sysds.runtime.privacy.DMLPrivacyException;
import org.apache.sysds.runtime.privacy.PrivacyMonitor;
import org.apache.sysds.utils.Statistics;
import org.apache.sysds.utils.stats.ParamServStatistics;

public class FederatedWorkerHandler
extends ChannelInboundHandlerAdapter {
    private static final Log LOG = LogFactory.getLog((String)FederatedWorkerHandler.class.getName());
    private final FederatedLookupTable _flt;
    private final FederatedReadCache _frc;
    private Timing _timing = null;
    private final FederatedWorkloadAnalyzer _fan;
    private String _remoteAddress = "nohost";

    public FederatedWorkerHandler(FederatedLookupTable flt, FederatedReadCache frc, FederatedWorkloadAnalyzer fan) {
        this._flt = flt;
        this._frc = frc;
        this._fan = fan;
        if (DMLScript.LINEAGE) {
            LineageCacheConfig.setCompAssRW(false);
        }
    }

    public FederatedWorkerHandler(FederatedLookupTable flt, FederatedReadCache frc, FederatedWorkloadAnalyzer fan, Timing timing) {
        this(flt, frc, fan);
        this._timing = timing;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ctx.writeAndFlush((Object)this.createResponse(msg, ctx.channel().remoteAddress())).addListener((GenericFutureListener)new CloseListener());
    }

    protected FederatedResponse createResponse(Object msg) {
        return this.createResponse(msg, "nohost");
    }

    private FederatedResponse createResponse(Object msg, SocketAddress remoteAddress) {
        String host;
        try {
            if (this._timing != null) {
                ParamServStatistics.accFedNetworkTime((long)this._timing.stop());
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (remoteAddress == null) {
            LOG.warn((Object)"Given remote address of coordinator is null. Continuing with nohost as host identifier.");
            host = "nohost";
        } else if (remoteAddress instanceof InetSocketAddress) {
            host = ((InetSocketAddress)remoteAddress).getHostString();
            this._remoteAddress = remoteAddress.toString();
        } else {
            host = remoteAddress.toString().split(":")[0].split("/")[1];
            this._remoteAddress = remoteAddress.toString();
        }
        FederatedResponse res = this.createResponse(msg, host);
        if (this._timing != null) {
            this._timing.start();
        }
        return res;
    }

    private FederatedResponse createResponse(Object msg, String remoteHost) {
        if (!(msg instanceof FederatedRequest[])) {
            return new FederatedResponse(FederatedResponse.ResponseType.ERROR, new FederatedWorkerHandlerException("Received object of wrong instance 'FederatedRequest[]'."));
        }
        Object[] requests = (FederatedRequest[])msg;
        try {
            return this.createResponse((FederatedRequest[])requests, remoteHost);
        }
        catch (FederatedWorkerHandlerException | DMLPrivacyException ex) {
            LOG.error((Object)("Exception in FederatedWorkerHandler while processing requests:\n" + Arrays.toString(requests)), (Throwable)ex);
            return new FederatedResponse(FederatedResponse.ResponseType.ERROR, ex);
        }
        catch (Exception ex) {
            String error = "Exception thrown while processing requests:\n" + Arrays.toString(requests);
            LOG.error((Object)error, (Throwable)ex);
            return new FederatedResponse(FederatedResponse.ResponseType.ERROR, new FederatedWorkerHandlerException(error));
        }
    }

    private FederatedResponse createResponse(FederatedRequest[] requests, String remoteHost) throws DMLPrivacyException, FederatedWorkerHandlerException, Exception {
        FederatedResponse response = null;
        boolean containsCLEAR = false;
        long clearReqPid = -1L;
        int numGETrequests = 0;
        EventModel event = new EventModel();
        String coordinatorHostIdFormat = "%s-%d";
        event.setCoordinatorHostId(String.format("%s-%d", remoteHost, requests[0].getPID()));
        for (int i = 0; i < requests.length; ++i) {
            FederatedRequest request = requests[i];
            FederatedRequest.RequestType t = request.getType();
            ExecutionContextMap ecm = this._flt.getECM(remoteHost, request.getPID());
            FederatedWorkerHandler.logRequests(request, i, requests.length);
            PrivacyMonitor.setCheckPrivacy(request.checkPrivacy());
            PrivacyMonitor.clearCheckedConstraints();
            EventStageModel eventStage = new EventStageModel();
            FederatedResponse tmp = this.executeCommand(request, ecm, eventStage);
            if (DMLScript.STATISTICS) {
                RequestModel requestStat = new RequestModel(request.getType().name(), 1L);
                requestStat.setCoordinatorHostId(String.format("%s-%d", remoteHost, request.getPID()));
                FederatedStatistics.addWorkerRequest(requestStat);
                event.stages.add(eventStage);
            }
            FederatedWorkerHandler.conditionalAddCheckedConstraints(request, tmp);
            if (!tmp.isSuccessful()) {
                LOG.error((Object)("Command " + t + " resulted in error:\n" + tmp.getErrorMessage()));
                if (DMLScript.STATISTICS) {
                    FederatedStatistics.addEvent(event);
                }
                return tmp;
            }
            if (t == FederatedRequest.RequestType.GET_VAR) {
                if (response != null && numGETrequests > 0) {
                    String message = "Multiple GET_VAR are not supported in single batch of requests.";
                    LOG.error((Object)message);
                    if (DMLScript.STATISTICS) {
                        FederatedStatistics.addEvent(event);
                    }
                    throw new FederatedWorkerHandlerException(message);
                }
                response = tmp;
                ++numGETrequests;
            } else if (response == null && (t == FederatedRequest.RequestType.EXEC_INST || t == FederatedRequest.RequestType.EXEC_UDF)) {
                response = tmp;
            } else if (response == null && i == requests.length - 1) {
                response = tmp;
            }
            if (DMLScript.STATISTICS) {
                if (t == FederatedRequest.RequestType.PUT_VAR || t == FederatedRequest.RequestType.EXEC_UDF) {
                    for (int paramIndex = 0; paramIndex < request.getNumParams(); ++paramIndex) {
                        FederatedStatistics.incFedTransfer(request.getParam(paramIndex), this._remoteAddress, request.getPID());
                    }
                }
                if (t == FederatedRequest.RequestType.GET_VAR) {
                    Object[] data = response.getData();
                    int dataObjIndex = 0;
                    while ((long)dataObjIndex < Arrays.stream(data).count()) {
                        FederatedStatistics.incFedTransfer(data[dataObjIndex], this._remoteAddress, request.getPID());
                        ++dataObjIndex;
                    }
                }
            }
            if (t != FederatedRequest.RequestType.CLEAR) continue;
            containsCLEAR = true;
            clearReqPid = request.getPID();
        }
        if (containsCLEAR) {
            this._flt.removeECM(remoteHost, clearReqPid);
            FederatedWorkerHandler.printStatistics();
        }
        if (DMLScript.STATISTICS) {
            FederatedStatistics.addEvent(event);
        }
        return response;
    }

    private static void printStatistics() {
        if (DMLScript.STATISTICS && Statistics.allowWorkerStatistics) {
            System.out.println("Federated Worker " + Statistics.display());
        }
    }

    private static void logRequests(FederatedRequest request, int nrRequest, int totalRequests) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Executing command " + (nrRequest + 1) + "/" + totalRequests + ": " + request.getType().name()));
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("full command: " + request.toString()));
            }
        }
    }

    private static void conditionalAddCheckedConstraints(FederatedRequest request, FederatedResponse response) {
        if (request.checkPrivacy()) {
            response.setCheckedConstraints(PrivacyMonitor.getCheckedConstraints());
        }
    }

    private FederatedResponse executeCommand(FederatedRequest request, ExecutionContextMap ecm, EventStageModel eventStage) throws DMLPrivacyException, FederatedWorkerHandlerException, Exception {
        FederatedRequest.RequestType method = request.getType();
        FederatedResponse result = null;
        eventStage.startTime = LocalDateTime.now();
        switch (method) {
            case READ_VAR: {
                eventStage.operation = method.name();
                result = this.readData(request, ecm);
                break;
            }
            case PUT_VAR: {
                eventStage.operation = method.name();
                result = this.putVariable(request, ecm);
                break;
            }
            case GET_VAR: {
                eventStage.operation = method.name();
                result = this.getVariable(request, ecm);
                break;
            }
            case EXEC_INST: {
                result = this.execInstruction(request, ecm, eventStage);
                break;
            }
            case EXEC_UDF: {
                result = this.execUDF(request, ecm, eventStage);
                break;
            }
            case CLEAR: {
                eventStage.operation = method.name();
                result = this.execClear(ecm);
                break;
            }
            case NOOP: {
                eventStage.operation = method.name();
                result = FederatedWorkerHandler.execNoop();
                break;
            }
            default: {
                String message = String.format("Method %s is not supported.", new Object[]{method});
                throw new FederatedWorkerHandlerException(message);
            }
        }
        eventStage.endTime = LocalDateTime.now();
        return result;
    }

    private FederatedResponse readData(FederatedRequest request, ExecutionContextMap ecm) {
        FederatedWorkerHandler.checkNumParams(request.getNumParams(), 2, 3);
        String filename = (String)request.getParam(0);
        Types.DataType dt = Types.DataType.valueOf((String)request.getParam(1));
        return this.readData(filename, dt, request.getID(), request.getTID(), ecm, request.getNumParams() == 2 ? null : (CacheBlock)request.getParam(2));
    }

    private FederatedResponse readData(String filename, Types.DataType dataType, long id, long tid, ExecutionContextMap ecm, CacheBlock<?> localBlock) {
        MatrixCharacteristics mc = new MatrixCharacteristics();
        mc.setBlocksize(ConfigurationManager.getBlocksize());
        if (dataType != Types.DataType.MATRIX && dataType != Types.DataType.FRAME) {
            throw new FederatedWorkerHandlerException("Could not recognize datatype");
        }
        ExecutionContext ec = ecm.get(tid);
        LineageItem linItem = new LineageItem(filename);
        CacheableData<?> cd = null;
        String sId = String.valueOf(id);
        boolean linReuse = !LineageCacheConfig.ReuseCacheType.isNone() && dataType == Types.DataType.MATRIX;
        boolean readCache = ConfigurationManager.isFederatedReadCacheEnabled();
        if (!linReuse || !LineageCache.reuseFedRead(sId, dataType, linItem, ec)) {
            cd = this._frc.get(filename, readCache & !linReuse);
            try {
                if (cd == null) {
                    CacheableData<?> cacheableData = cd = localBlock == null ? this.readDataNoReuse(filename, dataType, mc) : ExecutionContext.createCacheableData(localBlock);
                    if (linReuse) {
                        LineageCache.putFedReadObject(cd, linItem, ec);
                    } else if (readCache) {
                        this._frc.setData(filename, cd);
                    }
                }
                ec.setVariable(sId, cd);
            }
            catch (Exception ex) {
                if (linReuse) {
                    LineageCache.putFedReadObject(null, linItem, ec);
                } else {
                    this._frc.setInvalid(filename);
                }
                throw ex;
            }
        }
        if (this.shouldTryAsyncCompress()) {
            CompressedMatrixBlockFactory.compressAsync(ec, sId);
        }
        if (DMLScript.LINEAGE) {
            ec.getLineage().set(sId, linItem);
        }
        if (dataType == Types.DataType.FRAME) {
            FrameObject frameObject = (FrameObject)cd;
            if (frameObject == null) {
                return new FederatedResponse(FederatedResponse.ResponseType.ERROR);
            }
            frameObject.acquireRead();
            frameObject.refreshMetaData();
            frameObject.release();
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, new Object[]{id, frameObject.getSchema(), mc});
        }
        return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, new Object[]{id, mc});
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CacheableData<?> readDataNoReuse(String filename, Types.DataType dataType, MatrixCharacteristics mc) {
        CacheableData cd = null;
        switch (dataType) {
            case MATRIX: {
                cd = new MatrixObject(Types.ValueType.FP64, filename);
                break;
            }
            case FRAME: {
                cd = new FrameObject(filename);
                break;
            }
            default: {
                throw new FederatedWorkerHandlerException("Could not recognize datatype");
            }
        }
        Types.FileFormat fmt = null;
        boolean header = false;
        String delim = null;
        FileSystem fs = null;
        try {
            String mtdName = DataExpression.getMTDFileName(filename);
            Path path = new Path(mtdName);
            fs = IOUtilFunctions.getFileSystem(mtdName);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(path)));){
                MetaDataAll mtd = new MetaDataAll(br);
                if (!mtd.mtdExists()) {
                    throw new FederatedWorkerHandlerException("Could not parse metadata file");
                }
                mc.setRows(mtd.getDim1());
                mc.setCols(mtd.getDim2());
                mc.setNonZeros(mtd.getNnz());
                header = mtd.getHasHeader();
                cd = mtd.parseAndSetPrivacyConstraint(cd);
                fmt = mtd.getFileFormat();
                delim = mtd.getDelim();
            }
        }
        catch (FederatedWorkerHandlerException | DMLPrivacyException ex) {
            try {
                throw ex;
                catch (Exception ex2) {
                    String msg = "Exception of type " + ex2.getClass() + " thrown when processing READ request";
                    LOG.error((Object)msg, (Throwable)ex2);
                    throw new DMLRuntimeException(msg);
                }
            }
            catch (Throwable throwable) {
                IOUtilFunctions.closeSilently(fs);
                throw throwable;
            }
        }
        IOUtilFunctions.closeSilently((Closeable)fs);
        cd.setMetaData(new MetaDataFormat(mc, fmt));
        if (fmt == Types.FileFormat.CSV) {
            cd.setFileFormatProperties(new FileFormatPropertiesCSV(header, delim, false));
        }
        cd.enableCleanup(false);
        return cd;
    }

    private FederatedResponse putVariable(FederatedRequest request, ExecutionContextMap ecm) {
        Data data;
        FederatedWorkerHandler.checkNumParams(request.getNumParams(), 1, 2);
        String varName = String.valueOf(request.getID());
        ExecutionContext ec = ecm.get(request.getTID());
        if (ec.containsVariable(varName)) {
            Data tgtData = ec.removeVariable(varName);
            if (tgtData != null) {
                ec.cleanupDataObject(tgtData);
            }
            LOG.warn((Object)("Variable" + request.getID() + " already existing, fallback to overwritten."));
        }
        Object v = request.getParam(0);
        long size = 0L;
        if (v instanceof CacheBlock) {
            CacheableData<?> block = ExecutionContext.createCacheableData((CacheBlock)v);
            size = block.getDataSize();
            data = block;
        } else if (v instanceof ScalarObject) {
            data = (ScalarObject)v;
            size = ((ScalarObject)v).getSize();
        } else if (v instanceof ListObject) {
            data = (ListObject)v;
            size = ((ListObject)v).getDataSize();
        } else if (request.getNumParams() == 2) {
            Object v1 = request.getParam(1);
            if (v1 == Types.DataType.MATRIX) {
                MatrixObject mtrx = ExecutionContext.createMatrixObject((MatrixCharacteristics)v);
                size = mtrx.getDataSize();
                data = mtrx;
            } else {
                FrameObject frm = ExecutionContext.createFrameObject((MatrixCharacteristics)v);
                size = frm.getDataSize();
                data = frm;
            }
        } else {
            throw new FederatedWorkerHandlerException("Unsupported object type, has to be of type CacheBlock or ScalarObject");
        }
        ec.setVariable(varName, data);
        if (DMLScript.STATISTICS) {
            FederatedStatistics.addDataObject(new DataObjectModel(varName, data.getDataType().name(), data.getValueType().name(), size));
        }
        if (this.shouldTryAsyncCompress()) {
            CompressedMatrixBlockFactory.compressAsync(ec, varName);
        }
        if (DMLScript.LINEAGE) {
            if (request.getParam(0) instanceof CacheBlock && request.getLineageTrace() != null) {
                ec.getLineage().set(varName, Lineage.deserializeSingleTrace(request.getLineageTrace()));
                if (DMLScript.STATISTICS) {
                    FederatedStatistics.aggFedPutLineage(request.getLineageTrace());
                }
            } else if (request.getParam(0) instanceof ScalarObject) {
                ec.getLineage().set(varName, new LineageItem(CPOperand.getLineageLiteral((ScalarObject)request.getParam(0), true)));
            } else if (request.getNumParams() == 1) {
                ec.getLineage().set(varName, new LineageItem(String.valueOf(request.getChecksum(0))));
            }
        }
        return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS_EMPTY);
    }

    private FederatedResponse getVariable(FederatedRequest request, ExecutionContextMap ecm) {
        try {
            FederatedWorkerHandler.checkNumParams(request.getNumParams(), 0);
            ExecutionContext ec = ecm.get(request.getTID());
            if (!ec.containsVariable(String.valueOf(request.getID()))) {
                throw new FederatedWorkerHandlerException("Variable " + request.getID() + " does not exist at federated worker.");
            }
            Data dataObject = ec.getVariable(String.valueOf(request.getID()));
            dataObject = PrivacyMonitor.handlePrivacy(dataObject);
            switch (dataObject.getDataType()) {
                case MATRIX: 
                case FRAME: 
                case TENSOR: {
                    return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, ((CacheableData)dataObject).acquireReadAndRelease(), LineageCacheConfig.ReuseCacheType.isNone() ? null : ec.getLineage().get(String.valueOf(request.getID())));
                }
                case LIST: {
                    return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, ((ListObject)dataObject).getData());
                }
                case SCALAR: {
                    return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, dataObject);
                }
            }
            throw new FederatedWorkerHandlerException("Unsupported return datatype " + dataObject.getDataType().name());
        }
        catch (Exception e) {
            throw new FederatedWorkerHandlerException("Failed to getVariable ", e);
        }
    }

    private FederatedResponse execInstruction(FederatedRequest request, ExecutionContextMap ecm, EventStageModel eventStage) throws Exception {
        Instruction ins = InstructionParser.parseSingleInstruction((String)request.getParam(0));
        eventStage.operation = ins.getExtendedOpcode();
        long tid = request.getTID();
        ExecutionContext ec = FederatedWorkerHandler.getContextForInstruction(tid, ins, ecm);
        FederatedWorkerHandler.setThreads(ins);
        FederatedWorkerHandler.exec(ec, ins);
        FederatedWorkerHandler.adaptToWorkload(ec, this._fan, tid, ins);
        return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS_EMPTY, FederatedWorkerHandler.getOutputNnz(ec, ins));
    }

    private static ExecutionContext getContextForInstruction(long id, Instruction ins, ExecutionContextMap ecm) {
        ExecutionContext ec = ecm.get(id);
        if (ins.getType() == Instruction.IType.SPARK && !(ec instanceof SparkExecutionContext)) {
            ecm.convertToSparkCtx();
            return ecm.get(id);
        }
        return ec;
    }

    private static void setThreads(Instruction ins) {
        Operator op = ins.getOperator();
        if (op instanceof MultiThreadedOperator) {
            int par_inst = ConfigurationManager.getDMLConfig().getIntValue("sysds.federated.par_inst");
            int k = par_inst > 0 ? par_inst : InfrastructureAnalyzer.getLocalParallelism();
            ((MultiThreadedOperator)op).setNumThreads(k);
        }
    }

    private static void exec(ExecutionContext ec, Instruction ins) {
        BasicProgramBlock pb = new BasicProgramBlock(null);
        pb.getInstructions().clear();
        pb.getInstructions().add(ins);
        try {
            pb.execute(ec);
        }
        catch (Exception ex) {
            ec.getVariables().releasePinnedData();
            throw ex;
        }
    }

    private static void adaptToWorkload(ExecutionContext ec, FederatedWorkloadAnalyzer fan, long tid, Instruction ins) {
        if (fan != null) {
            CompletableFuture.runAsync(() -> {
                fan.incrementWorkload(ec, tid, ins);
                fan.compressRun(ec, tid);
            });
        }
    }

    private static long getOutputNnz(ExecutionContext ec, Instruction ins) {
        Data dat;
        if (ins instanceof ComputationCPInstruction && (dat = ec.getVariable(((ComputationCPInstruction)ins).getOutput())) instanceof MatrixObject) {
            return ((MatrixObject)dat).getNnz();
        }
        return -1L;
    }

    private FederatedResponse execUDF(FederatedRequest request, ExecutionContextMap ecm, EventStageModel eventStage) {
        FederatedWorkerHandler.checkNumParams(request.getNumParams(), 1);
        ExecutionContext ec = ecm.get(request.getTID());
        try {
            FederatedResponse reuse;
            FederatedUDF udf = (FederatedUDF)request.getParam(0);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)udf);
            }
            eventStage.operation = udf.getClass().getSimpleName();
            Data[] inputs = (Data[])Arrays.stream(udf.getInputIDs()).mapToObj(id -> ec.getVariable(String.valueOf(id))).map(PrivacyMonitor::handlePrivacy).toArray(Data[]::new);
            if (DMLScript.LINEAGE) {
                LineageItemUtils.traceFedUDF(ec, udf);
            }
            if ((reuse = LineageCache.reuse(udf, ec)).isSuccessful()) {
                return reuse;
            }
            long t0 = !LineageCacheConfig.ReuseCacheType.isNone() ? System.nanoTime() : 0L;
            FederatedResponse res = udf.execute(ec, inputs);
            long t1 = !LineageCacheConfig.ReuseCacheType.isNone() ? System.nanoTime() : 0L;
            LineageCache.putValue(udf, ec, t1 - t0);
            return res;
        }
        catch (FederatedWorkerHandlerException | DMLPrivacyException ex) {
            LOG.debug((Object)"FederatedWorkerHandler Privacy Constraint exception thrown when processing EXEC_UDF request ", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            String msg = "Exception of type " + ex.getClass() + " thrown when processing EXEC_UDF request";
            LOG.error((Object)msg, (Throwable)ex);
            throw new FederatedWorkerHandlerException(msg);
        }
    }

    private FederatedResponse execClear(ExecutionContextMap ecm) {
        try {
            ecm.clear();
            FederatedStatistics.removeDataObjects();
        }
        catch (FederatedWorkerHandlerException | DMLPrivacyException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String msg = "Exception of type " + ex.getClass() + " thrown when processing CLEAR request";
            LOG.error((Object)msg, (Throwable)ex);
            throw new FederatedWorkerHandlerException(msg);
        }
        return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS_EMPTY);
    }

    private static FederatedResponse execNoop() {
        return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS_EMPTY);
    }

    private static void checkNumParams(int actual, int ... expected) {
        if (Arrays.stream(expected).anyMatch(x -> x == actual)) {
            return;
        }
        throw new DMLRuntimeException("FederatedWorkerHandler: Received wrong amount of params: expected=" + Arrays.toString(expected) + ", actual=" + actual);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }

    private boolean shouldTryAsyncCompress() {
        DMLConfig conf = ConfigurationManager.getDMLConfig();
        return Compression.CompressConfig.valueOf(conf.getTextValue("sysds.compressed.linalg").toUpperCase()) == Compression.CompressConfig.TRUE;
    }

    private static class CloseListener
    implements ChannelFutureListener {
        private CloseListener() {
        }

        public void operationComplete(ChannelFuture channelFuture) throws InterruptedException {
            if (!channelFuture.isSuccess()) {
                LOG.error((Object)"Federated Worker Write failed");
                channelFuture.channel().writeAndFlush((Object)new FederatedResponse(FederatedResponse.ResponseType.ERROR, new FederatedWorkerHandlerException("Error while sending response."))).channel().close().sync();
            } else {
                PrivacyMonitor.clearCheckedConstraints();
                channelFuture.channel().close().sync();
            }
        }
    }
}

