/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.columns;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.matrix.data.Pair;

public class RaggedArray<T>
extends Array<T> {
    protected Array<T> _a;

    public RaggedArray(T[] a, int m) {
        super(m);
        this._a = ArrayFactory.create(a);
    }

    public RaggedArray(Array<T> a, int m) {
        super(m);
        this._a = a;
    }

    protected Array<T> getInnerArray() {
        return this._a;
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(ArrayFactory.FrameArrayType.RAGGED.ordinal());
        out.writeInt(this._size);
        out.writeInt(this._a.size());
        this._a.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        throw new DMLRuntimeException("Should not be called");
    }

    protected static RaggedArray<?> read(DataInput in, int nRow) throws IOException {
        int m = in.readInt();
        Array<?> a = ArrayFactory.read(in, in.readInt());
        return new RaggedArray(a, m);
    }

    @Override
    public T get(int index) {
        if (index > this._size || index < 0) {
            throw new ArrayIndexOutOfBoundsException("Index " + index + " out of bounds " + this._size);
        }
        return index < this._a._size ? (T)this._a.get(index) : null;
    }

    @Override
    public Object get() {
        throw new NotImplementedException("Should not be called");
    }

    @Override
    public double getAsDouble(int i) {
        return i < this._a._size ? this._a.getAsDouble(i) : 0.0;
    }

    @Override
    public double getAsNaNDouble(int i) {
        return i < this._a._size ? this._a.getAsNaNDouble(i) : Double.NaN;
    }

    @Override
    public void set(int index, T value) {
        if (index < this._a._size) {
            this._a.set(index, value);
        } else if (index < super.size()) {
            this._a.reset(index + 1);
            this._a.set(index, value);
            LOG.warn((Object)"Reallocated ragged array");
        }
    }

    @Override
    public void set(int index, double value) {
        if (index < this._a._size) {
            this._a.set(index, value);
        } else if (index < super.size()) {
            this._a.reset(index + 1);
            this._a.set(index, value);
            LOG.warn((Object)"Reallocated ragged array");
        }
    }

    @Override
    public void set(int index, String value) {
        if (index < this._a._size) {
            this._a.set(index, value);
        } else if (index < super.size()) {
            this._a.reset(index + 1);
            this._a.set(index, value);
            LOG.warn((Object)"Reallocated ragged array");
        }
    }

    @Override
    public void setFromOtherType(int rl, int ru, Array<?> value) {
        if (rl < 0 || rl >= this._a._size || ru >= this._a._size) {
            throw new NotImplementedException("Unimplemented method 'setFromOtherType'");
        }
        this._a.setFromOtherType(rl, ru, value);
    }

    @Override
    public void set(int rl, int ru, Array<T> value, int rlSrc) {
        if (rl >= 0 && rl < this._a._size && ru < this._a._size) {
            if (value instanceof RaggedArray) {
                this._a.set(rl, ru, ((RaggedArray)value).getInnerArray(), rlSrc);
            } else if (this._a.getClass() == value.getClass()) {
                this._a.set(rl, ru, value, rlSrc);
            } else {
                throw new DMLRuntimeException("RaggedArray set: value type should be same to RaggedArray type " + this._a.getClass());
            }
        }
    }

    @Override
    public void setNz(int rl, int ru, Array<T> value) {
        if (rl < 0 || rl >= this._a._size || ru >= this._a._size) {
            throw new NotImplementedException();
        }
        this._a.setNz(rl, ru, value);
    }

    @Override
    public void setFromOtherTypeNz(int rl, int ru, Array<?> value) {
        if (rl < 0 || rl >= this._a._size || ru >= this._a._size) {
            throw new NotImplementedException();
        }
        this._a.setFromOtherTypeNz(rl, ru, value);
    }

    @Override
    public void append(String value) {
        Object oldVals = this._a.clone();
        this._a.reset(super.size() + 1);
        this._a.set(0, ((Array)oldVals).size() - 1, (Array<T>)oldVals);
        this._a.set(super.size(), value);
        ++this._size;
        LOG.warn((Object)"Fully allocated ragged array");
    }

    @Override
    public void append(T value) {
        Object oldVals = this._a.clone();
        this._a.reset(super.size() + 1);
        this._a.set(0, ((Array)oldVals).size() - 1, (Array<T>)oldVals);
        this._a.set(super.size(), value);
        ++this._size;
        LOG.warn((Object)"Fully allocated ragged array");
    }

    @Override
    public Array<T> append(Array<T> other) {
        Object oldVals = this._a.clone();
        this._a.reset(super.size() + other._size + 1);
        this._a.set(0, ((Array)oldVals).size() - 1, (Array<T>)oldVals);
        this._a.set(super.size(), super.size() + other.size() - 1, other);
        this._size += other.size();
        LOG.warn((Object)"Fully allocated ragged array");
        return this;
    }

    @Override
    public Array<T> slice(int rl, int ru) {
        if (rl >= 0 && rl < this._a._size && ru < this._a._size) {
            return this._a.slice(rl, ru);
        }
        if (rl >= 0 && ru >= this._a._size) {
            return this._a.slice(rl, this._a._size - 1);
        }
        return null;
    }

    @Override
    public void reset(int size) {
        this._a.reset(size);
        this._size = size;
    }

    @Override
    public byte[] getAsByteArray() {
        throw new NotImplementedException("Unimplemented method 'getAsByteArray'");
    }

    @Override
    public Types.ValueType getValueType() {
        return this._a.getValueType();
    }

    @Override
    public Pair<Types.ValueType, Boolean> analyzeValueType(int maxCells) {
        return this._a.analyzeValueType(maxCells);
    }

    @Override
    public ArrayFactory.FrameArrayType getFrameArrayType() {
        return ArrayFactory.FrameArrayType.RAGGED;
    }

    @Override
    public long getExactSerializedSize() {
        return this._a.getExactSerializedSize() + 8L + 1L;
    }

    @Override
    protected Array<Boolean> changeTypeBitSet(Array<Boolean> ret, int l, int u) {
        return this._a.changeTypeBitSet(ret, l, u);
    }

    @Override
    protected Array<Boolean> changeTypeBoolean(Array<Boolean> retA, int l, int u) {
        return this._a.changeTypeBoolean(retA, l, u);
    }

    @Override
    protected Array<Double> changeTypeDouble(Array<Double> retA, int l, int u) {
        return this._a.changeTypeDouble(retA, l, u);
    }

    @Override
    protected Array<Float> changeTypeFloat(Array<Float> retA, int l, int u) {
        return this._a.changeTypeFloat(retA, l, u);
    }

    @Override
    protected Array<Integer> changeTypeInteger(Array<Integer> retA, int l, int u) {
        return this._a.changeTypeInteger(retA, l, u);
    }

    @Override
    protected Array<Long> changeTypeLong(Array<Long> retA, int l, int u) {
        return this._a.changeTypeLong(retA, l, u);
    }

    @Override
    protected Array<Object> changeTypeHash64(Array<Object> retA, int l, int u) {
        return this._a.changeTypeHash64(retA, l, u);
    }

    @Override
    protected Array<Object> changeTypeHash32(Array<Object> retA, int l, int u) {
        return this._a.changeTypeHash32(retA, l, u);
    }

    @Override
    protected Array<String> changeTypeString(Array<String> retA, int l, int u) {
        return this._a.changeTypeString(retA, l, u);
    }

    @Override
    protected Array<Character> changeTypeCharacter(Array<Character> retA, int l, int u) {
        return this._a.changeTypeCharacter(retA, l, u);
    }

    @Override
    public Array<?> changeTypeWithNulls(Types.ValueType t) {
        throw new NotImplementedException("Not Implemented ragged array with nulls");
    }

    @Override
    public void fill(String val) {
        this._a.reset(super.size());
        this._a.fill(val);
    }

    @Override
    public void fill(T val) {
        this._a.reset(super.size());
        this._a.fill(val);
    }

    @Override
    public boolean isShallowSerialize() {
        return this._a.isShallowSerialize();
    }

    @Override
    public boolean isEmpty() {
        return this._a.isEmpty();
    }

    @Override
    public Array<T> select(int[] indices) {
        Array<?> ret = this._a.getFrameArrayType() == ArrayFactory.FrameArrayType.OPTIONAL ? ArrayFactory.allocateOptional(this._a.getValueType(), indices.length) : ArrayFactory.allocate(this._a.getValueType(), indices.length);
        for (int i = 0; i < indices.length; ++i) {
            ret.set(i, this.get(indices[i]));
        }
        return ret;
    }

    @Override
    public Array<T> select(boolean[] select, int nTrue) {
        int i;
        Array<?> ret = this._a.getFrameArrayType() == ArrayFactory.FrameArrayType.OPTIONAL ? ArrayFactory.allocateOptional(this._a.getValueType(), nTrue) : ArrayFactory.allocate(this._a.getValueType(), nTrue);
        int k = 0;
        for (i = 0; i < this._a.size(); ++i) {
            if (!select[i]) continue;
            ret.set(k++, this._a.get(i));
        }
        for (i = this._a.size(); i < select.length; ++i) {
            if (!select[i]) continue;
            ret.set(k++, this.get(i));
        }
        return ret;
    }

    @Override
    public boolean isNotEmpty(int i) {
        return i < this._a.size() && this._a.isNotEmpty(i);
    }

    @Override
    public Array<T> clone() {
        return new RaggedArray<T>(this._a.clone(), this._size);
    }

    @Override
    public double hashDouble(int idx) {
        return idx < this._a.size() ? this._a.hashDouble(idx) : Double.NaN;
    }

    @Override
    public boolean equals(Array<T> other) {
        if (other._size == this._size && other.getValueType() == this.getValueType() && other instanceof RaggedArray) {
            if (other == this) {
                return true;
            }
            RaggedArray ot = (RaggedArray)other;
            return ot._a.equals(this._a);
        }
        return false;
    }

    @Override
    public long getInMemorySize() {
        return RaggedArray.baseMemoryCost() + this._a.getInMemorySize() + 8L;
    }

    @Override
    public boolean containsNull() {
        return this._a.size() < this._size || this._a.containsNull();
    }

    @Override
    public boolean possiblyContainsNaN() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this._size + 2);
        sb.append(super.toString()).append(Opcodes.LESS.toString());
        sb.append(this._a.getClass().getSimpleName()).append(">:[");
        for (int i = 0; i < this._size - 1; ++i) {
            sb.append(this.get(i)).append(",");
        }
        sb.append(this.get(this._size - 1));
        sb.append("]");
        return sb.toString();
    }
}

