/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.jmx.framework;

import java.io.IOException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.SimpleType;
import org.osgi.jmx.Item;
import org.osgi.jmx.JmxConstants;

public interface FrameworkMBean {
    public static final String OBJECTNAME = "osgi.core:type=framework,version=1.7";
    public static final String SUCCESS = "Success";
    public static final Item SUCCESS_ITEM = new Item("Success", "Whether the operation was successful", SimpleType.BOOLEAN, new String[0]);
    public static final String ERROR = "Error";
    public static final Item ERROR_ITEM = new Item("Error", "The error message if unsuccessful", SimpleType.STRING, new String[0]);
    public static final String COMPLETED = "Completed";
    public static final Item COMPLETED_ITEM = new Item("Completed", "The bundle ids of the successfully completed installs", JmxConstants.LONG_ARRAY_TYPE, new String[0]);
    public static final String BUNDLE_IN_ERROR = "BundleInError";
    public static final Item BUNDLE_IN_ERROR_ID_ITEM = new Item("BundleInError", "The id of the bundle causing the error", SimpleType.LONG, new String[0]);
    public static final String REMAINING = "Remaining";
    public static final Item REMAINING_ID_ITEM = new Item("Remaining", "The ids of the remaining bundles", JmxConstants.LONG_ARRAY_TYPE, new String[0]);
    public static final CompositeType BATCH_ACTION_RESULT_TYPE = Item.compositeType("BUNDLE_ACTION_RESULT", "This type encapsulates a bundle batch install action result", BUNDLE_IN_ERROR_ID_ITEM, COMPLETED_ITEM, ERROR_ITEM, REMAINING_ID_ITEM, SUCCESS_ITEM);
    public static final Item BUNDLE_IN_ERROR_LOCATION_ITEM = new Item("BundleInError", "The location of the bundle causing the error", SimpleType.STRING, new String[0]);
    public static final Item REMAINING_LOCATION_ITEM = new Item("Remaining", "The locations of the remaining bundles", JmxConstants.STRING_ARRAY_TYPE, new String[0]);
    public static final CompositeType BATCH_INSTALL_RESULT_TYPE = Item.compositeType("BATCH_INSTALL_RESULT", "This type encapsulates a bundle batch install action result", BUNDLE_IN_ERROR_LOCATION_ITEM, COMPLETED_ITEM, ERROR_ITEM, REMAINING_LOCATION_ITEM, SUCCESS_ITEM);
    public static final CompositeType BATCH_RESOLVE_RESULT_TYPE = Item.compositeType("BATCH_RESOLVE_RESULT", "This type encapsulates a bundle batch resolve action result", COMPLETED_ITEM, SUCCESS_ITEM);

    public long[] getDependencyClosure(long[] var1) throws IOException;

    public int getFrameworkStartLevel() throws IOException;

    public int getInitialBundleStartLevel() throws IOException;

    public String getProperty(String var1);

    public long[] getRemovalPendingBundles() throws IOException;

    public long installBundle(String var1) throws IOException;

    public long installBundleFromURL(String var1, String var2) throws IOException;

    public CompositeData installBundles(String[] var1) throws IOException;

    public CompositeData installBundlesFromURL(String[] var1, String[] var2) throws IOException;

    public void refreshBundle(long var1) throws IOException;

    public boolean refreshBundleAndWait(long var1) throws IOException;

    public void refreshBundles(long[] var1) throws IOException;

    public CompositeData refreshBundlesAndWait(long[] var1) throws IOException;

    public boolean resolveBundle(long var1) throws IOException;

    public boolean resolveBundles(long[] var1) throws IOException;

    public CompositeData resolve(long[] var1) throws IOException;

    public void restartFramework() throws IOException;

    public void setBundleStartLevel(long var1, int var3) throws IOException;

    public CompositeData setBundleStartLevels(long[] var1, int[] var2) throws IOException;

    public void setFrameworkStartLevel(int var1) throws IOException;

    public void setInitialBundleStartLevel(int var1) throws IOException;

    public void shutdownFramework() throws IOException;

    public void startBundle(long var1) throws IOException;

    public CompositeData startBundles(long[] var1) throws IOException;

    public void stopBundle(long var1) throws IOException;

    public CompositeData stopBundles(long[] var1) throws IOException;

    public void uninstallBundle(long var1) throws IOException;

    public CompositeData uninstallBundles(long[] var1) throws IOException;

    public void updateBundle(long var1) throws IOException;

    public void updateBundleFromURL(long var1, String var3) throws IOException;

    public CompositeData updateBundles(long[] var1) throws IOException;

    public CompositeData updateBundlesFromURL(long[] var1, String[] var2) throws IOException;

    public void updateFramework() throws IOException;
}

