/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.aries.subsystem.core.archive.Attribute;
import org.apache.aries.subsystem.core.archive.Directive;
import org.apache.aries.subsystem.core.archive.Parameter;
import org.apache.aries.subsystem.core.internal.AbstractCapability;
import org.osgi.resource.Resource;

public class ExportPackageCapability
extends AbstractCapability {
    public static final String NAMESPACE = "osgi.wiring.package";
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Map<String, String> directives = new HashMap<String, String>();
    private final Resource resource;

    public ExportPackageCapability(String packageName, Collection<Parameter> parameters, Resource resource) {
        this.attributes.put(NAMESPACE, packageName);
        for (Parameter parameter : parameters) {
            if (parameter instanceof Attribute) {
                this.attributes.put(parameter.getName(), parameter.getValue());
                continue;
            }
            this.directives.put(parameter.getName(), ((Directive)parameter).getValue());
        }
        this.resource = resource;
    }

    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public Map<String, String> getDirectives() {
        return Collections.unmodifiableMap(this.directives);
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public Resource getResource() {
        return this.resource;
    }
}

