/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.subsystem.core.archive.Attribute;
import org.apache.aries.subsystem.core.archive.Directive;
import org.apache.aries.subsystem.core.archive.Header;
import org.apache.aries.subsystem.core.archive.Parameter;
import org.apache.aries.subsystem.core.archive.ParameterFactory;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;

public class SubsystemExportServiceHeader
implements Header<Clause> {
    public static final String NAME = "Subsystem-ExportService";
    private static final Pattern PATTERN = Pattern.compile("(\\p{javaJavaIdentifierStart}(?:\\p{javaJavaIdentifierPart})*(?:\\.\\p{javaJavaIdentifierStart}(?:\\p{javaJavaIdentifierPart})*)*(?:;\\s*(?:(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+:=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\"))|(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\"))))*)(?=,|\\z)");
    private final Set<Clause> clauses = new HashSet<Clause>();

    public SubsystemExportServiceHeader(String value) {
        Matcher matcher = PATTERN.matcher(value);
        while (matcher.find()) {
            this.clauses.add(new Clause(matcher.group()));
        }
        if (this.clauses.isEmpty()) {
            throw new IllegalArgumentException("A Subsystem-ExportService header must have at least one clause");
        }
    }

    @Override
    public Collection<Clause> getClauses() {
        return Collections.unmodifiableSet(this.clauses);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    public List<Capability> toCapabilities(Resource resource) throws InvalidSyntaxException {
        ArrayList<Capability> result = new ArrayList<Capability>();
        for (Clause clause : this.clauses) {
            result.addAll(clause.toCapabilities(resource));
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Clause clause : this.getClauses()) {
            builder.append(clause).append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public static class Clause
    implements org.apache.aries.subsystem.core.archive.Clause {
        public static final String DIRECTIVE_FILTER = "filter";
        private static final Pattern PATTERN_OBJECTCLASS = Pattern.compile("(\\p{javaJavaIdentifierStart}(?:\\p{javaJavaIdentifierPart})*(?:\\.\\p{javaJavaIdentifierStart}(?:\\p{javaJavaIdentifierPart})*)*)(?=;|\\z)");
        private static final Pattern PATTERN_PARAMETER = Pattern.compile("((?:(?:[0-9]|[A-Za-z]|_|-|\\.)+:=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\"))|(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\")))(?=;|\\z)");
        private final String path;
        private final Map<String, Parameter> parameters = new HashMap<String, Parameter>();

        private static void fillInDefaults(Map<String, Parameter> parameters) {
        }

        public Clause(String clause) {
            Matcher main = PATTERN_OBJECTCLASS.matcher(clause);
            if (!main.find()) {
                throw new IllegalArgumentException("Missing objectClass path: " + clause);
            }
            this.path = main.group();
            main.usePattern(PATTERN_PARAMETER);
            while (main.find()) {
                Parameter parameter = ParameterFactory.create(main.group());
                this.parameters.put(parameter.getName(), parameter);
            }
            Clause.fillInDefaults(this.parameters);
        }

        @Override
        public Attribute getAttribute(String name) {
            Parameter result = this.parameters.get(name);
            if (result instanceof Attribute) {
                return (Attribute)result;
            }
            return null;
        }

        @Override
        public Collection<Attribute> getAttributes() {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.parameters.size());
            for (Parameter parameter : this.parameters.values()) {
                if (!(parameter instanceof Attribute)) continue;
                attributes.add((Attribute)parameter);
            }
            attributes.trimToSize();
            return attributes;
        }

        @Override
        public Directive getDirective(String name) {
            Parameter result = this.parameters.get(name);
            if (result instanceof Directive) {
                return (Directive)result;
            }
            return null;
        }

        @Override
        public Collection<Directive> getDirectives() {
            ArrayList<Directive> directives = new ArrayList<Directive>(this.parameters.size());
            for (Parameter parameter : this.parameters.values()) {
                if (!(parameter instanceof Directive)) continue;
                directives.add((Directive)parameter);
            }
            directives.trimToSize();
            return directives;
        }

        public String getObjectClass() {
            return this.path;
        }

        @Override
        public Parameter getParameter(String name) {
            return this.parameters.get(name);
        }

        @Override
        public Collection<Parameter> getParameters() {
            return Collections.unmodifiableCollection(this.parameters.values());
        }

        @Override
        public String getPath() {
            return this.path;
        }

        public List<Capability> toCapabilities(Resource resource) throws InvalidSyntaxException {
            List capabilities = resource.getCapabilities("osgi.service");
            if (capabilities.isEmpty()) {
                return capabilities;
            }
            Filter filter = this.computeFilter();
            ArrayList<Capability> result = new ArrayList<Capability>(capabilities.size());
            for (Capability capability : capabilities) {
                if (!filter.matches(capability.getAttributes())) continue;
                result.add(capability);
            }
            result.trimToSize();
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder().append(this.getPath());
            for (Parameter parameter : this.getParameters()) {
                builder.append(';').append(parameter);
            }
            return builder.toString();
        }

        private Filter computeFilter() throws InvalidSyntaxException {
            return FrameworkUtil.createFilter((String)this.computeFilterString());
        }

        private String computeFilterString() {
            Directive directive = this.getDirective(DIRECTIVE_FILTER);
            return "(&(" + "objectClass" + '=' + this.path + ')' + (directive == null ? "" : directive.getValue()) + ')';
        }
    }
}

