/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.rewriter.base;

import java.util.Properties;

public class PhysicalOptimizationConfig {
    private static final int MB = 0x100000;
    private static final String FRAMESIZE = "FRAMESIZE";
    private static final String MAX_FRAMES_EXTERNAL_SORT = "MAX_FRAMES_EXTERNAL_SORT";
    private static final String MAX_FRAMES_EXTERNAL_GROUP_BY = "MAX_FRAMES_EXTERNAL_GROUP_BY";
    private static final String MAX_FRAMES_FOR_JOIN_LEFT_INPUT = "MAX_FRAMES_FOR_JOIN_LEFT_INPUT";
    private static final String MAX_FRAMES_FOR_JOIN = "MAX_FRAMES_FOR_JOIN";
    private static final String MAX_FRAMES_FOR_WINDOW = "MAX_FRAMES_FOR_WINDOW";
    private static final String MAX_FRAMES_FOR_TEXTSEARCH = "MAX_FRAMES_FOR_TEXTSEARCH";
    private static final String FUDGE_FACTOR = "FUDGE_FACTOR";
    private static final String MAX_RECORDS_PER_FRAME = "MAX_RECORDS_PER_FRAME";
    private static final String DEFAULT_HASH_GROUP_TABLE_SIZE = "DEFAULT_HASH_GROUP_TABLE_SIZE";
    private static final String DEFAULT_EXTERNAL_GROUP_TABLE_SIZE = "DEFAULT_EXTERNAL_GROUP_TABLE_SIZE";
    private static final String DEFAULT_IN_MEM_HASH_JOIN_TABLE_SIZE = "DEFAULT_IN_MEM_HASH_JOIN_TABLE_SIZE";
    private static final String SORT_PARALLEL = "SORT_PARALLEL";
    private static final String SORT_SAMPLES = "SORT_SAMPLES";
    private static final String INDEX_ONLY = "INDEX_ONLY";
    private static final String SANITY_CHECK = "SANITY_CHECK";
    private Properties properties = new Properties();

    public PhysicalOptimizationConfig() {
        int frameSize = 32768;
        this.setInt(FRAMESIZE, frameSize);
        this.setInt(MAX_FRAMES_EXTERNAL_SORT, (int)(0x2000000L / (long)frameSize));
        this.setInt(MAX_FRAMES_EXTERNAL_GROUP_BY, (int)(0x2000000L / (long)frameSize));
        this.setInt(DEFAULT_HASH_GROUP_TABLE_SIZE, 0xA00007);
        this.setInt(DEFAULT_EXTERNAL_GROUP_TABLE_SIZE, 0xA00007);
        this.setInt(DEFAULT_IN_MEM_HASH_JOIN_TABLE_SIZE, 0xA00007);
    }

    public int getFrameSize() {
        return this.getInt(FRAMESIZE, 32768);
    }

    public void setFrameSize(int frameSize) {
        this.setInt(FRAMESIZE, frameSize);
    }

    public double getFudgeFactor() {
        return this.getDouble(FUDGE_FACTOR, 1.3);
    }

    public void setFudgeFactor(double fudgeFactor) {
        this.setDouble(FUDGE_FACTOR, fudgeFactor);
    }

    public int getMaxRecordsPerFrame() {
        return this.getInt(MAX_RECORDS_PER_FRAME, 512);
    }

    public void setMaxRecordsPerFrame(int maxRecords) {
        this.setInt(MAX_RECORDS_PER_FRAME, maxRecords);
    }

    public int getMaxFramesForJoinLeftInput() {
        int frameSize = this.getFrameSize();
        return this.getInt(MAX_FRAMES_FOR_JOIN_LEFT_INPUT, (int)(0x2300000000L / (long)frameSize));
    }

    public void setMaxFramesForJoinLeftInput(int frameLimit) {
        this.setInt(MAX_FRAMES_FOR_JOIN_LEFT_INPUT, frameLimit);
    }

    public int getMaxFramesForJoin() {
        int frameSize = this.getFrameSize();
        return this.getInt(MAX_FRAMES_FOR_JOIN, (int)(0x4000000L / (long)frameSize));
    }

    public void setMaxFramesForJoin(int frameLimit) {
        this.setInt(MAX_FRAMES_FOR_JOIN, frameLimit);
    }

    public int getMaxFramesForGroupBy() {
        int frameSize = this.getFrameSize();
        return this.getInt(MAX_FRAMES_EXTERNAL_GROUP_BY, (int)(0x10000000L / (long)frameSize));
    }

    public void setMaxFramesExternalGroupBy(int frameLimit) {
        this.setInt(MAX_FRAMES_EXTERNAL_GROUP_BY, frameLimit);
    }

    public int getMaxFramesExternalSort() {
        int frameSize = this.getFrameSize();
        return this.getInt(MAX_FRAMES_EXTERNAL_SORT, (int)(0x2000000L / (long)frameSize));
    }

    public void setMaxFramesExternalSort(int frameLimit) {
        this.setInt(MAX_FRAMES_EXTERNAL_SORT, frameLimit);
    }

    public int getMaxFramesForWindow() {
        int frameSize = this.getFrameSize();
        return this.getInt(MAX_FRAMES_FOR_WINDOW, (int)(0x400000L / (long)frameSize));
    }

    public void setMaxFramesForWindow(int frameLimit) {
        this.setInt(MAX_FRAMES_FOR_WINDOW, frameLimit);
    }

    public int getMaxFramesForTextSearch() {
        int frameSize = this.getFrameSize();
        return this.getInt(MAX_FRAMES_FOR_TEXTSEARCH, (int)(0x2000000L / (long)frameSize));
    }

    public void setMaxFramesForTextSearch(int frameLimit) {
        this.setInt(MAX_FRAMES_FOR_TEXTSEARCH, frameLimit);
    }

    public int getHashGroupByTableSize() {
        return this.getInt(DEFAULT_HASH_GROUP_TABLE_SIZE, 0xA00007);
    }

    public void setHashGroupByTableSize(int tableSize) {
        this.setInt(DEFAULT_HASH_GROUP_TABLE_SIZE, tableSize);
    }

    public int getExternalGroupByTableSize() {
        return this.getInt(DEFAULT_EXTERNAL_GROUP_TABLE_SIZE, 0xA00007);
    }

    public void setExternalGroupByTableSize(int tableSize) {
        this.setInt(DEFAULT_EXTERNAL_GROUP_TABLE_SIZE, tableSize);
    }

    public int getInMemHashJoinTableSize() {
        return this.getInt(DEFAULT_IN_MEM_HASH_JOIN_TABLE_SIZE, 0xA00007);
    }

    public void setInMemHashJoinTableSize(int tableSize) {
        this.setInt(DEFAULT_IN_MEM_HASH_JOIN_TABLE_SIZE, tableSize);
    }

    public boolean getSortParallel() {
        return this.getBoolean(SORT_PARALLEL, true);
    }

    public void setSortParallel(boolean sortParallel) {
        this.setBoolean(SORT_PARALLEL, sortParallel);
    }

    public int getSortSamples() {
        return this.getInt(SORT_SAMPLES, 100);
    }

    public void setSortSamples(int sortSamples) {
        this.setInt(SORT_SAMPLES, sortSamples);
    }

    public void setIndexOnly(boolean indexOnly) {
        this.setBoolean(INDEX_ONLY, indexOnly);
    }

    public boolean isIndexOnly() {
        return this.getBoolean(INDEX_ONLY, true);
    }

    public void setSanityCheckEnabled(boolean sanityCheck) {
        this.setBoolean(SANITY_CHECK, sanityCheck);
    }

    public boolean isSanityCheckEnabled() {
        return this.getBoolean(SANITY_CHECK, false);
    }

    private void setInt(String property, int value) {
        this.properties.setProperty(property, Integer.toString(value));
    }

    private int getInt(String property, int defaultValue) {
        String value = this.properties.getProperty(property);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    private void setDouble(String property, double value) {
        this.properties.setProperty(property, Double.toString(value));
    }

    private double getDouble(String property, double defaultValue) {
        String value = this.properties.getProperty(property);
        return value == null ? defaultValue : Double.parseDouble(value);
    }

    private void setBoolean(String property, boolean value) {
        this.properties.setProperty(property, Boolean.toString(value));
    }

    private boolean getBoolean(String property, boolean defaultValue) {
        String value = this.properties.getProperty(property);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }
}

