/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.rewriter.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.EnforceFrameWriter;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.TimedOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.api.rewriter.runtime.SuperActivity;
import org.apache.hyracks.api.util.ExceptionUtils;

public class SuperActivityOperatorNodePushable
implements IOperatorNodePushable {
    private final Map<ActivityId, IOperatorNodePushable> operatorNodePushables = new HashMap<ActivityId, IOperatorNodePushable>();
    private final List<IOperatorNodePushable> operatorNodePushablesBFSOrder = new ArrayList<IOperatorNodePushable>();
    private final Map<ActivityId, IActivity> startActivities;
    private final SuperActivity parent;
    private final IHyracksTaskContext ctx;
    private final IRecordDescriptorProvider recordDescProvider;
    private final int partition;
    private final int nPartitions;
    private int inputArity = 0;

    public SuperActivityOperatorNodePushable(SuperActivity parent, Map<ActivityId, IActivity> startActivities, IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        this.parent = parent;
        this.startActivities = startActivities;
        this.ctx = ctx;
        this.recordDescProvider = recordDescProvider;
        this.partition = partition;
        this.nPartitions = nPartitions;
        try {
            this.init();
        }
        catch (Exception e) {
            throw HyracksDataException.create(e);
        }
    }

    @Override
    public void initialize() throws HyracksDataException {
        this.runInParallel(IOperatorNodePushable::initialize);
    }

    @Override
    public void deinitialize() throws HyracksDataException {
        this.runInParallel(IOperatorNodePushable::deinitialize);
    }

    private void init() throws HyracksDataException {
        List outputConnectors;
        LinkedList<Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>>> childQueue = new LinkedList<Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>>>();
        boolean enforce = this.ctx.getJobFlags().contains((Object)JobFlag.ENFORCE_CONTRACT);
        boolean profile = this.ctx.getJobFlags().contains((Object)JobFlag.PROFILE_RUNTIME);
        HashSet sources = new HashSet();
        for (Map.Entry<ActivityId, IActivity> entry : this.startActivities.entrySet()) {
            IOperatorNodePushable opPushable = null;
            opPushable = profile ? TimedOperatorNodePushable.time(entry.getValue().createPushRuntime(this.ctx, this.recordDescProvider, this.partition, this.nPartitions), this.ctx) : entry.getValue().createPushRuntime(this.ctx, this.recordDescProvider, this.partition, this.nPartitions);
            this.operatorNodePushablesBFSOrder.add(opPushable);
            this.operatorNodePushables.put(entry.getKey(), opPushable);
            this.inputArity += opPushable.getInputArity();
            outputConnectors = (List)MapUtils.getObject(this.parent.getActivityOutputMap(), (Object)entry.getKey(), Collections.emptyList());
            for (IConnectorDescriptor conn : outputConnectors) {
                childQueue.add(this.parent.getConnectorActivityMap().get(conn.getConnectorId()));
                sources.add(childQueue.peekLast());
            }
        }
        while (!childQueue.isEmpty()) {
            Pair channel = (Pair)childQueue.poll();
            ActivityId sourceId = ((IActivity)((Pair)channel.getLeft()).getLeft()).getActivityId();
            int outputChannel = (Integer)((Pair)channel.getLeft()).getRight();
            ActivityId destId = ((IActivity)((Pair)channel.getRight()).getLeft()).getActivityId();
            int inputChannel = (Integer)((Pair)channel.getRight()).getRight();
            IOperatorNodePushable sourceOp = this.operatorNodePushables.get(sourceId);
            IOperatorNodePushable destOp = this.operatorNodePushables.get(destId);
            if (destOp == null) {
                destOp = profile ? TimedOperatorNodePushable.time(((IActivity)((Pair)channel.getRight()).getLeft()).createPushRuntime(this.ctx, this.recordDescProvider, this.partition, this.nPartitions), this.ctx) : ((IActivity)((Pair)channel.getRight()).getLeft()).createPushRuntime(this.ctx, this.recordDescProvider, this.partition, this.nPartitions);
                this.operatorNodePushablesBFSOrder.add(destOp);
                this.operatorNodePushables.put(destId, destOp);
            }
            IFrameWriter writer = destOp.getInputFrameWriter(inputChannel);
            writer = enforce && !profile ? EnforceFrameWriter.enforce(writer) : writer;
            sourceOp.setOutputFrameWriter(outputChannel, writer, this.recordDescProvider.getInputRecordDescriptor(destId, inputChannel));
            outputConnectors = (List)MapUtils.getObject(this.parent.getActivityOutputMap(), (Object)destId, Collections.emptyList());
            for (IConnectorDescriptor conn : outputConnectors) {
                if (conn == null) continue;
                childQueue.add(this.parent.getConnectorActivityMap().get(conn.getConnectorId()));
            }
        }
    }

    @Override
    public int getInputArity() {
        return this.inputArity;
    }

    @Override
    public void setOutputFrameWriter(int clusterOutputIndex, IFrameWriter writer, RecordDescriptor recordDesc) throws HyracksDataException {
        Pair<ActivityId, Integer> activityIdOutputIndex = this.parent.getActivityIdOutputIndex(clusterOutputIndex);
        IOperatorNodePushable opPushable = this.operatorNodePushables.get(activityIdOutputIndex.getLeft());
        opPushable.setOutputFrameWriter((Integer)activityIdOutputIndex.getRight(), writer, recordDesc);
    }

    @Override
    public IFrameWriter getInputFrameWriter(int index) {
        Pair<ActivityId, Integer> activityIdInputIndex = this.parent.getActivityIdInputIndex(index);
        IOperatorNodePushable operatorNodePushable = this.operatorNodePushables.get(activityIdInputIndex.getLeft());
        return operatorNodePushable.getInputFrameWriter((Integer)activityIdInputIndex.getRight());
    }

    @Override
    public String getDisplayName() {
        return "Super Activity " + this.parent.getActivityMap().values().toString();
    }

    private void runInParallel(OperatorNodePushableAction action) throws HyracksDataException {
        ArrayList<Future<Void>> tasks = new ArrayList<Future<Void>>(this.operatorNodePushablesBFSOrder.size());
        ArrayBlockingQueue failures = new ArrayBlockingQueue(this.operatorNodePushablesBFSOrder.size());
        Semaphore startSemaphore = new Semaphore(1 - this.operatorNodePushablesBFSOrder.size());
        Semaphore completeSemaphore = new Semaphore(1 - this.operatorNodePushablesBFSOrder.size());
        Throwable root = null;
        try {
            for (IOperatorNodePushable iOperatorNodePushable : this.operatorNodePushablesBFSOrder) {
                tasks.add(this.ctx.getExecutorService().submit(() -> {
                    startSemaphore.release();
                    try {
                        Thread.currentThread().setName(Thread.currentThread().getName() + ":" + this.ctx.getJobletContext().getJobId() + ":" + this.ctx.getTaskAttemptId() + ":" + SuperActivityOperatorNodePushable.class.getSimpleName());
                        action.run(op);
                    }
                    catch (Throwable th) {
                        failures.offer(th);
                        throw th;
                    }
                    finally {
                        this.ctx.unsubscribeThreadFromStats();
                        completeSemaphore.release();
                    }
                    return null;
                }));
            }
            for (Future future : tasks) {
                future.get();
            }
        }
        catch (ExecutionException e) {
            root = e.getCause();
        }
        catch (Throwable e) {
            root = e;
        }
        if (root != null) {
            Throwable failure = root;
            this.cancelTasks(tasks, startSemaphore, completeSemaphore);
            failures.forEach(t -> ExceptionUtils.suppress(failure, t));
            throw HyracksDataException.create(failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTasks(List<Future<Void>> tasks, Semaphore startSemaphore, Semaphore completeSemaphore) {
        try {
            startSemaphore.acquireUninterruptibly();
            for (Future<Void> task : tasks) {
                task.cancel(true);
            }
        }
        finally {
            completeSemaphore.acquireUninterruptibly();
        }
    }

    @FunctionalInterface
    static interface OperatorNodePushableAction {
        public void run(IOperatorNodePushable var1) throws HyracksDataException;
    }
}

