/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.tuples;

import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.tuples.BTreeTypeAwareTupleWriter;
import org.apache.hyracks.storage.am.common.util.BitOperationUtils;
import org.apache.hyracks.storage.am.lsm.btree.tuples.LSMBTreeTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMTreeTupleWriter;

public class LSMBTreeTupleWriter
extends BTreeTypeAwareTupleWriter
implements ILSMTreeTupleWriter {
    private boolean isAntimatter;
    private final int numKeyFields;

    public LSMBTreeTupleWriter(ITypeTraits[] typeTraits, int numKeyFields, boolean isAntimatter, boolean updateAware) {
        super(typeTraits, updateAware);
        this.numKeyFields = numKeyFields;
        this.isAntimatter = isAntimatter;
    }

    public int bytesRequired(ITupleReference tuple) {
        if (this.isAntimatter) {
            return super.bytesRequired(tuple, 0, this.numKeyFields);
        }
        return super.bytesRequired(tuple);
    }

    public int getCopySpaceRequired(ITupleReference tuple) {
        return super.bytesRequired(tuple);
    }

    public LSMBTreeTupleReference createTupleReference() {
        return new LSMBTreeTupleReference(this.typeTraits, this.numKeyFields, this.updateAware);
    }

    protected int getNullFlagsBytes(int numFields) {
        int numBits = numFields + 1;
        if (this.updateAware) {
            ++numBits;
        }
        return BitOperationUtils.getFlagBytes((int)numBits);
    }

    protected int getNullFlagsBytes(ITupleReference tuple) {
        int numBits = tuple.getFieldCount() + 1;
        if (this.updateAware) {
            ++numBits;
        }
        return BitOperationUtils.getFlagBytes((int)numBits);
    }

    public int writeTuple(ITupleReference tuple, byte[] targetBuf, int targetOff) {
        int bytesWritten = -1;
        if (this.isAntimatter) {
            bytesWritten = super.writeTupleFields(tuple, 0, this.numKeyFields, targetBuf, targetOff);
            BitOperationUtils.setBit((byte[])targetBuf, (int)targetOff, (byte)7);
        } else {
            bytesWritten = super.writeTuple(tuple, targetBuf, targetOff);
        }
        if (this.updateAware && this.isUpdated) {
            BitOperationUtils.setBit((byte[])targetBuf, (int)targetOff, (byte)6);
        }
        return bytesWritten;
    }

    public void setAntimatter(boolean isDelete) {
        this.isAntimatter = isDelete;
    }
}

