/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.utils;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.util.ByteBufferInputStream;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class FrameDebugUtils {
    private FrameDebugUtils() {
    }

    public static void prettyPrint(IFrameTupleAccessor fta, RecordDescriptor recordDescriptor, String prefix) {
        try (ByteBufferInputStream bbis = new ByteBufferInputStream();
             DataInputStream dis = new DataInputStream(bbis);){
            int tc = fta.getTupleCount();
            StringBuilder sb = new StringBuilder();
            sb.append(prefix).append("TC: " + tc).append("\n");
            for (int i = 0; i < tc; ++i) {
                FrameDebugUtils.prettyPrint(fta, recordDescriptor, i, bbis, dis, sb);
            }
            System.err.println(sb.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void prettyPrint(IFrameTupleAccessor fta, RecordDescriptor recordDescriptor) {
        FrameDebugUtils.prettyPrint(fta, recordDescriptor, "");
    }

    public static void prettyPrintTags(IFrameTupleAccessor fta, String operator) {
        try (ByteBufferInputStream bbis = new ByteBufferInputStream();
             DataInputStream dis = new DataInputStream(bbis);){
            int tc = fta.getTupleCount();
            StringBuilder sb = new StringBuilder();
            sb.append(operator + ":");
            sb.append("TC: " + tc).append("\n");
            for (int i = 0; i < tc; ++i) {
                FrameDebugUtils.prettyPrintTag(fta, i, bbis, dis, sb);
            }
            System.err.println(sb.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static void prettyPrintTag(IFrameTupleAccessor fta, int tid, ByteBufferInputStream bbis, DataInputStream dis, StringBuilder sb) {
        sb.append(" tid" + tid + ":(" + fta.getTupleStartOffset(tid) + ", " + fta.getTupleEndOffset(tid) + ")[");
        for (int j = 0; j < fta.getFieldCount(); ++j) {
            sb.append(" ");
            if (j > 0) {
                sb.append("|");
            }
            sb.append("f" + j + ":(" + fta.getFieldStartOffset(tid, j) + ", " + fta.getFieldEndOffset(tid, j) + ") ");
            sb.append("{");
            sb.append(Byte.toString(fta.getBuffer().array()[fta.getTupleStartOffset(tid) + fta.getFieldSlotsLength() + fta.getFieldStartOffset(tid, j)]));
            sb.append("}");
        }
        sb.append("\n");
    }

    protected static void prettyPrint(IFrameTupleAccessor fta, RecordDescriptor recordDescriptor, int tid, ByteBufferInputStream bbis, DataInputStream dis, StringBuilder sb) {
        sb.append(" tid" + tid + ":(" + fta.getTupleStartOffset(tid) + ", " + fta.getTupleEndOffset(tid) + ")[");
        for (int j = 0; j < fta.getFieldCount(); ++j) {
            sb.append(" ");
            if (j > 0) {
                sb.append("|");
            }
            sb.append("f" + j + ":(" + fta.getFieldStartOffset(tid, j) + ", " + fta.getFieldEndOffset(tid, j) + ") ");
            sb.append("{");
            bbis.setByteBuffer(fta.getBuffer(), fta.getTupleStartOffset(tid) + fta.getFieldSlotsLength() + fta.getFieldStartOffset(tid, j));
            try {
                sb.append(recordDescriptor.getFields()[j].deserialize((DataInput)dis));
            }
            catch (Exception e) {
                e.printStackTrace();
                sb.append("Failed to deserialize field" + j);
            }
            sb.append("}");
        }
        sb.append("\n");
    }

    public static void prettyPrint(IFrameTupleAccessor fta, RecordDescriptor recordDescriptor, int tid) {
        try (ByteBufferInputStream bbis = new ByteBufferInputStream();
             DataInputStream dis = new DataInputStream(bbis);){
            StringBuilder sb = new StringBuilder();
            FrameDebugUtils.prettyPrint(fta, recordDescriptor, tid, bbis, dis, sb);
            System.err.println(sb.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void prettyPrint(IFrameTupleAccessor fta, RecordDescriptor recordDescriptor, String prefix, int[] recordFields) throws IOException {
        try (ByteBufferInputStream bbis = new ByteBufferInputStream();
             DataInputStream dis = new DataInputStream(bbis);){
            int tc = fta.getTupleCount();
            StringBuilder sb = new StringBuilder();
            sb.append(prefix).append("TC: " + tc).append("\n");
            for (int i = 0; i < tc; ++i) {
                FrameDebugUtils.prettyPrint(fta, recordDescriptor, i, bbis, dis, sb, recordFields);
            }
            System.err.println(sb.toString());
        }
    }

    public static void prettyPrint(IFrameTupleAccessor fta, RecordDescriptor recordDescriptor, int tIdx, int[] recordFields) throws IOException {
        try (ByteBufferInputStream bbis = new ByteBufferInputStream();
             DataInputStream dis = new DataInputStream(bbis);){
            StringBuilder sb = new StringBuilder();
            FrameDebugUtils.prettyPrint(fta, recordDescriptor, tIdx, bbis, dis, sb, recordFields);
            System.err.println(sb.toString());
        }
    }

    public static void prettyPrint(IFrameTupleAccessor fta, RecordDescriptor recordDescriptor, ITupleReference tuple, int fieldsIdx, int descIdx) throws HyracksDataException {
        try (ByteBufferInputStream bbis = new ByteBufferInputStream();
             DataInputStream dis = new DataInputStream(bbis);){
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append("f" + fieldsIdx + ":(" + tuple.getFieldStart(fieldsIdx) + ", " + (tuple.getFieldLength(fieldsIdx) + tuple.getFieldStart(fieldsIdx)) + ") ");
            sb.append("{");
            ByteBuffer bytebuff = ByteBuffer.wrap(tuple.getFieldData(fieldsIdx));
            bbis.setByteBuffer(bytebuff, tuple.getFieldStart(fieldsIdx));
            sb.append(recordDescriptor.getFields()[descIdx].deserialize((DataInput)dis));
            sb.append("}");
            sb.append("\n");
            System.err.println(sb.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void prettyPrint(IFrameTupleAccessor fta, RecordDescriptor recordDescriptor, ITupleReference tuple, int[] descF) throws HyracksDataException {
        try (ByteBufferInputStream bbis = new ByteBufferInputStream();
             DataInputStream dis = new DataInputStream(bbis);){
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int j = 0; j < descF.length; ++j) {
                sb.append("f" + j + ":(" + tuple.getFieldStart(j) + ", " + (tuple.getFieldLength(j) + tuple.getFieldStart(j)) + ") ");
                sb.append("{");
                ByteBuffer bytebuff = ByteBuffer.wrap(tuple.getFieldData(j));
                bbis.setByteBuffer(bytebuff, tuple.getFieldStart(j));
                sb.append(recordDescriptor.getFields()[descF[j]].deserialize((DataInput)dis));
                sb.append("}");
            }
            sb.append("\n");
            System.err.println(sb.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static void prettyPrint(IFrameTupleAccessor fta, RecordDescriptor recordDescriptor, int tid, ByteBufferInputStream bbis, DataInputStream dis, StringBuilder sb, int[] recordFields) throws IOException {
        Arrays.sort(recordFields);
        sb.append(" tid" + tid + ":(" + fta.getTupleStartOffset(tid) + ", " + fta.getTupleEndOffset(tid) + ")[");
        for (int j = 0; j < fta.getFieldCount(); ++j) {
            sb.append("f" + j + ":(" + fta.getFieldStartOffset(tid, j) + ", " + fta.getFieldEndOffset(tid, j) + ") ");
            sb.append("{");
            bbis.setByteBuffer(fta.getBuffer(), fta.getTupleStartOffset(tid) + fta.getFieldSlotsLength() + fta.getFieldStartOffset(tid, j));
            if (Arrays.binarySearch(recordFields, j) >= 0) {
                sb.append("{a record field: only print using pointable:");
                sb.append("tag->" + dis.readByte() + "}");
            } else {
                sb.append(recordDescriptor.getFields()[j].deserialize((DataInput)dis));
            }
            sb.append("}");
        }
        sb.append("\n");
    }
}

