/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.tuples;

import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class TokenKeyPairTuple
implements ITupleReference {
    private ITupleReference tokenTuple;
    private ITupleReference keyTuple;
    private final int tokenFieldCount;
    private final int keyFieldCount;
    private boolean newToken;

    public TokenKeyPairTuple(int tokenFieldCount, int keyFieldCount) {
        this.tokenFieldCount = tokenFieldCount;
        this.keyFieldCount = keyFieldCount;
    }

    public void setTokenTuple(ITupleReference token) {
        this.tokenTuple = token;
        this.keyTuple = null;
    }

    public void setKeyTuple(ITupleReference key) {
        this.newToken = this.keyTuple == null;
        this.keyTuple = key;
    }

    public ITupleReference getTokenTuple() {
        return this.tokenTuple;
    }

    public ITupleReference getKeyTuple() {
        return this.keyTuple;
    }

    public int getFieldCount() {
        return this.tokenFieldCount + this.keyFieldCount;
    }

    public byte[] getFieldData(int fIdx) {
        ITupleReference tuple = this.getTuple(fIdx);
        int fieldIndex = this.getFieldIndex(fIdx);
        return tuple.getFieldData(fieldIndex);
    }

    public int getFieldStart(int fIdx) {
        ITupleReference tuple = this.getTuple(fIdx);
        int fieldIndex = this.getFieldIndex(fIdx);
        return tuple.getFieldStart(fieldIndex);
    }

    public int getFieldLength(int fIdx) {
        ITupleReference tuple = this.getTuple(fIdx);
        int fieldIndex = this.getFieldIndex(fIdx);
        return tuple.getFieldLength(fieldIndex);
    }

    private ITupleReference getTuple(int fIdx) {
        return fIdx < this.tokenFieldCount ? this.tokenTuple : this.keyTuple;
    }

    private int getFieldIndex(int fIdx) {
        return fIdx < this.tokenFieldCount ? fIdx : fIdx - this.tokenFieldCount;
    }

    public boolean isNewToken() {
        return this.newToken;
    }
}

