/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class ConsolidateAssignsRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        AssignOperator assign1 = (AssignOperator)op;
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)((Mutable)assign1.getInputs().get(0)).getValue();
        if (op2.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        if (!OperatorPropertiesUtil.isMovable((ILogicalOperator)op) || !OperatorPropertiesUtil.isMovable((ILogicalOperator)op2)) {
            return false;
        }
        AssignOperator assign2 = (AssignOperator)op2;
        HashSet used1 = new HashSet();
        VariableUtilities.getUsedVariables((ILogicalOperator)assign1, used1);
        for (LogicalVariable v2 : assign2.getVariables()) {
            if (!used1.contains(v2)) continue;
            return false;
        }
        assign1.getVariables().addAll(assign2.getVariables());
        assign1.getExpressions().addAll(assign2.getExpressions());
        Mutable botOpRef = (Mutable)assign2.getInputs().get(0);
        List asgnInpList = assign1.getInputs();
        asgnInpList.clear();
        asgnInpList.add(botOpRef);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assign1);
        return true;
    }
}

