/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.service;

import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.common.config.ConfigUtils;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.control.common.controllers.ServiceConstants;
import org.apache.hyracks.control.nc.service.NCServiceConfig;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ini4j.Ini;
import org.kohsuke.args4j.CmdLineParser;

public class NCService {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Ini ini = new Ini();
    private static String ncId = "";
    private static String nodeSection = null;
    private static NCServiceConfig config;
    private static Process proc;
    private static java.lang.management.OperatingSystemMXBean osMXBean;

    private static List<String> buildCommand() throws IOException {
        ArrayList<String> cList = new ArrayList<String>();
        String command = ConfigUtils.getString((Ini)ini, (String)nodeSection, (String)NCConfig.Option.COMMAND.ini(), (String)"hyracksnc");
        String apphome = System.getProperty("app.home", System.getProperty("user.home"));
        String path = apphome + File.separator + "bin" + File.separator;
        if (SystemUtils.IS_OS_WINDOWS) {
            cList.add(path + command + ".bat");
        } else {
            cList.add(path + command);
        }
        cList.add("-config-file");
        File tempIni = File.createTempFile("ncconf", ".conf");
        tempIni.deleteOnExit();
        ini.store(tempIni);
        cList.add(tempIni.getCanonicalPath());
        cList.add("-ncservice-pid");
        cList.add(System.getProperty("app.pid", "0"));
        return cList;
    }

    private static void configEnvironment(Map<String, String> env) {
        String jvmargs = ConfigUtils.getString((Ini)ini, (String)nodeSection, (String)NCConfig.Option.JVM_ARGS.ini(), null);
        if (jvmargs != null) {
            LOGGER.info("Using JAVA_OPTS from conf file (jvm.args)");
        } else {
            jvmargs = env.get("JAVA_OPTS");
            if (jvmargs != null) {
                LOGGER.info("Using JAVA_OPTS from environment");
            } else {
                LOGGER.info("Using default JAVA_OPTS");
                jvmargs = "";
            }
        }
        if (!jvmargs.contains("-Xmx")) {
            long ramSize = ((OperatingSystemMXBean)osMXBean).getTotalPhysicalMemorySize();
            int proportionalRamSize = (int)Math.ceil(0.6 * (double)ramSize / 1048576.0);
            int heapSize = "32".equals(System.getProperty("sun.arch.data.model")) ? (proportionalRamSize <= 1024 ? proportionalRamSize : 1024) : proportionalRamSize;
            jvmargs = jvmargs + " -Xmx" + heapSize + "m";
        }
        env.put("JAVA_OPTS", jvmargs.trim());
        LOGGER.info("Setting JAVA_OPTS to " + jvmargs);
    }

    private static boolean launchNCProcess() {
        try {
            ProcessBuilder pb = new ProcessBuilder(NCService.buildCommand());
            NCService.configEnvironment(pb.environment());
            pb.inheritIO();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Launching NCDriver process");
            }
            if (!"-".equals(NCService.config.logdir)) {
                pb.redirectErrorStream(true);
                File log = new File(NCService.config.logdir);
                if (!log.mkdirs() && !log.isDirectory()) {
                    throw new IOException(NCService.config.logdir + ": cannot create");
                }
                File logfile = new File(NCService.config.logdir, "nc-" + ncId + ".log");
                try (FileWriter writer = new FileWriter(logfile, true);){
                    writer.write("---------------------\n");
                    writer.write(new Date() + "\n");
                    writer.write("---------------------\n");
                }
                pb.redirectOutput(ProcessBuilder.Redirect.appendTo(logfile));
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Logging to " + logfile.getCanonicalPath());
                }
            }
            proc = pb.start();
            boolean waiting = true;
            int retval = 0;
            while (waiting) {
                try {
                    retval = proc.waitFor();
                    waiting = false;
                }
                catch (InterruptedException interruptedException) {}
            }
            LOGGER.info("NCDriver exited with return value " + retval);
            if (retval == 99) {
                LOGGER.info("Terminating NCService based on return value from NCDriver");
                NCService.exit(0);
            }
            return retval == 0;
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                StringWriter sw = new StringWriter();
                try {
                    ini.store((Writer)sw);
                    LOGGER.log(Level.ERROR, "Configuration from CC broken: \n" + sw.toString(), (Throwable)e);
                }
                catch (IOException e1) {
                    LOGGER.log(Level.ERROR, "Configuration from CC broken, failed to serialize", (Throwable)e1);
                }
            }
            return false;
        }
    }

    private static boolean acceptConnection(InputStream is) {
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            String magic = ois.readUTF();
            if (!"hyncmagic2".equals(magic)) {
                LOGGER.error("Connection used incorrect magic cookie");
                return false;
            }
            switch (ServiceConstants.ServiceCommand.valueOf((String)ois.readUTF())) {
                case START_NC: {
                    String iniString = ois.readUTF();
                    ini = new Ini((Reader)new StringReader(iniString));
                    ncId = ConfigUtils.getString((Ini)ini, (Section)Section.LOCALNC, (IOption)NCConfig.Option.NODE_ID, (String)"");
                    nodeSection = "nc/" + ncId;
                    return NCService.launchNCProcess();
                }
                case TERMINATE: {
                    LOGGER.info("Terminating NCService based on command from CC");
                    NCService.exit(0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Error decoding connection from server", (Throwable)e);
        }
        return false;
    }

    private static void exit(int exitCode) {
        LOGGER.info("JVM Exiting.. Bye!");
        System.exit(exitCode);
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws Exception {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (proc != null) {
                    proc.destroy();
                    try {
                        proc.waitFor();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        NCService.config = new NCServiceConfig();
        cp = new CmdLineParser((Object)NCService.config);
        try {
            cp.parseArgument(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            cp.printUsage((OutputStream)System.err);
            System.exit(1);
        }
        NCService.config.loadConfigAndApplyDefaults();
        NCService.osMXBean = ManagementFactory.getOperatingSystemMXBean();
        addr = NCService.config.address == null ? null : InetAddress.getByName(NCService.config.address);
        port = NCService.config.port;
        block20: while (true) {
            listener = new ServerSocket(port, 5, addr);
            var5_6 = null;
            try {
                launched = false;
                while (true) lbl-1000:
                // 3 sources

                {
                    if (launched) continue block20;
                    NCService.LOGGER.info("Waiting for connection from CC on " + (addr == null ? "*" : addr) + ":" + port);
                    socket = listener.accept();
                    var8_11 = null;
                    try {
                        launched = NCService.acceptConnection(socket.getInputStream());
                    }
                    catch (Throwable var9_13) {
                        var8_11 = var9_13;
                        throw var9_13;
                    }
                    finally {
                        if (socket == null) continue;
                        if (var8_11 != null) {
                            try {
                                socket.close();
                            }
                            catch (Throwable var9_12) {
                                var8_11.addSuppressed(var9_12);
                            }
                            continue;
                        }
                        socket.close();
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable var6_9) {
                var5_6 = var6_9;
                throw var6_9;
            }
            finally {
                if (listener == null) continue;
                if (var5_6 != null) {
                    try {
                        listener.close();
                    }
                    catch (Throwable var6_8) {
                        var5_6.addSuppressed(var6_8);
                    }
                    continue;
                }
                listener.close();
                continue;
            }
            ** GOTO lbl-1000
            break;
        }
    }

    static {
        proc = null;
    }
}

