/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.om.exceptions.InvalidExpressionException;
import org.apache.asterix.om.typecomputer.base.IResultTypeComputer;
import org.apache.asterix.om.typecomputer.base.TypeCastUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;

public class ClosedRecordConstructorResultType
implements IResultTypeComputer {
    public static final ClosedRecordConstructorResultType INSTANCE = new ClosedRecordConstructorResultType();

    @Override
    public IAType computeType(ILogicalExpression expression, IVariableTypeEnvironment env, IMetadataProvider<?, ?> metadataProvider) throws AlgebricksException {
        AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)expression;
        ARecordType type = (ARecordType)TypeCastUtils.getRequiredType(f);
        if (type != null) {
            return type;
        }
        int n = f.getArguments().size() / 2;
        String[] fieldNames = new String[n];
        IAType[] fieldTypes = new IAType[n];
        int i = 0;
        Iterator argIter = f.getArguments().iterator();
        while (argIter.hasNext()) {
            String fieldName;
            ILogicalExpression e1 = (ILogicalExpression)((Mutable)argIter.next()).getValue();
            ILogicalExpression e2 = (ILogicalExpression)((Mutable)argIter.next()).getValue();
            IAType e2Type = (IAType)env.getType(e2);
            if (e2Type.getTypeTag() == ATypeTag.UNION) {
                AUnionType unionType = (AUnionType)e2Type;
                e2Type = AUnionType.createUnknownableType(unionType.getActualType());
            }
            if ((fieldName = ConstantExpressionUtil.getStringConstant(e1)) == null) {
                throw new InvalidExpressionException(f.getSourceLocation(), f.getFunctionIdentifier(), 2 * i, e1, LogicalExpressionTag.CONSTANT);
            }
            for (int j = 0; j < i; ++j) {
                if (!fieldName.equals(fieldNames[j])) continue;
                throw new CompilationException(13, f.getSourceLocation(), new Serializable[]{fieldName});
            }
            fieldTypes[i] = e2Type;
            fieldNames[i] = fieldName;
            ++i;
        }
        return new ARecordType(null, fieldNames, fieldTypes, false);
    }
}

