/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.utils;

import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.AUnorderedList;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;

public class ConstantExpressionUtil {
    private ConstantExpressionUtil() {
    }

    public static IAObject getConstantIaObject(ILogicalExpression expr, ATypeTag typeTag) {
        if (expr.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
            return null;
        }
        IAlgebricksConstantValue acv = ((ConstantExpression)expr).getValue();
        if (!(acv instanceof AsterixConstantValue)) {
            return null;
        }
        IAObject iaObject = ((AsterixConstantValue)acv).getObject();
        if (typeTag != null) {
            return iaObject.getType().getTypeTag() == typeTag ? iaObject : null;
        }
        return iaObject;
    }

    public static ATypeTag getConstantIaObjectType(ILogicalExpression expr) {
        IAObject iaObject = ConstantExpressionUtil.getConstantIaObject(expr, null);
        return iaObject.getType().getTypeTag();
    }

    public static Long getLongConstant(ILogicalExpression expr) {
        IAObject iaObject = ConstantExpressionUtil.getConstantIaObject(expr, ATypeTag.BIGINT);
        return iaObject != null ? Long.valueOf(((AInt64)iaObject).getLongValue()) : null;
    }

    public static Integer getIntConstant(ILogicalExpression expr) {
        IAObject iaObject = ConstantExpressionUtil.getConstantIaObject(expr, ATypeTag.INTEGER);
        return iaObject != null ? Integer.valueOf(((AInt32)iaObject).getIntegerValue()) : null;
    }

    public static String getStringConstant(ILogicalExpression expr) {
        IAObject iaObject = ConstantExpressionUtil.getConstantIaObject(expr, ATypeTag.STRING);
        return iaObject != null ? ((AString)iaObject).getStringValue() : null;
    }

    public static String getStringConstant(IAObject iaObject) {
        return iaObject != null ? ((AString)iaObject).getStringValue() : null;
    }

    public static AOrderedList getOrderedListConstant(IAObject iaObject) {
        return iaObject != null ? (AOrderedList)iaObject : null;
    }

    public static AUnorderedList getUnorderedListConstant(IAObject iaObject) {
        return iaObject != null ? (AUnorderedList)iaObject : null;
    }

    public static Boolean getBooleanConstant(ILogicalExpression expr) {
        IAObject iaObject = ConstantExpressionUtil.getConstantIaObject(expr, ATypeTag.BOOLEAN);
        return iaObject != null ? ((ABoolean)iaObject).getBoolean() : null;
    }

    public static Integer getIntArgument(AbstractFunctionCallExpression f, int index) {
        return ConstantExpressionUtil.getIntConstant((ILogicalExpression)((Mutable)f.getArguments().get(index)).getValue());
    }

    public static String getStringArgument(AbstractFunctionCallExpression f, int index) {
        return ConstantExpressionUtil.getStringConstant((ILogicalExpression)((Mutable)f.getArguments().get(index)).getValue());
    }

    public static Integer getIntArgument(ILogicalExpression expr, int index) {
        return expr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL ? ConstantExpressionUtil.getIntArgument((AbstractFunctionCallExpression)expr, index) : null;
    }

    public static String getStringArgument(ILogicalExpression expr, int index) {
        return expr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL ? ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)expr, index) : null;
    }
}

