/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.feed.management;

import java.io.Serializable;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.common.metadata.DataverseName;

public class FeedConnectionId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FEED_EXTENSION_NAME = "Feed";
    private final EntityId feedId;
    private final String datasetName;
    private final int hash;

    public FeedConnectionId(EntityId feedId, String datasetName) {
        this.feedId = feedId;
        this.datasetName = datasetName;
        this.hash = this.toString().hashCode();
    }

    public FeedConnectionId(DataverseName dataverseName, String feedName, String datasetName) {
        this(new EntityId(FEED_EXTENSION_NAME, dataverseName, feedName), datasetName);
    }

    public EntityId getFeedId() {
        return this.feedId;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FeedConnectionId)) {
            return false;
        }
        return this == o || ((FeedConnectionId)o).getFeedId().equals((Object)this.feedId) && ((FeedConnectionId)o).getDatasetName().equals(this.datasetName);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.feedId.toString() + "-->" + this.datasetName;
    }
}

