/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.replication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.asterix.app.nc.task.BindMetadataNodeTask;
import org.apache.asterix.app.nc.task.CheckpointTask;
import org.apache.asterix.app.nc.task.ExportMetadataNodeTask;
import org.apache.asterix.app.nc.task.LocalRecoveryTask;
import org.apache.asterix.app.nc.task.MetadataBootstrapTask;
import org.apache.asterix.app.nc.task.StartLifecycleComponentsTask;
import org.apache.asterix.app.nc.task.StartReplicationServiceTask;
import org.apache.asterix.app.nc.task.UpdateNodeStatusTask;
import org.apache.asterix.app.replication.message.MetadataNodeRequestMessage;
import org.apache.asterix.app.replication.message.MetadataNodeResponseMessage;
import org.apache.asterix.app.replication.message.NCLifecycleTaskReportMessage;
import org.apache.asterix.app.replication.message.RegistrationTasksRequestMessage;
import org.apache.asterix.app.replication.message.RegistrationTasksResponseMessage;
import org.apache.asterix.common.api.INCLifecycleTask;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.messaging.api.ICCMessageBroker;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.common.replication.INCLifecycleMessage;
import org.apache.asterix.common.replication.INcLifecycleCoordinator;
import org.apache.asterix.common.transactions.IRecoveryManager;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.client.NodeStatus;
import org.apache.hyracks.api.control.IGatekeeper;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NcLifecycleCoordinator
implements INcLifecycleCoordinator {
    private static final Logger LOGGER = LogManager.getLogger();
    protected IClusterStateManager clusterManager;
    protected volatile String metadataNodeId;
    protected Set<String> pendingStartupCompletionNodes = Collections.synchronizedSet(new HashSet());
    protected final ICCMessageBroker messageBroker;
    private final boolean replicationEnabled;
    private final IGatekeeper gatekeeper;

    public NcLifecycleCoordinator(ICCServiceContext serviceCtx, boolean replicationEnabled) {
        this.messageBroker = (ICCMessageBroker)serviceCtx.getMessageBroker();
        this.replicationEnabled = replicationEnabled;
        this.gatekeeper = ((ClusterControllerService)serviceCtx.getControllerService()).getApplication().getGatekeeper();
    }

    public void notifyNodeJoin(String nodeId) {
        this.pendingStartupCompletionNodes.add(nodeId);
    }

    public void notifyNodeFailure(String nodeId) throws HyracksDataException {
        this.pendingStartupCompletionNodes.remove(nodeId);
        this.clusterManager.updateNodeState(nodeId, false, null);
        if (nodeId.equals(this.metadataNodeId)) {
            this.clusterManager.updateMetadataNode(this.metadataNodeId, false);
        }
        this.clusterManager.refreshState();
    }

    public void process(INCLifecycleMessage message) throws HyracksDataException {
        switch (message.getType()) {
            case REGISTRATION_TASKS_REQUEST: {
                this.process((RegistrationTasksRequestMessage)message);
                break;
            }
            case REGISTRATION_TASKS_RESULT: {
                this.process((NCLifecycleTaskReportMessage)message);
                break;
            }
            case METADATA_NODE_RESPONSE: {
                this.process((MetadataNodeResponseMessage)message);
                break;
            }
            default: {
                throw new RuntimeDataException(4003, new Serializable[]{message.getType().name()});
            }
        }
    }

    public void bindTo(IClusterStateManager clusterManager) {
        this.clusterManager = clusterManager;
        this.metadataNodeId = clusterManager.getCurrentMetadataNodeId();
    }

    private void process(RegistrationTasksRequestMessage msg) throws HyracksDataException {
        String nodeId = msg.getNodeId();
        List<INCLifecycleTask> tasks = this.buildNCRegTasks(msg.getNodeId(), msg.getNodeStatus(), msg.getState());
        RegistrationTasksResponseMessage response = new RegistrationTasksResponseMessage(nodeId, tasks);
        try {
            this.messageBroker.sendApplicationMessageToNC((INcAddressedMessage)response, msg.getNodeId());
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void process(NCLifecycleTaskReportMessage msg) throws HyracksDataException {
        if (!this.pendingStartupCompletionNodes.remove(msg.getNodeId())) {
            LOGGER.warn("Received unexpected startup completion message from node {}", (Object)msg.getNodeId());
        }
        if (!this.gatekeeper.isAuthorized(msg.getNodeId())) {
            LOGGER.warn("Node {} lost authorization before startup completed; ignoring registration result", (Object)msg.getNodeId());
            return;
        }
        if (msg.isSuccess()) {
            this.clusterManager.updateNodeState(msg.getNodeId(), true, msg.getLocalCounters());
            if (msg.getNodeId().equals(this.metadataNodeId)) {
                this.clusterManager.updateMetadataNode(this.metadataNodeId, true);
            }
            this.clusterManager.refreshState();
        } else {
            LOGGER.error("Node {} failed to complete startup", (Object)msg.getNodeId(), (Object)msg.getException());
        }
    }

    protected List<INCLifecycleTask> buildNCRegTasks(String nodeId, NodeStatus nodeStatus, IRecoveryManager.SystemState state) {
        LOGGER.info("Building registration tasks for node {} with status {} and system state: {}", (Object)nodeId, (Object)nodeStatus, (Object)state);
        boolean isMetadataNode = nodeId.equals(this.metadataNodeId);
        switch (nodeStatus) {
            case ACTIVE: {
                return this.buildActiveNCRegTasks(isMetadataNode);
            }
            case IDLE: {
                return this.buildIdleNcRegTasks(nodeId, isMetadataNode, state);
            }
        }
        return new ArrayList<INCLifecycleTask>();
    }

    protected List<INCLifecycleTask> buildActiveNCRegTasks(boolean metadataNode) {
        ArrayList<INCLifecycleTask> tasks = new ArrayList<INCLifecycleTask>();
        if (metadataNode) {
            tasks.add(new BindMetadataNodeTask());
        }
        return tasks;
    }

    public synchronized void notifyMetadataNodeChange(String node) throws HyracksDataException {
        if (this.metadataNodeId.equals(node)) {
            return;
        }
        if (this.clusterManager.isMetadataNodeActive()) {
            MetadataNodeRequestMessage msg = new MetadataNodeRequestMessage(false, this.clusterManager.getMetadataPartition().getPartitionId());
            try {
                this.messageBroker.sendApplicationMessageToNC((INcAddressedMessage)msg, this.metadataNodeId);
                this.metadataNodeId = node;
            }
            catch (Exception e) {
                throw HyracksDataException.create((Throwable)e);
            }
        } else {
            this.requestMetadataNodeTakeover(node);
        }
    }

    protected List<INCLifecycleTask> buildIdleNcRegTasks(String nodeId, boolean metadataNode, IRecoveryManager.SystemState state) {
        ArrayList<INCLifecycleTask> tasks = new ArrayList<INCLifecycleTask>();
        tasks.add(new UpdateNodeStatusTask(NodeStatus.BOOTING));
        if (state == IRecoveryManager.SystemState.CORRUPTED) {
            LocalRecoveryTask rt = new LocalRecoveryTask(Arrays.stream(this.clusterManager.getNodePartitions(nodeId)).map(ClusterPartition::getPartitionId).collect(Collectors.toSet()));
            tasks.add(rt);
        }
        if (this.replicationEnabled) {
            tasks.add(new StartReplicationServiceTask());
        }
        if (metadataNode) {
            tasks.add(new MetadataBootstrapTask(this.clusterManager.getMetadataPartition().getPartitionId()));
        }
        tasks.add(new CheckpointTask());
        tasks.add(new StartLifecycleComponentsTask());
        if (metadataNode) {
            tasks.add(new ExportMetadataNodeTask(true));
            tasks.add(new BindMetadataNodeTask());
        }
        tasks.add(new UpdateNodeStatusTask(NodeStatus.ACTIVE));
        return tasks;
    }

    private synchronized void process(MetadataNodeResponseMessage response) throws HyracksDataException {
        MetadataManager.INSTANCE.rebindMetadataNode();
        this.clusterManager.updateMetadataNode(response.getNodeId(), response.isExported());
        if (!response.isExported()) {
            this.requestMetadataNodeTakeover(this.metadataNodeId);
        }
    }

    private void requestMetadataNodeTakeover(String node) throws HyracksDataException {
        MetadataNodeRequestMessage msg = new MetadataNodeRequestMessage(true, this.clusterManager.getMetadataPartition().getPartitionId());
        try {
            this.messageBroker.sendApplicationMessageToNC((INcAddressedMessage)msg, node);
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

