/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCacheProvider;

public class AsterixVirtualBufferCacheProvider
implements IVirtualBufferCacheProvider {
    private static final long serialVersionUID = 1L;
    private final int datasetId;

    public AsterixVirtualBufferCacheProvider(int datasetId) {
        this.datasetId = datasetId;
    }

    public List<IVirtualBufferCache> getVirtualBufferCaches(INCServiceContext ctx, FileReference fileRef) throws HyracksDataException {
        IIOManager ioManager = ctx.getIoManager();
        int deviceId = AsterixVirtualBufferCacheProvider.getDeviceId(ioManager, fileRef);
        return ((INcApplicationContext)ctx.getApplicationContext()).getDatasetLifecycleManager().getVirtualBufferCaches(this.datasetId, deviceId);
    }

    public static int getDeviceId(IIOManager ioManager, FileReference fileRef) {
        IODeviceHandle device = fileRef.getDeviceHandle();
        List devices = ioManager.getIODevices();
        int deviceId = 0;
        for (int i = 0; i < devices.size(); ++i) {
            IODeviceHandle next = (IODeviceHandle)devices.get(i);
            if (next != device) continue;
            deviceId = i;
        }
        return deviceId;
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode json = registry.getClassIdentifier(this.getClass(), 1L);
        json.put("datasetId", this.datasetId);
        return json;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
        return new AsterixVirtualBufferCacheProvider(json.get("datasetId").asInt());
    }
}

