/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.expression.WindowExpression;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.AbstractSqlppExpressionExtractionVisitor;
import org.apache.asterix.lang.sqlpp.util.FunctionMapUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppRewriteUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;

public final class SqlppWindowRewriteVisitor
extends AbstractSqlppExpressionExtractionVisitor {
    public SqlppWindowRewriteVisitor(LangRewritingContext context) {
        super(context);
    }

    @Override
    protected void visitFromClause(FromClause clause, ILangExpression arg, AbstractSqlppExpressionExtractionVisitor.StackElement stackElement) throws CompilationException {
        clause.accept(this, arg);
        if (!stackElement.extractionList.isEmpty()) {
            throw new CompilationException(1100, clause.getSourceLocation(), new Serializable[0]);
        }
    }

    @Override
    public Expression visit(WindowExpression winExpr, ILangExpression arg) throws CompilationException {
        FunctionSignature signature;
        FunctionIdentifier winfi;
        super.visit(winExpr, arg);
        if (!winExpr.hasWindowVar()) {
            VariableExpr winVar = new VariableExpr(this.context.newVariable());
            winVar.setSourceLocation(winExpr.getSourceLocation());
            winExpr.setWindowVar(winVar);
        }
        if ((winfi = FunctionMapUtil.getInternalWindowFunction(signature = winExpr.getFunctionSignature())) != null) {
            if (winExpr.hasAggregateFilterExpr()) {
                throw new CompilationException(1121, winExpr.getSourceLocation(), new Serializable[0]);
            }
            this.rewriteSpecificWindowFunctions(winfi, winExpr);
            if (BuiltinFunctions.builtinFunctionHasProperty((FunctionIdentifier)winfi, (BuiltinFunctions.BuiltinFunctionProperty)BuiltinFunctions.WindowFunctionProperty.HAS_LIST_ARG)) {
                this.extractListArgument(winExpr);
            }
        } else if (FunctionMapUtil.isSql92AggregateFunction(signature)) {
            Expression aggFilterExpr;
            if (winExpr.hasAggregateFilterExpr() && this.isExtractableArgument(aggFilterExpr = winExpr.getAggregateFilterExpr())) {
                VariableExpr newAggFilterExpr = this.extractExpression(aggFilterExpr);
                if (newAggFilterExpr == null) {
                    throw new CompilationException(1079, winExpr.getSourceLocation(), new Serializable[]{""});
                }
                winExpr.setAggregateFilterExpr((Expression)newAggFilterExpr);
            }
            if (winExpr.getExprList().size() != 1) {
                throw new CompilationException(1079, winExpr.getSourceLocation(), new Serializable[]{""});
            }
            this.extractListArgument(winExpr);
        } else if (FunctionMapUtil.isCoreAggregateFunction(signature)) {
            if (winExpr.hasAggregateFilterExpr()) {
                throw new CompilationException(1121, winExpr.getSourceLocation(), new Serializable[0]);
            }
        } else {
            throw new CompilationException(1102, winExpr.getSourceLocation(), new Serializable[]{signature.getName()});
        }
        return winExpr;
    }

    private void extractListArgument(WindowExpression winExpr) throws CompilationException {
        List<Expression> argExprList = winExpr.getExprList();
        Expression argExpr0 = argExprList.get(0);
        if (this.isExtractableArgument(argExpr0)) {
            VariableExpr newArgExpr0 = this.extractExpression(argExpr0);
            if (newArgExpr0 == null) {
                throw new CompilationException(1079, winExpr.getSourceLocation(), new Serializable[]{""});
            }
            ArrayList<Expression> newArgExprList = new ArrayList<Expression>(argExprList);
            newArgExprList.set(0, (Expression)newArgExpr0);
            winExpr.setExprList(newArgExprList);
        }
    }

    private VariableExpr extractExpression(Expression expr) {
        AbstractSqlppExpressionExtractionVisitor.StackElement stackElement = (AbstractSqlppExpressionExtractionVisitor.StackElement)this.stack.peek();
        if (stackElement == null) {
            return null;
        }
        VarIdentifier v = stackElement.addPendingLetClause(expr);
        VariableExpr vExpr = new VariableExpr(v);
        vExpr.setSourceLocation(expr.getSourceLocation());
        return vExpr;
    }

    private boolean isExtractableArgument(Expression expr) {
        switch (expr.getKind()) {
            case LITERAL_EXPRESSION: 
            case VARIABLE_EXPRESSION: {
                return false;
            }
        }
        return true;
    }

    @Override
    void handleUnsupportedClause(FromClause clause) throws CompilationException {
        throw new CompilationException(1100, clause.getSourceLocation(), new Serializable[0]);
    }

    private void rewriteSpecificWindowFunctions(FunctionIdentifier winfi, WindowExpression winExpr) throws CompilationException {
        if (BuiltinFunctions.builtinFunctionHasProperty((FunctionIdentifier)winfi, (BuiltinFunctions.BuiltinFunctionProperty)BuiltinFunctions.WindowFunctionProperty.HAS_LIST_ARG)) {
            this.duplicateFirstArgument(winExpr);
        }
    }

    private void duplicateFirstArgument(WindowExpression winExpr) throws CompilationException {
        List<Expression> exprList = winExpr.getExprList();
        Expression arg = exprList.get(0);
        exprList.add((Expression)SqlppRewriteUtil.deepCopy((ILangExpression)arg));
    }
}

