/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.hdfs.dataflow;

import java.util.Arrays;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;
import org.apache.hyracks.hdfs.api.IKeyValueParser;
import org.apache.hyracks.hdfs.api.IKeyValueParserFactory;
import org.apache.hyracks.hdfs.dataflow.ConfFactory;
import org.apache.hyracks.hdfs.dataflow.InputSplitsFactory;

public class HDFSReadOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final ConfFactory confFactory;
    private final InputSplitsFactory splitsFactory;
    private final String[] scheduledLocations;
    private final IKeyValueParserFactory tupleParserFactory;
    private final boolean[] executed;

    public HDFSReadOperatorDescriptor(JobSpecification spec, RecordDescriptor rd, JobConf conf, InputSplit[] splits, String[] scheduledLocations, IKeyValueParserFactory tupleParserFactory) throws HyracksException {
        super((IOperatorDescriptorRegistry)spec, 0, 1);
        try {
            this.splitsFactory = new InputSplitsFactory(splits);
            this.confFactory = new ConfFactory(conf);
        }
        catch (Exception e) {
            throw HyracksException.create((Throwable)e);
        }
        this.scheduledLocations = scheduledLocations;
        this.executed = new boolean[scheduledLocations.length];
        Arrays.fill(this.executed, false);
        this.tupleParserFactory = tupleParserFactory;
        this.outRecDescs[0] = rd;
    }

    public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        final InputSplit[] inputSplits = this.splitsFactory.getSplits();
        return new AbstractUnaryOutputSourceOperatorNodePushable(){
            private String nodeName;
            {
                this.nodeName = ctx.getJobletContext().getServiceContext().getNodeId();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void initialize() throws HyracksDataException {
                ClassLoader ctxCL = Thread.currentThread().getContextClassLoader();
                try {
                    this.writer.open();
                    Thread.currentThread().setContextClassLoader(ctx.getJobletContext().getClassLoader());
                    JobConf conf = HDFSReadOperatorDescriptor.this.confFactory.getConf();
                    conf.setClassLoader(ctx.getJobletContext().getClassLoader());
                    IKeyValueParser<Object, Object> parser = HDFSReadOperatorDescriptor.this.tupleParserFactory.createKeyValueParser(ctx);
                    try {
                        parser.open(this.writer);
                        InputFormat inputFormat = conf.getInputFormat();
                        for (int i = 0; i < inputSplits.length; ++i) {
                            if (!HDFSReadOperatorDescriptor.this.scheduledLocations[i].equals(this.nodeName)) continue;
                            boolean[] blArray = HDFSReadOperatorDescriptor.this.executed;
                            synchronized (blArray) {
                                if (HDFSReadOperatorDescriptor.this.executed[i]) {
                                    continue;
                                }
                                ((HDFSReadOperatorDescriptor)HDFSReadOperatorDescriptor.this).executed[i] = true;
                            }
                            RecordReader reader = inputFormat.getRecordReader(inputSplits[i], conf, Reporter.NULL);
                            Object key = reader.createKey();
                            Object value = reader.createValue();
                            while (reader.next(key, value)) {
                                parser.parse(key, value, this.writer, inputSplits[i].toString());
                            }
                        }
                    }
                    finally {
                        parser.close(this.writer);
                    }
                }
                catch (Throwable th) {
                    this.writer.fail();
                    throw HyracksDataException.create((Throwable)th);
                }
                finally {
                    this.writer.close();
                    Thread.currentThread().setContextClassLoader(ctxCL);
                }
            }
        };
    }
}

