/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.dataflow;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PermutingFrameTupleReference;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITupleFilter;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.impls.IndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.LocalResource;

public class IndexInsertUpdateDeleteOperatorNodePushable
extends AbstractUnaryInputUnaryOutputOperatorNodePushable {
    protected final IHyracksTaskContext ctx;
    protected final IIndexDataflowHelper indexHelper;
    protected final RecordDescriptor inputRecDesc;
    protected final IndexOperation op;
    protected final PermutingFrameTupleReference tuple = new PermutingFrameTupleReference();
    protected FrameTupleAccessor accessor;
    protected FrameTupleReference frameTuple;
    protected IFrame writeBuffer;
    protected IIndexAccessor indexAccessor;
    protected ITupleFilter tupleFilter;
    protected IModificationOperationCallback modCallback;
    protected IIndex index;
    protected final IModificationOperationCallbackFactory modOpCallbackFactory;
    protected final ITupleFilterFactory tupleFilterFactory;

    public IndexInsertUpdateDeleteOperatorNodePushable(IHyracksTaskContext ctx, int partition, IIndexDataflowHelperFactory indexHelperFactory, int[] fieldPermutation, RecordDescriptor inputRecDesc, IndexOperation op, IModificationOperationCallbackFactory modOpCallbackFactory, ITupleFilterFactory tupleFilterFactory) throws HyracksDataException {
        this.ctx = ctx;
        this.indexHelper = indexHelperFactory.create(ctx.getJobletContext().getServiceContext(), partition);
        this.modOpCallbackFactory = modOpCallbackFactory;
        this.tupleFilterFactory = tupleFilterFactory;
        this.inputRecDesc = inputRecDesc;
        this.op = op;
        this.tuple.setFieldPermutation(fieldPermutation);
    }

    public void open() throws HyracksDataException {
        this.accessor = new FrameTupleAccessor(this.inputRecDesc);
        this.writeBuffer = new VSizeFrame((IHyracksFrameMgrContext)this.ctx);
        this.indexHelper.open();
        this.index = this.indexHelper.getIndexInstance();
        try {
            this.writer.open();
            LocalResource resource = this.indexHelper.getResource();
            this.modCallback = this.modOpCallbackFactory.createModificationOperationCallback(resource, this.ctx, (IOperatorNodePushable)this);
            IndexAccessParameters iap = new IndexAccessParameters(this.modCallback, NoOpOperationCallback.INSTANCE);
            this.indexAccessor = this.index.createAccessor((IIndexAccessParameters)iap);
            if (this.tupleFilterFactory != null) {
                this.tupleFilter = this.tupleFilterFactory.createTupleFilter(this.ctx);
                this.frameTuple = new FrameTupleReference();
            }
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        int tupleCount = this.accessor.getTupleCount();
        block13: for (int i = 0; i < tupleCount; ++i) {
            try {
                if (this.tupleFilter != null) {
                    this.frameTuple.reset((IFrameTupleAccessor)this.accessor, i);
                    if (!this.tupleFilter.accept((IFrameTupleReference)this.frameTuple)) continue;
                }
                this.tuple.reset((IFrameTupleAccessor)this.accessor, i);
                switch (this.op) {
                    case INSERT: {
                        try {
                            this.indexAccessor.insert((ITupleReference)this.tuple);
                            break;
                        }
                        catch (HyracksDataException e) {
                            if (e.getErrorCode() == 33) continue block13;
                            throw e;
                        }
                    }
                    case UPDATE: {
                        this.indexAccessor.update((ITupleReference)this.tuple);
                        break;
                    }
                    case UPSERT: {
                        this.indexAccessor.upsert((ITupleReference)this.tuple);
                        break;
                    }
                    case DELETE: {
                        try {
                            this.indexAccessor.delete((ITupleReference)this.tuple);
                            break;
                        }
                        catch (HyracksDataException e) {
                            if (e.getErrorCode() == 37) continue block13;
                            throw e;
                        }
                    }
                    default: {
                        throw new HyracksDataException("Unsupported operation " + (Object)((Object)this.op) + " in tree index InsertUpdateDelete operator");
                    }
                }
                continue;
            }
            catch (HyracksDataException e) {
                throw e;
            }
            catch (Exception e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
        this.writeBuffer.ensureFrameSize(buffer.capacity());
        FrameUtils.copyAndFlip((ByteBuffer)buffer, (ByteBuffer)this.writeBuffer.getBuffer());
        FrameUtils.flushFrame((ByteBuffer)this.writeBuffer.getBuffer(), (IFrameWriter)this.writer);
    }

    public void close() throws HyracksDataException {
        if (this.index != null) {
            try {
                this.writer.close();
            }
            finally {
                this.indexHelper.close();
            }
        }
    }

    public void fail() throws HyracksDataException {
        if (this.index != null) {
            this.writer.fail();
        }
    }

    public void flush() throws HyracksDataException {
        this.writer.flush();
    }
}

