/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.aql.rewrites.visitor;

import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.aql.visitor.base.AbstractAqlSimpleExpressionVisitor;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class AqlFunctionCallResolverVisitor
extends AbstractAqlSimpleExpressionVisitor {
    private final MetadataProvider metadataProvider;
    private final Set<FunctionSignature> declaredFunctions;
    private final BiFunction<String, Integer, FunctionSignature> callExprResolver;

    public AqlFunctionCallResolverVisitor(MetadataProvider metadataProvider, List<FunctionDecl> declaredFunctions) {
        this.metadataProvider = metadataProvider;
        this.declaredFunctions = FunctionUtil.getFunctionSignatures(declaredFunctions);
        this.callExprResolver = this.createBuiltinFunctionResolver(metadataProvider);
    }

    @Override
    public Expression visit(CallExpr callExpr, ILangExpression arg) throws CompilationException {
        FunctionSignature fs = FunctionUtil.resolveFunctionCall((FunctionSignature)callExpr.getFunctionSignature(), (SourceLocation)callExpr.getSourceLocation(), (MetadataProvider)this.metadataProvider, this.declaredFunctions, this.callExprResolver);
        callExpr.setFunctionSignature(fs);
        return super.visit(callExpr, arg);
    }

    protected BiFunction<String, Integer, FunctionSignature> createBuiltinFunctionResolver(MetadataProvider metadataProvider) {
        return FunctionUtil.createBuiltinFunctionResolver((MetadataProvider)metadataProvider);
    }
}

