/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.sync;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.ReplicationException;
import org.apache.asterix.replication.api.PartitionReplica;
import org.apache.asterix.replication.management.NetworkingUtil;
import org.apache.asterix.replication.messaging.DeleteFileTask;
import org.apache.asterix.replication.messaging.ReplicateFileTask;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.network.ISocketChannel;

public class FileSynchronizer {
    private final INcApplicationContext appCtx;
    private final PartitionReplica replica;

    public FileSynchronizer(INcApplicationContext appCtx, PartitionReplica replica) {
        this.appCtx = appCtx;
        this.replica = replica;
    }

    public void replicate(String file) {
        this.replicate(file, false);
    }

    public void replicate(String file, boolean metadata) {
        try {
            IIOManager ioManager = this.appCtx.getIoManager();
            ISocketChannel channel = this.replica.getChannel();
            FileReference filePath = ioManager.resolve(file);
            ReplicateFileTask task = new ReplicateFileTask(file, filePath.getFile().length(), metadata);
            ReplicationProtocol.sendTo(this.replica, task);
            try (RandomAccessFile fromFile = new RandomAccessFile(filePath.getFile(), "r");
                 FileChannel fileChannel = fromFile.getChannel();){
                NetworkingUtil.sendFile(fileChannel, channel);
            }
            ReplicationProtocol.waitForAck(this.replica);
        }
        catch (IOException e) {
            throw new ReplicationException((Throwable)e);
        }
    }

    public void delete(String file) {
        try {
            DeleteFileTask task = new DeleteFileTask(file);
            ReplicationProtocol.sendTo(this.replica, task);
            ReplicationProtocol.waitForAck(this.replica);
        }
        catch (IOException e) {
            throw new ReplicationException((Throwable)e);
        }
    }
}

