/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.std;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABinary;
import org.apache.asterix.om.base.AMutableBinary;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.aggregates.base.AbstractAggregateFunctionDynamicDescriptor;
import org.apache.asterix.runtime.aggregates.std.AbstractAggregateFunction;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.ByteArrayPointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.marshalling.ByteArraySerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.IntArraySerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;

public class RangeMapAggregateDescriptor
extends AbstractAggregateFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    private boolean[] ascFlags;
    private int numPartitions;
    private int numOrderFields;
    private IAType[] argsTypes;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new RangeMapAggregateDescriptor();
        }

        public IFunctionTypeInferer createFunctionTypeInferer() {
            return FunctionTypeInferers.SET_SORTING_PARAMETERS;
        }
    };

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.RANGE_MAP;
    }

    public void setImmutableStates(Object ... states) {
        this.numPartitions = (Integer)states[0];
        this.ascFlags = (boolean[])states[1];
        this.numOrderFields = this.ascFlags.length;
        this.argsTypes = (IAType[])states[2];
    }

    public IAggregateEvaluatorFactory createAggregateEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IAggregateEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IAggregateEvaluator createAggregateEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new RangeMapFunction(args, ctx, RangeMapAggregateDescriptor.this.ascFlags, RangeMapAggregateDescriptor.this.numPartitions, RangeMapAggregateDescriptor.this.numOrderFields, RangeMapAggregateDescriptor.this.sourceLoc, RangeMapAggregateDescriptor.this.argsTypes);
            }
        };
    }

    private static class RangeMapFunction
    extends AbstractAggregateFunction {
        private ISerializerDeserializer<ABinary> binarySerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABINARY);
        private final AMutableBinary binary = new AMutableBinary(null, 0, 0);
        private final List<List<byte[]>> finalSamples = new ArrayList<List<byte[]>>();
        private final ArrayBackedValueStorage storage = new ArrayBackedValueStorage();
        private final IPointable input = new VoidPointable();
        private final ByteArrayPointable rangeMapPointable = new ByteArrayPointable();
        private final IScalarEvaluator localSamplesEval;
        private final Comparator<List<byte[]>> comparator;
        private final int numOfPartitions;
        private final int numOrderByFields;

        private RangeMapFunction(IScalarEvaluatorFactory[] args, IEvaluatorContext context, boolean[] ascending, int numOfPartitions, int numOrderByFields, SourceLocation sourceLocation, IAType[] argsTypes) throws HyracksDataException {
            super(sourceLocation);
            this.localSamplesEval = args[0].createScalarEvaluator(context);
            this.comparator = RangeMapFunction.createComparator(ascending, argsTypes);
            this.numOfPartitions = numOfPartitions;
            this.numOrderByFields = numOrderByFields;
        }

        public void init() throws HyracksDataException {
            this.finalSamples.clear();
        }

        public void step(IFrameTupleReference tuple) throws HyracksDataException {
            this.localSamplesEval.evaluate(tuple, this.input);
            if (this.input.getByteArray()[this.input.getStartOffset()] == ATypeTag.SERIALIZED_SYSTEM_NULL_TYPE_TAG) {
                return;
            }
            this.rangeMapPointable.set(this.input.getByteArray(), this.input.getStartOffset() + 1, this.input.getLength() - 1);
            byte[] rangeMapBytes = this.rangeMapPointable.getByteArray();
            int pointer = this.rangeMapPointable.getContentStartOffset();
            int numSamples = IntegerPointable.getInteger((byte[])rangeMapBytes, (int)pointer);
            pointer += 4;
            for (int i = 0; i < numSamples; ++i) {
                ArrayList<byte[]> oneSample = new ArrayList<byte[]>(this.numOrderByFields);
                for (int j = 0; j < this.numOrderByFields; ++j) {
                    int valueLength = IntegerPointable.getInteger((byte[])rangeMapBytes, (int)pointer);
                    oneSample.add(Arrays.copyOfRange(rangeMapBytes, pointer += 4, pointer + valueLength));
                    pointer += valueLength;
                }
                this.finalSamples.add(oneSample);
            }
        }

        public void finish(IPointable result) throws HyracksDataException {
            int[] endOffsets;
            this.storage.reset();
            DataOutput allSplitValuesOut = this.storage.getDataOutput();
            try {
                if (this.finalSamples.isEmpty()) {
                    endOffsets = new int[this.numOrderByFields];
                    for (int sortField = 0; sortField < this.numOrderByFields; ++sortField) {
                        allSplitValuesOut.write(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
                        endOffsets[sortField] = this.storage.getLength();
                    }
                } else {
                    this.finalSamples.sort(this.comparator);
                    int nextSplitOffset = (int)Math.ceil((double)this.finalSamples.size() / (double)this.numOfPartitions);
                    int nextSplitIndex = nextSplitOffset - 1;
                    int endOffsetsCounter = 0;
                    int numRequiredSplits = this.numOfPartitions - 1;
                    endOffsets = new int[numRequiredSplits * this.numOrderByFields];
                    for (int split = 1; split <= numRequiredSplits; ++split) {
                        List<byte[]> sample = this.finalSamples.get(nextSplitIndex);
                        for (int column = 0; column < sample.size(); ++column) {
                            allSplitValuesOut.write(sample.get(column));
                            endOffsets[endOffsetsCounter++] = this.storage.getLength();
                        }
                        if ((nextSplitIndex += nextSplitOffset) < this.finalSamples.size()) continue;
                        nextSplitIndex = this.finalSamples.size() - 1;
                    }
                }
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            this.serializeRangeMap(this.numOrderByFields, this.storage.getByteArray(), endOffsets, result);
        }

        public void finishPartial(IPointable result) throws HyracksDataException {
            this.finish(result);
        }

        private static Comparator<List<byte[]>> createComparator(boolean[] asc, IAType[] types) {
            IBinaryComparator[] fieldsComparators = new IBinaryComparator[asc.length];
            int i = 0;
            for (int fieldIdx = 1; fieldIdx < types.length; ++fieldIdx) {
                fieldsComparators[i] = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)types[fieldIdx], (Object)types[fieldIdx], asc[i]).createBinaryComparator();
                ++i;
            }
            return (splitPoint1, splitPoint2) -> {
                try {
                    int numFields = splitPoint1.size();
                    int result = 0;
                    for (int i = 0; i < numFields; ++i) {
                        byte[] field2;
                        byte[] field1 = (byte[])splitPoint1.get(i);
                        result = fieldsComparators[i].compare(field1, 0, field1.length, field2 = (byte[])splitPoint2.get(i), 0, field2.length);
                        if (result == 0) continue;
                        return result;
                    }
                    return result;
                }
                catch (HyracksDataException e) {
                    throw new IllegalStateException(e);
                }
            };
        }

        private void serializeRangeMap(int numberFields, byte[] splitValues, int[] endOffsets, IPointable result) throws HyracksDataException {
            ArrayBackedValueStorage serRangeMap = new ArrayBackedValueStorage();
            IntegerSerializerDeserializer.write((int)numberFields, (DataOutput)serRangeMap.getDataOutput());
            ByteArraySerializerDeserializer.write((byte[])splitValues, (DataOutput)serRangeMap.getDataOutput());
            IntArraySerializerDeserializer.write((int[])endOffsets, (DataOutput)serRangeMap.getDataOutput());
            this.binary.setValue(serRangeMap.getByteArray(), serRangeMap.getStartOffset(), serRangeMap.getLength());
            this.storage.reset();
            this.binarySerde.serialize((Object)this.binary, this.storage.getDataOutput());
            result.set((IValueReference)this.storage);
        }
    }
}

